/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.L10nTextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MultiLingualWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.RateMoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.custom.DateCorrectionWidget;
import com.gridnine.xtrip.client.fx.standard.custom.ProductPeriodDataWidget;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentCustomParameterVM;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.FilterHelper;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AddServiceTypeNomenclatureRuleResult;
import com.gridnine.xtrip.common.model.booking.CategoryFeeNomenclatureRuleResult;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductDateData;
import com.gridnine.xtrip.common.model.booking.ProductDateType;
import com.gridnine.xtrip.common.model.booking.ProductPeriodType;
import com.gridnine.xtrip.common.model.booking.TaxesNomenclatureRuleResult;
import com.gridnine.xtrip.common.model.booking.TaxesWithVatRateNomenclatureRuleResult;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelPreferredPriority;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelSubProvider;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FiscalCategory;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentDataPanel;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineSellType;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.ServiceClassCommissionsRuleResultValue;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.model.system.ServiceClassCommissionType;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public enum StandardRuleResultValueRenderer implements NodeRenderer
{
    SIMPLE_PRICE{

        public Node createNode(boolean readonly) {
            return new MoneyValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            RuleResultValue ruleResultValue = new RuleResultValue();
            Money money = ((MoneyValueWidget)node).getValue();
            ruleResultValue.setValue(money.getValue() == null ? 0.0 : money.getValue().doubleValue());
            ruleResultValue.setCurrencyCode(money.getCurrency());
            return ruleResultValue;
        }

        public void setValue(Node node, Object value) {
            Money money = new Money();
            if (value instanceof RuleResultValue) {
                RuleResultValue ruleResultValue = (RuleResultValue)value;
                money.setValue(BigDecimal.valueOf(ruleResultValue.getValue()));
                String currencyCode = ruleResultValue.getCurrencyCode();
                if (currencyCode == null || StandardRuleResultValueRenderer.PERCENT.equals(currencyCode)) {
                    currencyCode = Prefetched.getData().getEquivalentCurrency();
                }
                money.setCurrency(currencyCode);
            } else if (value instanceof Money) {
                money = (Money)value;
            } else {
                Object[] pair = (Object[])value;
                money.setValue(value == null ? null : BigDecimal.valueOf((Double)pair[0]));
                money.setCurrency(value == null ? Prefetched.getData().getEquivalentCurrency() : (String)pair[1]);
            }
            ((MoneyValueWidget)node).setValue(money);
        }
    }
    ,
    SIMPLE_PERCENT{

        public Node createNode(boolean readonly) {
            BorderPane pane = new BorderPane();
            DoubleValueWidget widget = new DoubleValueWidget(readonly);
            Label label = new Label(StandardRuleResultValueRenderer.PERCENT);
            label.getStyleClass().add((Object)"xtrip-rules-label");
            pane.setCenter((Node)widget);
            pane.setRight((Node)label);
            return pane;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            Pane pane = (Pane)node;
            DoubleValueWidget widget = (DoubleValueWidget)pane.getChildren().get(0);
            RuleResultValue ruleResultValue = new RuleResultValue();
            Double percent = (Double)widget.getValue();
            ruleResultValue.setValue(percent == null ? 0.0 : percent);
            ruleResultValue.setCurrencyCode(StandardRuleResultValueRenderer.PERCENT);
            return ruleResultValue;
        }

        public void setValue(Node node, Object value) {
            RuleResultValue ruleResultValue = (RuleResultValue)value;
            if (ruleResultValue != null && ruleResultValue.getCurrencyCode() == null) {
                ruleResultValue.setCurrencyCode(StandardRuleResultValueRenderer.PERCENT);
            }
            if (ruleResultValue != null && !StandardRuleResultValueRenderer.PERCENT.equals(ruleResultValue.getCurrencyCode())) {
                ruleResultValue.setValue(0.0);
            }
            Pane pane = (Pane)node;
            DoubleValueWidget widget = (DoubleValueWidget)pane.getChildren().get(0);
            widget.setValue((Number)(ruleResultValue == null ? 0.0 : ruleResultValue.getValue()));
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            Pane pane = (Pane)node;
            ((HasViewState)pane.getChildren().get(0)).getViewState().setReadonly(readonly);
        }
    }
    ,
    PRICE_CURRENCY_PERCENT{

        public Node createNode(boolean readonly) {
            return new RateMoneyValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((RateMoneyValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            RateMoney money = (RateMoney)value;
            ((RateMoneyValueWidget)node).setValue(money);
        }
    }
    ,
    PRICE_AND_TYPE{

        public Node createNode(boolean readonly) {
            CurrencyValueWidget currencyField = new CurrencyValueWidget(readonly);
            currencyField.setNoNulls(true);
            currencyField.setPercentOption(true);
            ComboBoxWidget typeField = new ComboBoxWidget(readonly);
            typeField.setItemsSupplier(Suppliers.createEnumSupplier(ServiceClassCommissionType.class));
            Label label1 = new Label(Messages.Currency_dvoetochi);
            label1.getStyleClass().add((Object)"xtrip-rules-label");
            Label label2 = new Label(Messages.Type_dvoetochi);
            label2.getStyleClass().add((Object)"xtrip-rules-label");
            HBox pane = new HBox();
            pane.getChildren().setAll((Object[])new Node[]{label1, currencyField, label2, typeField});
            return pane;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            ServiceClassCommissionsRuleResultValue value = new ServiceClassCommissionsRuleResultValue();
            Pane pane = (Pane)node;
            CurrencyValueWidget currencyField = (CurrencyValueWidget)pane.getChildren().get(1);
            String currencyCode = currencyField.getValue();
            if (currencyField.isPercent()) {
                currencyCode = StandardRuleResultValueRenderer.PERCENT;
            }
            ComboBoxWidget typeField = (ComboBoxWidget)pane.getChildren().get(3);
            value.setCurrencyCode(currencyCode);
            value.setCommissionType((ServiceClassCommissionType)typeField.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            ServiceClassCommissionsRuleResultValue commissionValue = (ServiceClassCommissionsRuleResultValue)value;
            if (commissionValue != null) {
                Pane pane = (Pane)node;
                CurrencyValueWidget currencyField = (CurrencyValueWidget)pane.getChildren().get(1);
                currencyField.setCurrencyCode(commissionValue.getCurrencyCode());
                ComboBoxWidget typeField = (ComboBoxWidget)pane.getChildren().get(3);
                typeField.setValue((Object)commissionValue.getCommissionType());
            }
        }
    }
    ,
    SIMPLE_BOOLEAN{

        public Node createNode(boolean readonly) {
            return new BooleanValueWidget(true, readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((BooleanValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((BooleanValueWidget)node).setValue(value != null ? (Boolean)value : false);
        }
    }
    ,
    SIMPLE_TEXT{

        public Node createNode(boolean readonly) {
            return new TextFieldWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((TextFieldWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((TextFieldWidget)node).setValue((String)value);
        }
    }
    ,
    STRING_LIST{

        public Node createNode(boolean readonly) {
            return new TextFieldWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            String str = ((TextFieldWidget)node).getValue();
            if (str == null) {
                return new ArrayList();
            }
            String res = str.replace(';', ',');
            return Arrays.asList(res.split(","));
        }

        public void setValue(Node node, Object value) {
            ArrayList<String> valueList = null;
            if (value instanceof List) {
                valueList = (ArrayList<String>)value;
            } else if (value instanceof String) {
                valueList = new ArrayList<String>(1);
                valueList.add((String)value);
            }
            if (valueList != null) {
                StringBuilder sb = new StringBuilder();
                valueList.stream().filter(Objects::nonNull).forEach(el -> {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append((String)el);
                });
                ((TextFieldWidget)node).setValue(sb.toString());
            }
        }
    }
    ,
    INTEGER_LIST{

        public Node createNode(boolean readonly) {
            return new TextFieldWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            String str = ((TextFieldWidget)node).getValue();
            if (str == null) {
                return new ArrayList();
            }
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (String value : str.replace(';', ',').split(",")) {
                try {
                    result.add(Integer.parseInt(value));
                }
                catch (Exception e) {
                    Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.incorrectDataFormat_notInteger, (Object[])new Object[]{value})});
                }
            }
            return result;
        }

        public void setValue(Node node, Object value) {
            ArrayList<Integer> valueList = null;
            if (value instanceof List) {
                valueList = (ArrayList<Integer>)value;
            } else if (value instanceof Integer) {
                valueList = new ArrayList<Integer>(1);
                valueList.add((Integer)value);
            }
            if (valueList != null) {
                ((TextFieldWidget)node).setValue(valueList.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(",")));
            }
        }
    }
    ,
    TICKET_DESIGNATOR{

        public Node createNode(boolean readonly) {
            BorderPane pane = new BorderPane();
            Label label = new Label(Messages.With_designator);
            label.getStyleClass().add((Object)"xtrip-rules-label");
            pane.setLeft((Node)label);
            pane.setCenter((Node)new TextFieldWidget(readonly));
            return pane;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            TripartitePublicFareDiscount value = new TripartitePublicFareDiscount();
            TextFieldWidget widget = this.findWidget(node);
            value.setTicketDesignator(widget.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            TripartitePublicFareDiscount discount = (TripartitePublicFareDiscount)value;
            TextFieldWidget widget = this.findWidget(node);
            widget.setValue(discount == null ? null : discount.getTicketDesignator());
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            TextFieldWidget widget = this.findWidget(node);
            widget.getViewState().setReadonly(readonly);
        }

        private TextFieldWidget findWidget(Node node) {
            return (TextFieldWidget)((Pane)node).getChildren().get(1);
        }
    }
    ,
    SIMPLE_DOUBLE{

        public Node createNode(boolean readonly) {
            return new DoubleValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DoubleValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((DoubleValueWidget)node).setValue((Number)((Double)value));
        }
    }
    ,
    SIMPLE_INTEGER{

        public Node createNode(boolean readonly) {
            return new IntValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((IntValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((IntValueWidget)node).setValue((Number)((Integer)value));
        }
    }
    ,
    COMMISSION_PROPERTIES_ENTITY_BOX{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(BaseCommissionProperties.class, readonly);
            widget.setFieldName(Messages.Commission_settings);
            widget.setListParametersSupplier(FilterHelper.getCommissionPropertiesMultiSupplier());
            return widget;
        }

        public Object getValue(Node node) {
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            EntityReference ref = (EntityReference)value;
            ((EntityBoxWidget)node).setValue(ref);
        }
    }
    ,
    MULTILINGUAL_ENTITY_BOX{

        public Node createNode(boolean readonly) {
            MultiLingualWidget widget = new MultiLingualWidget(readonly);
            widget.setFieldName(Messages.BrandName);
            return widget;
        }

        public Object getValue(Node node) {
            return ((MultiLingualWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((MultiLingualWidget)node).setValue((L10nString)value);
        }
    }
    ,
    L10N_TEXT{

        public Node createNode(boolean readonly) {
            L10nTextAreaWidget widget = new L10nTextAreaWidget(readonly);
            widget.setNotExpandable(true);
            PopupWidget popup = new PopupWidget();
            popup.setInfoText(Messages.Text);
            popup.setView((Node)widget);
            return popup;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((L10nTextAreaWidget)((PopupWidget)node).getView()).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((L10nTextAreaWidget)((PopupWidget)node).getView()).setValue((L10nString)value);
        }
    }
    ,
    CALCULATION_INDICATOR_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget comboBox = new ComboBoxWidget(readonly);
            comboBox.setItemsSupplier(Suppliers.createEnumSupplier(TripartiteContractCalculationIndicatorType.class));
            return new StackPane(new Node[]{comboBox});
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            ComboBoxWidget comboBox = (ComboBoxWidget)((StackPane)node).getChildren().get(0);
            return comboBox.getValue();
        }

        public void setValue(Node node, Object value) {
            StackPane pane = (StackPane)node;
            ComboBoxWidget comboBox = (ComboBoxWidget)pane.getChildren().get(0);
            comboBox.setValue((Object)((TripartiteContractCalculationIndicatorType)value));
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            StackPane pane = (StackPane)node;
            ((HasViewState)pane.getChildren().get(0)).getViewState().setReadonly(readonly);
        }
    }
    ,
    ROUNDING_MODE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget roundTypeNode = new ComboBoxWidget(readonly);
            roundTypeNode.setItemsSupplier(Suppliers.createEnumSupplier(RoundingMode.class));
            return roundTypeNode;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((RoundingMode)value));
        }
    }
    ,
    ROUNDING_VALUE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget roundValueNode = new ComboBoxWidget(readonly);
            roundValueNode.setItemsSupplier(Suppliers.createEnumSupplier(RoundingValue.class));
            return roundValueNode;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((RoundingValue)value));
        }
    }
    ,
    FISCAL_SELL_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget sellTypeNode = new ComboBoxWidget(readonly);
            sellTypeNode.setItemsSupplier(Suppliers.createEnumSupplier(ReceiptLineSellType.class));
            return sellTypeNode;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((ReceiptLineSellType)value));
        }
    }
    ,
    PAYMENTS_TYPES{

        public Node createNode(boolean readonly) {
            ValuesWidget paymentTypeNode = new ValuesWidget(readonly);
            paymentTypeNode.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
            return paymentTypeNode;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            ObservableList listType = ((ValuesWidget)node).getValues();
            return listType.toArray((Object[])new PaymentType[listType.size()]);
        }

        public void setValue(Node node, Object value) {
            if (value != null) {
                PaymentType[] arrayType = (PaymentType[])value;
                ((ValuesWidget)node).getValues().setAll(Arrays.asList(arrayType));
            }
        }
    }
    ,
    SINGLE_PASSENGER_TYPE{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(PassengerType.class, readonly);
            widget.setFieldName("Passenger type");
            return widget;
        }

        public Object getValue(Node node) {
            if (node != null) {
                return ((DictBoxWidget)node).getValue();
            }
            return null;
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            DictBoxWidget widget = (DictBoxWidget)node;
            widget.setValue((DictionaryReference)value);
        }
    }
    ,
    HOTEL_PROVIDER_LIST{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setKeepSelectionOrder(true);
            widget.setItemsSupplier(() -> Arrays.asList(HotelProvider.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }
    }
    ,
    HOTEL_PROVIDER_ORDERED_LIST{

        public Node createNode(boolean readonly) {
            MultiComboBoxWidget widget = new MultiComboBoxWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.stream(HotelProvider.values()).filter(val -> !widget.getValues().contains(val)).collect(Collectors.toList()), false);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiComboBoxWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((MultiComboBoxWidget)node).getValues().setAll(list);
        }
    }
    ,
    HOTEL_PROVIDER_OR_SUBPROVIDER_LIST{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setKeepSelectionOrder(true);
            ArrayList allItems = new ArrayList();
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            };
            List<HotelProvider> allProviders = Arrays.asList(HotelProvider.values());
            allProviders.sort(c);
            widget.setDisable(true);
            Notifications.get().submitTask(() -> {
                DictQuery dictQuery = new DictQuery();
                dictQuery.getFields().add(BaseDictionary.Property.translations.name());
                List allSubProviders = ((DictService)RpcServiceManager.get().getService(DictService.class)).search(ServiceInvocationContext.get(), HotelSubProvider.class, dictQuery).stream().map(item -> {
                    DictionaryReference result = item.getReference();
                    result.setCaption(DictHelper.toString(item));
                    return result;
                }).collect(Collectors.toList());
                allSubProviders.sort(c);
                allItems.addAll(allProviders);
                allItems.addAll(allSubProviders);
                FxUtil.submitToFxThread(() -> {
                    widget.setItemsSupplier(() -> allItems);
                    widget.setDisable(false);
                });
            }, Messages.Loading_data);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }
    }
    ,
    HOTEL_PREFERRED_PROVIDER_OR_SUBPROVIDER_LIST{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setKeepSelectionOrder(true);
            ArrayList allItems = new ArrayList();
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            };
            List<HotelPreferredPriority> allPriorities = Arrays.asList(HotelPreferredPriority.values());
            allPriorities.sort(c);
            widget.setDisable(true);
            Notifications.get().submitTask(() -> {
                DictQuery dictQuery = new DictQuery();
                dictQuery.getFields().add(BaseDictionary.Property.translations.name());
                List allSubProviders = ((DictService)RpcServiceManager.get().getService(DictService.class)).search(ServiceInvocationContext.get(), HotelSubProvider.class, dictQuery).stream().map(item -> {
                    DictionaryReference result = item.getReference();
                    result.setCaption(DictHelper.toString(item));
                    return result;
                }).collect(Collectors.toList());
                allSubProviders.sort(c);
                allItems.addAll(allPriorities);
                allItems.addAll(allSubProviders);
                FxUtil.submitToFxThread(() -> {
                    widget.setItemsSupplier(() -> allItems);
                    widget.setDisable(false);
                });
            }, Messages.Loading_data);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }
    }
    ,
    HOTEL_PREFERRED_PRIORITY_LIST{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setKeepSelectionOrder(true);
            widget.setItemsSupplier(() -> Arrays.asList(HotelPreferredPriority.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }
    }
    ,
    SHIPMENT_CATEGORY{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(ShipmentCategory.class, readonly);
            widget.setFieldName(Messages.Implementation_category);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DictBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((DictBoxWidget)node).setValue((DictionaryReference)value);
        }
    }
    ,
    FINANCE_DOCUMENT_DATA{

        public Node createNode(boolean readonly) {
            FinanceDocumentDataPanel panel = new FinanceDocumentDataPanel(readonly);
            ArrayList types = new ArrayList(FinanceDocumentsHelper.types);
            types.remove(FinanceDocumentType.INVOICE_PREPAYMENT);
            panel.getTypeNode().setItemsSupplier(() -> types);
            panel.getTypeNode().valueProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
                    panel.getBillingItemIncludeModeNode().setValue(null);
                }
                if (newValue != FinanceDocumentType.UNIVERSAL_DOCUMENT) {
                    panel.getUniversalDocumentStatusNode().setValue(null);
                }
                panel.getBillingItemIncludeModeNode().getViewState().setNotEditable(newValue != FinanceDocumentType.ACCEPTANCE_CERTIFICATE);
                panel.getUniversalDocumentStatusNode().getViewState().setNotEditable(newValue != FinanceDocumentType.UNIVERSAL_DOCUMENT);
            });
            panel.getTemplateNode().setListParametersSupplier(() -> {
                IndexListParameters parameters = new IndexListParameters();
                parameters.setIndexType(TemplateDocumentIndex.class);
                parameters.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
                parameters.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.financeDocumentType.name(), (Object)panel.getTypeNode().getValue()));
                parameters.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
                TableColumnSettings titleColumn = new TableColumnSettings();
                titleColumn.setId(TemplateDocumentIndex.Property.title.name());
                parameters.getColumns().add(titleColumn);
                TableColumnSettings typeColumn = new TableColumnSettings();
                typeColumn.setId(TemplateDocumentIndex.Property.type.name());
                parameters.getColumns().add(typeColumn);
                return parameters;
            });
            panel.getDisableCustomerQuotesNode().setConverter(Converters.boolConverter((String)Messages.disableQuotes, (String)Messages.enableQuotes));
            panel.getNotDisplayTitleContractNumberNode().setConverter(Converters.boolConverter((String)Messages.No, (String)Messages.Yes));
            panel.getNotGroupByServiceTypeNode().setConverter(Converters.boolConverter((String)Messages.No, (String)Messages.Yes));
            panel.getNotGroupByProductNode().setConverter(Converters.boolConverter((String)Messages.No, (String)Messages.Yes));
            PopupWidget popup = new PopupWidget();
            popup.setInfoText(UiUtil.NULL_TEXT);
            popup.setView((Node)panel);
            popup.setDialogCloseHandler(() -> popup.setInfoText(panel.getTypeNode().getValue() != null ? ((FinanceDocumentType)panel.getTypeNode().getValue()).toString() : UiUtil.NULL_TEXT));
            panel.getTypeNode().valueProperty().addListener((observable, oldValue, newValue) -> popup.setInfoText(panel.getTypeNode().getValue() != null ? ((FinanceDocumentType)panel.getTypeNode().getValue()).toString() : UiUtil.NULL_TEXT));
            panel.getTemplateNode().valueProperty().addListener((observable, oldValue, newValue) -> popup.setInfoText(panel.getTypeNode().getValue() != null ? ((FinanceDocumentType)panel.getTypeNode().getValue()).toString() : UiUtil.NULL_TEXT));
            ((TextAreaWidget)panel.getCaptionTemplateCell().getPayload()).setWrapText(true);
            return popup;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            FinanceDocumentData data = new FinanceDocumentData();
            data.setType((FinanceDocumentType)((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getTypeNode().getValue());
            data.setTemplate(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getTemplateNode().getValue());
            data.setBillingItemIncludeMode((BillingItemIncludeMode)((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getBillingItemIncludeModeNode().getValue());
            data.setVatViewMode((VatViewMode)((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getVatViewModeNode().getValue());
            data.setGroupByTraveller(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getGroupByTravellerNode().getValue());
            data.setNotGroupByProduct(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getNotGroupByProductNode().getValue());
            data.setMergeBillingItems(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getMergeBillingItemsNode().getValue());
            data.setUseDelegate(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getUseDelegateNode().getValue());
            data.setUseFacsimile(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getUseFacsimileNode().getValue());
            data.setCaptionTemplate(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getCaptionTemplateNode().getValue());
            data.setDisableCustomerQuotes(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getDisableCustomerQuotesNode().getValue());
            data.setDisplayContract(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getDisplayContractNode().getValue());
            data.setNotDisplayTitleContractNumber(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getNotDisplayTitleContractNumberNode().getValue());
            data.setNotGroupByServiceType(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getNotGroupByServiceTypeNode().getValue());
            data.setInvertSign(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getInvertSignNode().getValue());
            data.setVendorDocument(((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getVendorDocumentNode().getValue());
            data.setUniversalDocumentStatus((UniversalDocumentStatus)((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getUniversalDocumentStatusNode().getValue());
            Collection customParametersVM = ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getCustomParametersNode().getRowsData();
            for (FinanceDocumentCustomParameterVM customParameterVM : customParametersVM) {
                String parameterKey = customParameterVM.getParameterKey();
                String parameterValue = customParameterVM.getParameterValue();
                if (!TextUtil.nonBlank((String)parameterKey) || !TextUtil.nonBlank((String)parameterValue)) continue;
                data.getCustomParameters().put(parameterKey, parameterValue);
            }
            return data;
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            FinanceDocumentData data = (FinanceDocumentData)value;
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getTypeNode().setValue((Object)data.getType());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getTemplateNode().setValue(data.getTemplate());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getBillingItemIncludeModeNode().setValue((Object)data.getBillingItemIncludeMode());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getVatViewModeNode().setValue((Object)data.getVatViewMode());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getGroupByTravellerNode().setValue(data.isGroupByTraveller());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getNotGroupByProductNode().setValue(data.isNotGroupByProduct());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getMergeBillingItemsNode().setValue(data.getMergeBillingItems());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getUseDelegateNode().setValue(data.isUseDelegate());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getUseFacsimileNode().setValue(data.isUseFacsimile());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getCaptionTemplateNode().setValue(data.getCaptionTemplate());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getDisableCustomerQuotesNode().setValue(data.isDisableCustomerQuotes());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getDisplayContractNode().setValue(data.isDisplayContract());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getNotDisplayTitleContractNumberNode().setValue(data.isNotDisplayTitleContractNumber());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getNotGroupByServiceTypeNode().setValue(data.isNotGroupByServiceType());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getInvertSignNode().setValue(data.isInvertSign());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getVendorDocumentNode().setValue(data.isVendorDocument());
            ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getUniversalDocumentStatusNode().setValue((Object)data.getUniversalDocumentStatus());
            for (Map.Entry customParameters : data.getCustomParameters().entrySet()) {
                FinanceDocumentCustomParameterVM customParameterVM = new FinanceDocumentCustomParameterVM();
                customParameterVM.setParameterKey((String)customParameters.getKey());
                customParameterVM.setParameterValue((String)customParameters.getValue());
                ((FinanceDocumentDataPanel)((PopupWidget)node).getView()).getCustomParametersNode().addRow((Object)customParameterVM);
            }
        }
    }
    ,
    INVOICE_PREPAYMENT_DATA{

        public Node createNode(boolean readonly) {
            PopupWidget popup = (PopupWidget)FINANCE_DOCUMENT_DATA.createNode(readonly);
            FinanceDocumentDataPanel panel = (FinanceDocumentDataPanel)popup.getView();
            ComboBoxWidget typeNode = panel.getTypeNode();
            List<FinanceDocumentType> types = Collections.singletonList(FinanceDocumentType.INVOICE_PREPAYMENT);
            typeNode.setItemsSupplier(() -> types);
            typeNode.setValue((Object)FinanceDocumentType.INVOICE_PREPAYMENT);
            typeNode.setDisable(true);
            return popup;
        }

        public Object getValue(Node node) {
            return FINANCE_DOCUMENT_DATA.getValue(node);
        }

        public void setValue(Node node, Object value) {
            FINANCE_DOCUMENT_DATA.setValue(node, value);
        }
    }
    ,
    PRODUCT_DATE_DATA{

        public Node createNode(boolean readonly) {
            ComboBoxWidget productDateTypeNode = new ComboBoxWidget(readonly);
            productDateTypeNode.setItemsSupplier(Suppliers.createEnumSupplier(ProductDateType.class));
            GridCell productDateTypeCell = new GridCell(Messages.baseDate, (Node)productDateTypeNode);
            productDateTypeCell.setHelp(() -> new QuickHelp(Messages.baseDateHelp));
            ComboBoxWidget startWeekDayNode = new ComboBoxWidget(readonly);
            startWeekDayNode.setItemsSupplier(Suppliers.createEnumSupplier(WeekDay.class));
            startWeekDayNode.setSortItems(false);
            GridCell startWeekDayCell = new GridCell(Messages.startWeekDay, (Node)startWeekDayNode);
            startWeekDayCell.setHelp(() -> new QuickHelp(Messages.startWeekDayHelp));
            IntValueWidget intervalValueNode = new IntValueWidget(readonly);
            GridCell intervalValueCell = new GridCell(Messages.intervalValue, (Node)intervalValueNode);
            intervalValueCell.setHelp(() -> new QuickHelp(Messages.intervalValueHelp));
            DateCorrectionWidget dateCorrectionNode = new DateCorrectionWidget(readonly);
            GridCell dateCorrectionCell = new GridCell(Messages.correction, (Node)dateCorrectionNode);
            dateCorrectionCell.setHelp(() -> new QuickHelp(Messages.correctionHelp));
            ProductPeriodDataWidget productPeriodDataNode = new ProductPeriodDataWidget(readonly);
            GridCell productPeriodDataCell = new GridCell(Messages.basePeriod, (Node)productPeriodDataNode);
            productPeriodDataCell.setHelp(() -> new QuickHelp(Messages.basePeriodHelp));
            GridContainer container = new GridContainer(4);
            container.getCells().add((Object)productDateTypeCell);
            container.getCells().add((Object)productPeriodDataCell);
            container.getCells().add((Object)startWeekDayCell);
            container.getCells().add((Object)intervalValueCell);
            container.getCells().add((Object)dateCorrectionCell);
            PopupWidget popup = new PopupWidget();
            popup.setInfoText(UiUtil.NULL_TEXT);
            popup.setView((Node)container);
            productPeriodDataNode.productPeriodTypeProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue == ProductPeriodType.WEEK) {
                    startWeekDayNode.getViewState().setNotEditable(false);
                    startWeekDayNode.setValue((Object)WeekDay.MONDAY);
                } else {
                    startWeekDayNode.getViewState().setNotEditable(true);
                    startWeekDayNode.setValue(null);
                }
                if (newValue == ProductPeriodType.EVERY_N_DAYS_OF_MONTH) {
                    intervalValueNode.getViewState().setNotEditable(false);
                } else {
                    intervalValueNode.getViewState().setNotEditable(true);
                    intervalValueNode.setValue(null);
                }
            });
            ChangeListener listener = (observable, oldValue, newValue) -> popup.setInfoText(productDateTypeNode.getValue() != null ? productDateTypeNode.getValue() + (productPeriodDataNode.getValue() != null ? " (" + (ProductPeriodType.EVERY_N_DAYS_OF_MONTH == productPeriodDataNode.getValue().getProductPeriodType() ? L10n.replace((String)Messages.EveryNDaysOfMonth, (Object[])new Object[]{intervalValueNode.getValue()}) : productPeriodDataNode.getValue().getProductPeriodType() + (startWeekDayNode.getValue() != null ? " / " + startWeekDayNode.getValue() : "")) + (productPeriodDataNode.getValue().isUseAsShipmentPeriod() ? " / " + Messages.UseAsShipmentPeriod : "") + ")" : "") + (dateCorrectionNode.getValue() != null ? " " + String.format("%+d", dateCorrectionNode.getValue().getValue()) + " " + dateCorrectionNode.getValue().getUnit() : "") : UiUtil.NULL_TEXT);
            productDateTypeNode.valueProperty().addListener(listener);
            productPeriodDataNode.productPeriodTypeProperty().addListener(listener);
            productPeriodDataNode.useAsShipmentPeriodProperty().addListener(listener);
            startWeekDayNode.valueProperty().addListener(listener);
            intervalValueNode.valueProperty().addListener(listener);
            dateCorrectionNode.valueProperty().addListener(listener);
            dateCorrectionNode.unitProperty().addListener(listener);
            return popup;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            ProductDateData data = new ProductDateData();
            data.setProductDateType((ProductDateType)((ComboBoxWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(0)).getPayload()).getValue());
            data.setProductPeriodData(((ProductPeriodDataWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(1)).getPayload()).getValue());
            data.setStartWeekDay((WeekDay)((ComboBoxWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(2)).getPayload()).getValue());
            data.setIntervalValue((Integer)((IntValueWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(3)).getPayload()).getValue());
            data.setDateCorrection(((DateCorrectionWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(4)).getPayload()).getValue());
            return data;
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ProductDateData data = (ProductDateData)value;
            ((ComboBoxWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(0)).getPayload()).setValue((Object)data.getProductDateType());
            ((ProductPeriodDataWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(1)).getPayload()).setValue(data.getProductPeriodData());
            ((ComboBoxWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(2)).getPayload()).setValue((Object)data.getStartWeekDay());
            ((IntValueWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(3)).getPayload()).setValue((Number)data.getIntervalValue());
            ((DateCorrectionWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(4)).getPayload()).setValue(data.getDateCorrection());
        }
    }
    ,
    ALL_PERSONS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Person.class, readonly);
            widget.setFieldName(Messages.Notification_action_from_profiles_list_name);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getPersonsSortByName);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((MultiEntityWidget)node).getValues();
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                MultiEntityWidget widget = (MultiEntityWidget)node;
                widget.getValues().clear();
                widget.getValues().addAll((Collection)((List)value));
            }
        }
    }
    ,
    SUPPLIER{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(Organization.class, readonly);
            widget.setFieldName("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a");
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getSuppliers);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                ((EntityBoxWidget)node).setValue((EntityReference)value);
            }
        }
    }
    ,
    PAYMENT_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget paymentTypeNode = new ComboBoxWidget(readonly);
            paymentTypeNode.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
            return paymentTypeNode;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            PaymentType paymentType = (PaymentType)((ComboBoxWidget)node).getValue();
            return paymentType;
        }

        public void setValue(Node node, Object value) {
            if (value != null) {
                PaymentType paymentType = (PaymentType)value;
                ((ComboBoxWidget)node).setValue((Object)paymentType);
            }
        }
    }
    ,
    NOMENCLATURE{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(Nomenclature.class, readonly);
            widget.setFieldName(Messages.nomenclature);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DictBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((DictBoxWidget)node).setValue((DictionaryReference)value);
        }
    }
    ,
    TAXES_NOMENCLATURE{

        public Node createNode(boolean readonly) {
            GridContainer container = new GridContainer(5);
            DictBoxWidget nomenclatureWidget = new DictBoxWidget(Nomenclature.class, readonly);
            TextFieldWidget taxesWidget = new TextFieldWidget(readonly);
            GridCell cell = new GridCell((Node)taxesWidget);
            cell.setCaption(Messages.standardRuleResultValueRenderer_tax);
            container.getCells().add((Object)cell);
            cell = new GridCell((Node)nomenclatureWidget);
            cell.setCaption(Messages.standardRuleResultValueRenderer_nomenclature);
            cell.setColSpan(4);
            container.getCells().add((Object)cell);
            return container;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            TextFieldWidget taxesWidget = (TextFieldWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            TaxesNomenclatureRuleResult value = new TaxesNomenclatureRuleResult();
            value.setNomenclature(nomenclatureWidget.getValue());
            value.setTaxes(taxesWidget.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            TextFieldWidget taxesWidget = (TextFieldWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            TaxesNomenclatureRuleResult taxesNomenclature = (TaxesNomenclatureRuleResult)value;
            nomenclatureWidget.setValue(taxesNomenclature.getNomenclature());
            taxesWidget.setValue(taxesNomenclature.getTaxes());
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            if (node == null) {
                return;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            TextFieldWidget taxesWidget = (TextFieldWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            super.setReadonly(readonly, (Node)nomenclatureWidget);
            super.setReadonly(readonly, (Node)taxesWidget);
        }
    }
    ,
    TAXES_WITH_VAT_RATE_NOMENCLATURE{

        public Node createNode(boolean readonly) {
            GridContainer container = new GridContainer(5);
            ComboBoxWidget vatRateWidget = new ComboBoxWidget(readonly);
            vatRateWidget.setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
            vatRateWidget.setConverter(ControllerInterceptorVatHelper.vatConverter);
            vatRateWidget.setNoNulls(true);
            vatRateWidget.setPromptText(null);
            DictBoxWidget nomenclatureWidget = new DictBoxWidget(Nomenclature.class, readonly);
            GridCell cell = new GridCell((Node)vatRateWidget);
            cell.setCaption(Messages.standardRuleResultValueRenderer_vatRate);
            container.getCells().add((Object)cell);
            cell = new GridCell((Node)nomenclatureWidget);
            cell.setCaption(Messages.standardRuleResultValueRenderer_nomenclature);
            cell.setColSpan(4);
            container.getCells().add((Object)cell);
            return container;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            ComboBoxWidget vatRateWidget = (ComboBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            TaxesWithVatRateNomenclatureRuleResult value = new TaxesWithVatRateNomenclatureRuleResult();
            value.setVatRate((Double)vatRateWidget.getValue());
            value.setNomenclature(nomenclatureWidget.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ComboBoxWidget vatRateWidget = (ComboBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            TaxesWithVatRateNomenclatureRuleResult result = (TaxesWithVatRateNomenclatureRuleResult)value;
            vatRateWidget.setValue((Object)result.getVatRate());
            nomenclatureWidget.setValue(result.getNomenclature());
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            if (node == null) {
                return;
            }
            ComboBoxWidget vatRateWidget = (ComboBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            super.setReadonly(readonly, (Node)nomenclatureWidget);
            super.setReadonly(readonly, (Node)vatRateWidget);
        }
    }
    ,
    ADD_SERVICE_TYPE_NOMENCLATURE{

        public Node createNode(boolean readonly) {
            GridContainer container = new GridContainer(2);
            DictBoxWidget nomenclatureWidget = new DictBoxWidget(Nomenclature.class, readonly);
            ComboBoxWidget serviceTypeWidget = new ComboBoxWidget(readonly);
            serviceTypeWidget.setItemsSupplier(Suppliers.createEnumSupplier(AdditionalServiceType.class));
            GridCell cell = new GridCell((Node)serviceTypeWidget);
            cell.setCaption("\u0422\u0438\u043f \u0443\u0441\u043b\u0443\u0433\u0438");
            container.getCells().add((Object)cell);
            cell = new GridCell((Node)nomenclatureWidget);
            cell.setCaption("\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0430");
            container.getCells().add((Object)cell);
            return container;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            ComboBoxWidget serviceTypeWidget = (ComboBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            AddServiceTypeNomenclatureRuleResult value = new AddServiceTypeNomenclatureRuleResult();
            value.setNomenclature(nomenclatureWidget.getValue());
            value.setServiceType((AdditionalServiceType)serviceTypeWidget.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            ComboBoxWidget serviceTypeWidget = (ComboBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            AddServiceTypeNomenclatureRuleResult ruleResult = (AddServiceTypeNomenclatureRuleResult)value;
            nomenclatureWidget.setValue(ruleResult.getNomenclature());
            serviceTypeWidget.setValue((Object)ruleResult.getServiceType());
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            if (node == null) {
                return;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            ComboBoxWidget serviceTypeWidget = (ComboBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            super.setReadonly(readonly, (Node)nomenclatureWidget);
            super.setReadonly(readonly, (Node)serviceTypeWidget);
        }
    }
    ,
    CATEGORY_FEE_NOMENCLATURE{

        public Node createNode(boolean readonly) {
            GridContainer container = new GridContainer(2);
            DictBoxWidget nomenclatureWidget = new DictBoxWidget(Nomenclature.class, readonly);
            DictBoxWidget categoryWidget = new DictBoxWidget(CommissionCategory.class, readonly);
            GridCell cell = new GridCell((Node)categoryWidget);
            cell.setCaption("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0441\u0431\u043e\u0440\u0430");
            container.getCells().add((Object)cell);
            cell = new GridCell((Node)nomenclatureWidget);
            cell.setCaption("\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0430");
            container.getCells().add((Object)cell);
            return container;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            DictBoxWidget categoryWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            CategoryFeeNomenclatureRuleResult value = new CategoryFeeNomenclatureRuleResult();
            value.setNomenclature(nomenclatureWidget.getValue());
            value.setCategory(categoryWidget.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            DictBoxWidget categoryWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            CategoryFeeNomenclatureRuleResult ruleResult = (CategoryFeeNomenclatureRuleResult)value;
            nomenclatureWidget.setValue(ruleResult.getNomenclature());
            categoryWidget.setValue(ruleResult.getCategory());
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            if (node == null) {
                return;
            }
            DictBoxWidget nomenclatureWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 1);
            DictBoxWidget categoryWidget = (DictBoxWidget)StandardRuleResultValueRenderer.getGridContainerNode(node, 0);
            super.setReadonly(readonly, (Node)nomenclatureWidget);
            super.setReadonly(readonly, (Node)categoryWidget);
        }
    }
    ,
    BLANK_OWNER{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(Organization.class, readonly);
            widget.setFieldName("\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u043e\u0432");
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                ((EntityBoxWidget)node).setValue((EntityReference)value);
            }
        }
    }
    ,
    FISCAL_RECEIPT_CATEGORY{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(FiscalCategory.class, readonly);
            widget.setFieldName(Messages.Implementation_category);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DictBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((DictBoxWidget)node).setValue((DictionaryReference)value);
        }
    }
    ,
    MCO_CATEGORIES{

        public Node createNode(boolean readonly) {
            ValuesWidget mcoCategoryNode = new ValuesWidget(readonly);
            mcoCategoryNode.setItemsSupplier(() -> Arrays.asList(MCOCategory.values()));
            return mcoCategoryNode;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            ObservableList listType = ((ValuesWidget)node).getValues();
            return listType.toArray((Object[])new MCOCategory[listType.size()]);
        }

        public void setValue(Node node, Object value) {
            if (value != null) {
                MCOCategory[] arrayType = (MCOCategory[])value;
                ((ValuesWidget)node).getValues().setAll(Arrays.asList(arrayType));
            }
        }
    }
    ,
    PAYER{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(Organization.class, readonly);
            widget.setFieldName(Messages.Payer);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getPayers);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                ((EntityBoxWidget)node).setValue((EntityReference)value);
            }
        }
    }
    ,
    HOTEL_VENDOR_CONTRACT{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(Contract.class, readonly);
            widget.setFieldName("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u043e\u043c");
            widget.setListParametersSupplier(() -> {
                IndexListParameters result = new IndexListParameters();
                result.setIndexType(ContractIndex.class);
                result.getSortings().put(ContractIndex.Property.name.name(), SortOrder.ASC);
                result.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.VENDOR));
                result.getSearchCriterions().add(SearchCriterion.ne((String)ContractIndex.Property.provider.name(), null));
                ListParametersHelper.setFilters(result, ContractIndex.Property.name.name(), ContractIndex.Property.vendor.name(), ContractIndex.Property.provider.name(), ContractIndex.Property.supplier.name());
                ListParametersHelper.setColumns(result, ContractIndex.Property.name.name(), ContractIndex.Property.vendor.name(), ContractIndex.Property.provider.name(), ContractIndex.Property.supplier.name());
                return result;
            });
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                ((EntityBoxWidget)node).setValue((EntityReference)value);
            }
        }
    };

    private static final String PERCENT = "%";

    public void setReadonly(boolean readonly, Node node) {
        ((HasViewState)node).getViewState().setReadonly(readonly);
    }

    private static Node getGridContainerNode(Node node, int index) {
        GridContainer container = (GridContainer)node;
        ObservableList listCells = container.getCells();
        GridCell cell = (GridCell)listCells.get(index);
        return cell.getPayload();
    }
}

