/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MultiLingualWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiDictWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.pair.PairWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.pair.PairWidgetHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.FilterHelper;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.common.fx.model.UniversalProductDescriptionData;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressClassOfService;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentTypeData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.SpecialTariff;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.FlightDistance;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouchType;
import com.gridnine.xtrip.common.model.booking.timelimit.TimeLimitTypeAndTime;
import com.gridnine.xtrip.common.model.booking.visa.VisaEntryType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelSubProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelType;
import com.gridnine.xtrip.common.model.delivery.DeliveryRegion;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.dict.visa.VisaType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptDataType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.BranchIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ProfileType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.UDIDRestriction;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;
import javafx.util.converter.BooleanStringConverter;

public enum StandardRuleValueRenderers implements RuleValueRenderer
{
    NULL{

        public Node createNode(boolean readonly) {
            StackPane node = new StackPane();
            node.getStyleClass().add((Object)"stub-widget");
            return node;
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public void writeData(RuleRestriction model, Node node) {
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return true;
        }
    }
    ,
    STRING{

        public Node createNode(boolean readonly) {
            return new TextFieldWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            String text = ((TextFieldWidget)node).getValue();
            if (TextUtil.isBlank((String)text)) {
                return null;
            }
            return text;
        }

        public void setValue(Node node, Object value) {
            if (node != null) {
                ((TextFieldWidget)node).setValue((String)value);
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            TextFieldWidget widget = (TextFieldWidget)node;
            return widget.getValue() == null || widget.getValue().trim().isEmpty();
        }
    }
    ,
    STRING_LIST{

        public Node createNode(boolean readonly) {
            return new TextFieldWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            String text = ((TextFieldWidget)node).getValue();
            if (TextUtil.isBlank((String)text)) {
                return null;
            }
            return RulesHelper.toStringCollection((Object)text);
        }

        public void setValue(Node node, Object value) {
            ((TextFieldWidget)node).setValue(RulesHelper.toString(this.convertValue(value)));
        }

        private List<String> convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof L10nString) {
                return new ArrayList<String>(((L10nString)value).getValues().values());
            }
            if (value instanceof String) {
                return RulesHelper.toStringCollection((Object)value);
            }
            return (List)value;
        }

        @Override
        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            TextFieldWidget widget = (TextFieldWidget)node;
            return widget.getValue() == null || widget.getValue().trim().isEmpty();
        }
    }
    ,
    DATE{

        public Node createNode(boolean readonly) {
            return new DateValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DateValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((DateValueWidget)node).setValue((LocalDate)value);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    DATE_INTERVAL{

        public Node createNode(boolean readonly) {
            return new PairWidget(PairWidgetHandler.DATE, readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            Date beginDate = DateUtils.asDate((LocalDate)((LocalDate)((PairWidget)node).getFirstValue()));
            Date secondDate = DateUtils.asDate((LocalDate)((LocalDate)((PairWidget)node).getSecondValue()));
            Date endDate = secondDate != null ? new Date(secondDate.getTime() + 86400000L - 1L) : null;
            return new DateInterval(beginDate, endDate);
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            LocalDate beginDate = value != null ? DateUtils.asLocalDate((Date)((DateInterval)value).getBeginDate()) : null;
            LocalDate endDate = value != null ? DateUtils.asLocalDate((Date)((DateInterval)value).getEndDate()) : null;
            ((PairWidget)node).setFirstValue((Object)beginDate);
            ((PairWidget)node).setSecondValue((Object)endDate);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            String conditionAndValue = RulesHelper.buildDatesInfo((RuleCondition)ruleRestriction.getCondition(), (Object)ruleRestriction.getValue());
            out.accept(ruleRestriction.getProperty().getDisplayName() + ": " + conditionAndValue);
        }
    }
    ,
    TIME_INTERVAL{

        public Node createNode(boolean readonly) {
            return new PairWidget(PairWidgetHandler.TIME, readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            Date beginDate = DateUtils.asDate((LocalTime)((LocalTime)((PairWidget)node).getFirstValue()));
            Date endDate = DateUtils.asDate((LocalTime)((LocalTime)((PairWidget)node).getSecondValue()));
            return new DateInterval(beginDate, endDate);
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            LocalTime beginTime = value != null ? DateUtils.asLocalTime((Date)((DateInterval)value).getBeginDate()) : null;
            LocalTime endTime = value != null ? DateUtils.asLocalTime((Date)((DateInterval)value).getEndDate()) : null;
            ((PairWidget)node).setFirstValue((Object)beginTime);
            ((PairWidget)node).setSecondValue((Object)endTime);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            String conditionAndValue = RulesHelper.buildTimesInfo((RuleCondition)ruleRestriction.getCondition(), (Object)ruleRestriction.getValue());
            out.accept(ruleRestriction.getProperty().getDisplayName() + ": " + conditionAndValue);
        }
    }
    ,
    WEEK_DAY{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(WeekDay.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    YES_NO{

        public Node createNode(boolean readonly) {
            return new BooleanValueWidget(true, readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((BooleanValueWidget)node).valueProperty().getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((BooleanValueWidget)node).valueProperty().setValue((Object)((Boolean)value));
        }

        @Override
        public RuleCondition getFixedCondition() {
            return Conditions.EQUALS;
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null;
        }
    }
    ,
    YES_NO_TRANSATLANTIC{

        public Node createNode(boolean readonly) {
            return new BooleanValueWidget(true, readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((BooleanValueWidget)node).valueProperty().getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((BooleanValueWidget)node).valueProperty().setValue((Object)((Boolean)value));
        }

        @Override
        public RuleCondition getFixedCondition() {
            return null;
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null;
        }
    }
    ,
    NUMBER{

        public Node createNode(boolean readonly) {
            return new DoubleValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DoubleValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((DoubleValueWidget)node).setValue(value == null ? null : Double.valueOf(((Number)value).doubleValue()));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    INTEGER{

        public Node createNode(boolean readonly) {
            return new IntValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((IntValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((IntValueWidget)node).setValue(value == null ? null : Integer.valueOf(((Number)value).intValue()));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PRICE{

        public Node createNode(boolean readonly) {
            return new PriceValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((PriceValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PriceValueWidget)node).setValue((Number)((BigDecimal)value));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    MONEY{

        @Override
        public boolean isValueEmpty(Node node) {
            return false;
        }

        public Node createNode(boolean readonly) {
            return new MoneyValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((MoneyValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            Money money = (Money)value;
            ((MoneyValueWidget)node).setValue(money);
        }
    }
    ,
    TARIFF_TYPE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public void writeData(RuleRestriction model, Node node) {
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return true;
        }
    }
    ,
    PRODUCT_CATEGORY{

        public Node createNode(boolean readonly) {
            ComboBoxWidget node = new ComboBoxWidget(readonly);
            node.setItemsSupplier(() -> Arrays.asList(ProductCategory.values()));
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)((ProductCategory)value));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PRODUCT_STATUS{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(ProductStatus.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    MCO_CATEGORY{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(MCOCategory.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PASSENGER_TYPE{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(PassengerType.class, readonly);
            widget.setFieldName("Passenger type");
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List listDicRef;
            if (node != null && value != null && !(listDicRef = (List)value).isEmpty()) {
                VMHelper.transfer(listDicRef, ((MultiDictWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }
    }
    ,
    PASSENGER_TYPE_CATEGORY{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(PassengerTypeCategory.class, readonly);
            widget.setFieldName("Passenger type category");
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List listDicRef;
            if (node != null && value != null && !(listDicRef = (List)value).isEmpty()) {
                VMHelper.transfer(listDicRef, ((MultiDictWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }
    }
    ,
    USER_PERSON_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(PersonType.AGENT, PersonType.WEB_AGENT, PersonType.MANAGER, PersonType.PASSENGER));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    CREDIT_CARD_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(CardVendor.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    CREDIT_CARD_WITH_CODE_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setConverter((StringConverter)new StringConverter<CardVendor>(){

                public String toString(CardVendor object) {
                    if (object == null) {
                        return null;
                    }
                    return object + " (" + DictHelper.getSabreCardCode((CardVendor)object) + ")";
                }

                public CardVendor fromString(String string) {
                    return null;
                }
            });
            widget.setItemsSupplier(() -> Arrays.asList(CardVendor.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    CLASS_OF_SERVICE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(ClassOfService.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PAYMENT_TYPE_SABRE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
            widget.setConverter((StringConverter)new StringConverter<PaymentType>(){

                public String toString(PaymentType object) {
                    if (object == PaymentType.INVOICE && "en".equals(LocaleManager.get().getCurrentLocale().getLanguage())) {
                        return "Check";
                    }
                    return object.toString();
                }

                public PaymentType fromString(String string) {
                    return null;
                }
            });
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PAYMENT_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PAYMENT_TYPES_LIST{

        public Node createNode(boolean readonly) {
            return PAYMENT_TYPE.createNode(readonly);
        }

        public Object getValue(Node node) {
            return PAYMENT_TYPE.getValue(node);
        }

        public void setValue(Node node, Object value) {
            PAYMENT_TYPE.setValue(node, value);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return PAYMENT_TYPE.isValueEmpty(node);
        }
    }
    ,
    GDS_NAME{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> this.getSortedEnums((Enum[])GdsName.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    RESERVATION_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            List<ReservationType> deprecatedTypes = Arrays.asList(ReservationType.CALL_CENTER, ReservationType.INTERNET);
            widget.setItemsSupplier(() -> Arrays.stream(ReservationType.values()).filter(Predicates.not(deprecatedTypes::contains)).collect(Collectors.toList()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PASSENGER_STATUS{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(PassengerStatus.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    BLANK_OWNERS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.BlankOwners);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            MultiEntityWidget widget = (MultiEntityWidget)node;
            List values = (List)(value != null ? value : Collections.EMPTY_LIST);
            ArrayList<EntityReference> refs = new ArrayList<EntityReference>();
            for (Object item : values) {
                if (!(item instanceof EntityReference)) continue;
                refs.add((EntityReference)item);
            }
            widget.getValues().clear();
            widget.getValues().setAll(refs);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            List values = (List)ruleRestriction.getValue();
            String result = L10nResourcesManager.getStr((String)Messages.RuleProperty_BLANK_OWNERS_info, (Object[])new Object[]{ruleRestriction.getCondition().getDisplayName(), values.stream().filter(item -> item instanceof EntityReference).map(item -> ((EntityReference)item).getCaption()).reduce((a, b) -> a + ", " + b).orElse("")});
            out.accept(result);
        }
    }
    ,
    BLANK_TYPES{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(BlankType.class, readonly);
            widget.setFieldName(L10n.get((String)Messages.RuleProperty_BLANK_TYPES));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List listDicRef;
            if (node != null && value != null && !(listDicRef = (List)value).isEmpty()) {
                VMHelper.transfer(listDicRef, ((MultiDictWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }
    }
    ,
    BRANCHES{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Branch.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Subunit);
            widget.setListParametersSupplier(() -> EntityIndexHandler.forIndexClass(BranchIndex.class).createListParameters());
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return ((MultiEntityWidget)node).getValues().stream().filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toCollection(ArrayList::new));
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            MultiEntityWidget widget = (MultiEntityWidget)node;
            List uids = (List)value;
            if (uids == null || uids.isEmpty()) {
                widget.getValues().clear();
                return;
            }
            widget.setDisable(true);
            Notifications.get().submitTask(() -> {
                List refs = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).getReferences(ServiceInvocationContext.get(), Branch.class, uids.toArray(new String[0]));
                FxUtil.submitToFxThread(() -> {
                    widget.getValues().setAll((Collection)refs);
                    widget.setDisable(false);
                });
            }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Loading_data);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            String result = String.format(L10n.get((String)Messages.RuleProperty_Branches_info), ruleRestriction.getCondition().getDisplayName(), ((List)ruleRestriction.getValue()).size() + com.gridnine.xtrip.client.fx.standard.l10n.Messages.Pieces);
            out.accept(result);
        }
    }
    ,
    SALES_POINTS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(SalesPoint.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.point_of_sale);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getSalesPoints);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return ((MultiEntityWidget)node).getValues().stream().filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toCollection(ArrayList::new));
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            MultiEntityWidget widget = (MultiEntityWidget)node;
            List uids = (List)value;
            if (uids == null || uids.isEmpty()) {
                widget.getValues().clear();
                return;
            }
            widget.setDisable(true);
            Notifications.get().submitTask(() -> {
                List refs = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).getReferences(ServiceInvocationContext.get(), SalesPoint.class, uids.toArray(new String[0]));
                FxUtil.submitToFxThread(() -> {
                    widget.getValues().setAll((Collection)refs);
                    widget.setDisable(false);
                });
            }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Loading_data);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            String result = String.format(L10n.get((String)Messages.RuleProperty_SalesPoint_info), ruleRestriction.getCondition().getDisplayName(), ((List)ruleRestriction.getValue()).size() + com.gridnine.xtrip.client.fx.standard.l10n.Messages.Pieces);
            out.accept(result);
        }
    }
    ,
    COMMISSION_PROPERTIES{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(BaseCommissionProperties.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Commission_settings);
            widget.setListParametersSupplier(FilterHelper.getCommissionPropertiesMultiSupplier());
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            EntityReference ref = (EntityReference)value;
            ((EntityBoxWidget)node).setValue(ref);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    COMMISSION_PROPERTIES_LIST{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(CommissionProperties.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Commission_settings);
            widget.setListParametersSupplier(FilterHelper.getCommissionPropertiesMultiSupplier());
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            ArrayList listRef;
            if (node != null && value != null && !(listRef = (ArrayList)value).isEmpty()) {
                VMHelper.transfer(listRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }
    }
    ,
    AEROEXPRESS_CLASS_OF_SERVICE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(AeroexpressClassOfService.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    DELIVERY_REGION{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(DeliveryRegion.class, readonly);
            widget.setFieldName("Delivery region");
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DictBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((DictBoxWidget)node).setValue((DictionaryReference)value);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PROFILE_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(ProfileType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    HOTEL_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(HotelType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    HOTEL_PROVIDER{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(HotelProvider.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    HOTEL_SUBPROVIDER{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(HotelSubProvider.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.SubProvider);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            DictionaryReference ref = ((DictBoxWidget)node).getValue();
            return ref != null ? ref : new DictionaryReference<HotelSubProvider>(){
                private static final long serialVersionUID = 75837977764193919L;

                public Class<HotelSubProvider> getType() {
                    return HotelSubProvider.class;
                }
            };
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                DictionaryReference ref = (DictionaryReference)value;
                ((DictBoxWidget)node).setValue(ref);
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    HOTEL_SUBPROVIDER_LIST{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(HotelSubProvider.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.SubProvider);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                List refs = (List)value;
                ((MultiDictWidget)node).getValues().setAll((Collection)refs);
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }
    }
    ,
    BOOKING_CONTENT{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(ProductType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    ADDITIONAL_SERVICE_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(AdditionalServiceType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    AIR_PRODUCT_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget node = new ComboBoxWidget(readonly);
            node.setItemsSupplier(() -> Arrays.asList(ProductType.values()));
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)((ProductType)value));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    TICKET_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(TicketType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((ValuesWidget)node).getValues().isEmpty();
        }
    }
    ,
    CURRENCY{

        public Node createNode(boolean readonly) {
            return new CurrencyValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((CurrencyValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((CurrencyValueWidget)node).setValue((String)value);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    LOCALE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget node = new ComboBoxWidget(readonly);
            node.setItemsSupplier(Suppliers.ALL_LOCALES);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)((Locale)value));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PERSONS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Person.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Agent2);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getActiveAgents);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return ((MultiEntityWidget)node).getValues().stream().filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toCollection(ArrayList::new));
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            MultiEntityWidget widget = (MultiEntityWidget)node;
            List uids = (List)value;
            if (uids == null || uids.isEmpty()) {
                widget.getValues().clear();
                return;
            }
            widget.setDisable(true);
            Notifications.get().submitTask(() -> {
                List refs = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).getReferences(ServiceInvocationContext.get(), Person.class, uids.toArray(new String[0]));
                FxUtil.submitToFxThread(() -> {
                    widget.getValues().setAll((Collection)refs);
                    widget.setDisable(false);
                });
            }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Loading_data);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }
    }
    ,
    TRAVEL_SUBJECTS_LIST{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> this.getSortedEnums((Enum[])TravelSubject.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    COUNTRY{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(Country.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Country);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            DictionaryReference ref = ((DictBoxWidget)node).getValue();
            return ref != null ? ref : new DictionaryReference<Country>(){
                private static final long serialVersionUID = -1293343564851925562L;

                public Class<Country> getType() {
                    return Country.class;
                }
            };
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                DictionaryReference ref = (DictionaryReference)value;
                ((DictBoxWidget)node).setValue(ref);
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    CITY{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(GeoLocation.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Country);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            DictionaryReference ref = ((DictBoxWidget)node).getValue();
            return ref != null ? ref : new DictionaryReference<GeoLocation>(){
                private static final long serialVersionUID = 3651419969618588021L;

                public Class<GeoLocation> getType() {
                    return GeoLocation.class;
                }
            };
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                DictionaryReference ref = (DictionaryReference)value;
                ((DictBoxWidget)node).setValue(ref);
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    CITIES{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(GeoLocation.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.City);
            widget.setListParametersSupplier(() -> {
                DictHandler handler = DictHandler.forDictClass(GeoLocation.class);
                DictListParameters std = handler.getStandardListParameters();
                DictListParameters result = new DictListParameters();
                result.getSearchCriterions().addAll(std.getSearchCriterions());
                result.getColumns().addAll(std.getColumns());
                result.getFilters().addAll(std.getFilters());
                result.getSortings().putAll(std.getSortings());
                result.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.type.name(), new Object[]{LocationType.CITY}));
                return result;
            });
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                List refs = (List)value;
                ((MultiDictWidget)node).getValues().setAll((Collection)refs);
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }
    }
    ,
    GEO_REGION{

        public Node createNode(boolean readonly) {
            DictBoxWidget widget = new DictBoxWidget(GeoRegion.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Country);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            DictionaryReference ref = ((DictBoxWidget)node).getValue();
            return ref != null ? ref : new DictionaryReference<GeoRegion>(){
                private static final long serialVersionUID = -7830769283139225478L;

                public Class<GeoRegion> getType() {
                    return GeoRegion.class;
                }
            };
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                DictionaryReference ref = (DictionaryReference)value;
                ((DictBoxWidget)node).setValue(ref);
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((DictBoxWidget)node).getValue() == null;
        }
    }
    ,
    PAYERS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Payer);
            widget.setListParametersSupplier(this::getOrganization);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            ArrayList listRef;
            if (node != null && value != null && !(listRef = (ArrayList)value).isEmpty()) {
                VMHelper.transfer(listRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }

        private IndexListParameters<Organization, ?> getOrganization() {
            return EntityIndexHandler.forIndexClass(OrganizationIndex.class).createListParameters();
        }
    }
    ,
    SPECIAL_TARIFF{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(SpecialTariff.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PERSONS_REFERENCES{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Person.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Traveler);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getPersonsSortByCode);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            ArrayList listRef;
            if (node != null && value != null && !(listRef = (ArrayList)value).isEmpty()) {
                VMHelper.transfer(listRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }
    }
    ,
    ORGANIZATIONS_REFERENCES{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Organization);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getOrganizations);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            ArrayList listRef;
            if (node != null && value != null && !(listRef = (ArrayList)value).isEmpty()) {
                VMHelper.transfer(listRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }
    }
    ,
    COUNTRIES{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(Country.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Country);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new HashSet();
            }
            return new HashSet(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            Set setDicRef;
            if (node != null && value != null && !(setDicRef = (Set)value).isEmpty()) {
                VMHelper.transfer(setDicRef, ((MultiDictWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            out.accept(String.format("%s %s %s", L10n.get((String)Messages.RuleProperty_Countries), ruleRestriction.getCondition().getDisplayName(), ((HashSet)ruleRestriction.getValue()).size() + com.gridnine.xtrip.client.fx.standard.l10n.Messages.Pieces));
        }
    }
    ,
    ADDITIONAL_SERVICE_CATEGORY{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(AdditionalServiceCategory.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    VISA_TYPES{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(VisaType.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Visa);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new HashSet();
            }
            return new HashSet(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            Set setDicRef;
            if (node != null && value != null && !(setDicRef = (Set)value).isEmpty()) {
                VMHelper.transfer(setDicRef, ((MultiDictWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            out.accept(String.format("%s %s %s", L10n.get((String)Messages.RuleProperty_VisaType), ruleRestriction.getCondition().getDisplayName(), ((HashSet)ruleRestriction.getValue()).stream().filter(Objects::nonNull).map(DictionaryReference::toString).collect(Collectors.joining(", "))));
        }
    }
    ,
    VISA_ENTRY_TYPES{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(VisaEntryType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            out.accept(String.format("%s %s %s", L10n.get((String)Messages.RuleProperty_VisaEntryType), ruleRestriction.getCondition().getDisplayName(), ((ArrayList)ruleRestriction.getValue()).size() + com.gridnine.xtrip.client.fx.standard.l10n.Messages.Pieces));
        }
    }
    ,
    PRODUCT_BLANK_OWNERS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Form_owner);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getOrganizations);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List setDicRef;
            if (node != null && value != null && !(setDicRef = (List)value).isEmpty()) {
                VMHelper.transfer(setDicRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            out.accept(String.format("%s %s %s", L10n.get((String)Messages.RuleProperty_BLANK_OWNERS), ruleRestriction.getCondition().getDisplayName(), ((List)ruleRestriction.getValue()).size() + com.gridnine.xtrip.client.fx.standard.l10n.Messages.Pieces));
        }
    }
    ,
    SUPPLIERS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Supplier);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getSuppliers);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List setDicRef;
            if (node != null && value != null && !(setDicRef = (List)value).isEmpty()) {
                VMHelper.transfer(setDicRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            List values = (List)ruleRestriction.getValue();
            String result = L10nResourcesManager.getStr((String)Messages.RuleProperty_Supplier_info, (Object[])new Object[]{ruleRestriction.getCondition().getDisplayName(), values.stream().filter(item -> item instanceof EntityReference).map(item -> ((EntityReference)item).getCaption()).reduce((a, b) -> a + ", " + b).orElse("")});
            out.accept(result);
        }
    }
    ,
    CAR_RENTAL_CLASS{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(CarClass.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Class);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List setDicRef;
            if (node != null && value != null && !(setDicRef = (List)value).isEmpty()) {
                VMHelper.transfer(setDicRef, ((MultiDictWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            out.accept(String.format("%s %s %s", L10n.get((String)Messages.RuleProperty_CarRentalClass), ruleRestriction.getCondition().getDisplayName(), ((List)ruleRestriction.getValue()).size() + com.gridnine.xtrip.client.fx.standard.l10n.Messages.Pieces));
        }
    }
    ,
    AGENT_TOUCH_TYPES{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(AgentTouchType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            RuleProperty property = ruleRestriction.getProperty();
            StringBuilder builder = new StringBuilder();
            property.buildInfo(builder, ruleRestriction.getCondition(), ruleRestriction.getValue());
            out.accept(builder.toString());
        }
    }
    ,
    CLIENTS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Client);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            ArrayList listRef;
            if (node != null && value != null && !(listRef = (ArrayList)value).isEmpty()) {
                VMHelper.transfer(listRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    AGENCIES_AND_CLIENTS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Agency_and_client);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getClientsAndAgencies);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            ArrayList listRef;
            if (node != null && value != null && !(listRef = (ArrayList)value).isEmpty()) {
                VMHelper.transfer(listRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    FLIGHT_DISTANCE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(FlightDistance.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    EXTENDED_PRODUCT_TYPE{

        private String productTypeToString(ExtendedProductType value) {
            if (value == null) {
                return null;
            }
            if (value.getProductDescription() != null) {
                return com.gridnine.xtrip.client.fx.standard.l10n.Messages.Own_product + value.getProductDescription().getCaption();
            }
            return value.getProductType() == null ? null : value.getProductType().toString();
        }

        public Node createNode(boolean readonly) {
            MultiComboBoxWidget widget = new MultiComboBoxWidget(readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Product_Type);
            StringConverter<ExtendedProductType> converter = new StringConverter<ExtendedProductType>(){

                public String toString(ExtendedProductType object) {
                    return this.productTypeToString(object);
                }

                public ExtendedProductType fromString(String string) {
                    return null;
                }
            };
            widget.setConverter((StringConverter)converter);
            Supplier<List> itemsSupplier = () -> {
                ArrayList<ExtendedProductType> result = new ArrayList<ExtendedProductType>();
                for (ProductType productType : ProductType.values()) {
                    if (productType == ProductType.MISC_PRODUCT) {
                        for (UniversalProductDescriptionData descr : Prefetched.getData().getUniversalProductDescriptionData()) {
                            ExtendedProductType item = new ExtendedProductType();
                            item.setProductType(productType);
                            item.setProductDescription(descr.getReference());
                            result.add(item);
                        }
                        continue;
                    }
                    ExtendedProductType item = new ExtendedProductType();
                    item.setProductType(productType);
                    result.add(item);
                }
                return result;
            };
            widget.setItemsSupplier(itemsSupplier, false);
            widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler((StringConverter)converter, itemsSupplier, true));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiComboBoxWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node != null && value != null) {
                List list = (List)value;
                VMHelper.transfer(list, ((MultiComboBoxWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            Object value = this.getValue(node);
            return value == null || ((List)value).isEmpty();
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            out.accept(String.format("%s %s %s", com.gridnine.xtrip.client.fx.standard.l10n.Messages.Product_Type, ruleRestriction.getCondition().getDisplayName(), ((List)ruleRestriction.getValue()).stream().map(this::productTypeToString).collect(Collectors.joining(", "))));
        }
    }
    ,
    BILLING_ITEM_SERVICE_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(ServiceType.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ValuesWidget)node).getValues().setAll((Collection)(value != null ? (List)value : Collections.emptyList()));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return ((List)this.getValue(node)).size() == 0;
        }
    }
    ,
    SHIPMENT_CATEGORY{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(ShipmentCategory.class, readonly);
            widget.setFieldName("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((MultiDictWidget)node).getValues().setAll((Collection)(value != null ? (List)value : Collections.emptyList()));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return ((List)this.getValue(node)).size() == 0;
        }
    }
    ,
    NOMENCLATURE{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(Nomenclature.class, readonly);
            widget.setFieldName("\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0430");
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((MultiDictWidget)node).getValues().setAll((Collection)(value != null ? (List)value : Collections.emptyList()));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return ((List)this.getValue(node)).size() == 0;
        }
    }
    ,
    FISCAL_RECEIPT_ITEM_POSITION_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(ReceiptDataType.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ValuesWidget)node).getValues().setAll((Collection)(value != null ? (List)value : Collections.emptyList()));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return ((List)this.getValue(node)).size() == 0;
        }
    }
    ,
    AGENCY_MEMO_PRODUCT_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(AgencyMemoProductType.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return ((List)this.getValue(node)).isEmpty();
        }
    }
    ,
    CAR_CLASS{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(CarClass.class, readonly);
            widget.setFieldName("\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f");
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List listDicRef;
            if (node != null && value != null && !(listDicRef = (List)value).isEmpty()) {
                VMHelper.transfer(listDicRef, ((MultiDictWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }
    }
    ,
    AGENCIES{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.SubAgency);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((MultiEntityWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            ArrayList listRef;
            if (node != null && value != null && !(listRef = (ArrayList)value).isEmpty()) {
                VMHelper.transfer(listRef, ((MultiEntityWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    AGENCY{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(Organization.class, readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.SubAgency);
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            EntityReference ref = (EntityReference)value;
            ((EntityBoxWidget)node).setValue(ref);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    MULTILINGUAL_STRING{

        @Override
        public boolean isValueEmpty(Node node) {
            return false;
        }

        public Node createNode(boolean readonly) {
            MultiLingualWidget widget = new MultiLingualWidget(readonly);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.BrandName);
            return widget;
        }

        public Object getValue(Node node) {
            MultiLingualWidget widget = (MultiLingualWidget)node;
            return widget.getValue();
        }

        public void setValue(Node node, Object value) {
            MultiLingualWidget widget = (MultiLingualWidget)node;
            widget.setValue((L10nString)value);
        }
    }
    ,
    AIRCRAFT{

        public Node createNode(boolean readonly) {
            MultiDictWidget widget = new MultiDictWidget(Aircraft.class, readonly);
            widget.setFieldName("Aircraft type");
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return new ArrayList();
            }
            return new ArrayList(((MultiDictWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List listDicRef;
            if (node != null && value != null && !(listDicRef = (List)value).isEmpty()) {
                VMHelper.transfer(listDicRef, ((MultiDictWidget)node).getValues());
            }
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiDictWidget)node).getValues().isEmpty();
        }
    }
    ,
    FINANCE_DOCUMENT_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget financeDocumentTypeNode = new ComboBoxWidget(readonly);
            financeDocumentTypeNode.setItemsSupplier(() -> FinanceDocumentsHelper.types);
            financeDocumentTypeNode.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(financeDocumentTypeNode.getConverter(), () -> (List)financeDocumentTypeNode.getItemsSupplier().get(), financeDocumentTypeNode.isSortItems()));
            GridCell financeDocumentTypeCell = new GridCell(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Finance_document_type, (Node)financeDocumentTypeNode);
            BooleanValueWidget includeVatNode = new BooleanValueWidget(true, false);
            GridCell includeVatCell = new GridCell(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Contains_Fop_Components_With_Vat, (Node)includeVatNode);
            includeVatCell.setHelp(() -> new QuickHelp(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Contains_Fop_Components_With_Vat_Help));
            GridContainer container = new GridContainer(2);
            container.getCells().add((Object)financeDocumentTypeCell);
            container.getCells().add((Object)includeVatCell);
            PopupWidget popup = new PopupWidget();
            popup.setInfoText(UiUtil.NULL_TEXT);
            popup.setView((Node)container);
            ChangeListener listener = (observable, oldValue, newValue) -> popup.setInfoText(financeDocumentTypeNode.getValue() != null ? financeDocumentTypeNode.getValue() + (includeVatNode.getValue() ? " (" + com.gridnine.xtrip.client.fx.standard.l10n.Messages.Contains_Fop_Components_With_Vat + ")" : "") : UiUtil.NULL_TEXT);
            financeDocumentTypeNode.valueProperty().addListener(listener);
            includeVatNode.valueProperty().addListener(listener);
            return popup;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            FinanceDocumentTypeData data = new FinanceDocumentTypeData();
            data.setFinanceDocumentType((FinanceDocumentType)((ComboBoxWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(0)).getPayload()).getValue());
            data.setIncludeVat(((BooleanValueWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(1)).getPayload()).getValue());
            return data;
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            FinanceDocumentTypeData data = (FinanceDocumentTypeData)value;
            ((ComboBoxWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(0)).getPayload()).setValue((Object)data.getFinanceDocumentType());
            ((BooleanValueWidget)((GridCell)((GridContainer)((PopupWidget)node).getView()).getCells().get(1)).getPayload()).setValue(data.isIncludeVat());
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    SALES_ORIGIN_PROVIDER{

        public Node createNode(boolean readonly) {
            ComboBoxWidget widget = new ComboBoxWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(SalesOriginProvider.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)((SalesOriginProvider)value));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return ((List)this.getValue(node)).size() == 0;
        }
    }
    ,
    SALES_ORIGIN_CONTENT{

        public Node createNode(boolean readonly) {
            ComboBoxWidget widget = new ComboBoxWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(SalesOriginContent.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)((SalesOriginContent)value));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return ((List)this.getValue(node)).size() == 0;
        }
    }
    ,
    TIME_LIMIT_TYPE{

        public Node createNode(boolean readonly) {
            PopupWidget widget = new PopupWidget();
            GridContainer container = new GridContainer();
            container.setColumnsCount(1);
            container.setAdaptive(true);
            ComboBoxWidget timeLimitTypeWidget = new ComboBoxWidget(readonly);
            timeLimitTypeWidget.setItemsSupplier(Suppliers.createEnumSupplier(TimeLimitType.class));
            IntValueWidget intValueWidget = new IntValueWidget(readonly);
            GridCell timeLimitTypeCell = new GridCell((Node)timeLimitTypeWidget);
            timeLimitTypeCell.setCaption(L10n.get((String)Messages.render_timeLimitType));
            GridCell intValueCell = new GridCell((Node)intValueWidget);
            intValueCell.setCaption(L10n.get((String)Messages.render_timeLimitTime));
            intValueCell.setHelp(() -> new QuickHelp(L10n.get((String)Messages.render_timeLimit_help)));
            container.getCells().add(0, (Object)timeLimitTypeCell);
            container.getCells().add(1, (Object)intValueCell);
            widget.setFieldName(L10n.get((String)Messages.ruleAction_setTimeLimit_fieldName));
            widget.setView((Node)container);
            widget.setActionText(L10n.get((String)Messages.ruleAction_setTimeLimit_actionText));
            return widget;
        }

        public Object getValue(Node node) {
            Integer time;
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell timeLimitTypeCell = (GridCell)listCells.get(0);
            GridCell intValueCell = (GridCell)listCells.get(1);
            ComboBoxWidget timeLimitTypeWidget = (ComboBoxWidget)timeLimitTypeCell.getPayload();
            IntValueWidget intValueWidget = (IntValueWidget)intValueCell.getPayload();
            TimeLimitType type = (TimeLimitType)timeLimitTypeWidget.getValue();
            Optional<Message> messageOpt = this.createErrorMessage(type, time = (Integer)intValueWidget.getValue());
            if (messageOpt.isPresent()) {
                Notifications.get().showMessages(new Message[]{messageOpt.get()});
                return null;
            }
            return this.createTimeLimitValue((TimeLimitType)timeLimitTypeWidget.getValue(), (Integer)intValueWidget.getValue());
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell timeLimitTypeCell = (GridCell)listCells.get(0);
            GridCell intValueCell = (GridCell)listCells.get(1);
            ComboBoxWidget timeLimitTypeWidget = (ComboBoxWidget)timeLimitTypeCell.getPayload();
            IntValueWidget intValueWidget = (IntValueWidget)intValueCell.getPayload();
            TimeLimitTypeAndTime timeLimitTypeAndTime = (TimeLimitTypeAndTime)value;
            timeLimitTypeWidget.setValue((Object)timeLimitTypeAndTime.getType());
            intValueWidget.setValue((Number)timeLimitTypeAndTime.getTime());
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }

        private TimeLimitTypeAndTime createTimeLimitValue(TimeLimitType type, Integer time) {
            TimeLimitTypeAndTime value = new TimeLimitTypeAndTime();
            value.setType(type);
            value.setTime(time.intValue());
            return value;
        }

        private Optional<Message> createErrorMessage(TimeLimitType type, Integer time) {
            if (type == null && time == null) {
                return Optional.of(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.error_notSet_typeAndTime), (Object[])new Object[0]));
            }
            if (type != null && time == null) {
                return Optional.of(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.error_notSet_time), (Object[])new Object[0]));
            }
            if (type == null && time != null) {
                return Optional.of(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.error_notSet_type), (Object[])new Object[0]));
            }
            if (type == TimeLimitType.BOOKING_TIME && time < 0) {
                return Optional.of(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.error_canNotBe_negativeTime), (Object[])new Object[]{type}));
            }
            if (type == TimeLimitType.DEPARTURE_TIME && time > 0 || type == TimeLimitType.SUPPLIER_TIME_LIMIT && time > 0) {
                return Optional.of(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.error_canNotBe_positiveTime), (Object[])new Object[]{type}));
            }
            return Optional.empty();
        }
    }
    ,
    STRING_MAP{

        public Node createNode(boolean readonly) {
            PopupWidget widget = new PopupWidget();
            GridContainer container = new GridContainer();
            container.setColumnsCount(1);
            container.setAdaptive(true);
            TableWidget tableWidget = new TableWidget(readonly);
            tableWidget.setItemsProvider(MiscUtil.Pair::new);
            TextWidgetColumn keyColumn = new TextWidgetColumn(MiscUtil.Pair::getFirst, MiscUtil.Pair::setFirst);
            TextWidgetColumn valueColumn = new TextWidgetColumn(MiscUtil.Pair::getSecond, MiscUtil.Pair::setSecond);
            tableWidget.setColumns(Arrays.asList(keyColumn, valueColumn));
            GridCell tableCell = new GridCell((Node)tableWidget);
            container.getCells().add(0, (Object)tableCell);
            widget.setFieldName(L10n.get((String)Messages.Parameters));
            widget.setView((Node)container);
            widget.setActionText(L10n.get((String)Messages.parameters));
            return widget;
        }

        private TableWidget<MiscUtil.Pair<String, String>> getTableWidget(Node node) {
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell tableCell = (GridCell)listCells.get(0);
            return (TableWidget)tableCell.getPayload();
        }

        public Object getValue(Node node) {
            TableWidget<MiscUtil.Pair<String, String>> tableWidget = this.getTableWidget(node);
            return tableWidget.getRowsData().stream().collect(Collectors.toMap(MiscUtil.Pair::getFirst, MiscUtil.Pair::getSecond));
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            TableWidget<MiscUtil.Pair<String, String>> tableWidget = this.getTableWidget(node);
            tableWidget.removeAllRows();
            Map data = (Map)value;
            data.forEach((k, v) -> tableWidget.addRow((Object)new MiscUtil.Pair(k, v)));
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    AGREEMENT_TYPES{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(AgreementType.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PASSPORT_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.stream(PassportType.values()).sorted(MiscUtil.comparator(PassportType::toString)).collect(Collectors.toList()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    SELECT_TRANSLITERATION{

        public Node createNode(boolean readonly) {
            ComboBoxWidget roundValueNode = new ComboBoxWidget(readonly);
            roundValueNode.setItemsSupplier(Suppliers.createEnumSupplier(TransliterationType.class));
            return roundValueNode;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((TransliterationType)value));
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    HOTEL_VAT_RATE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(ControllerInterceptorVatHelper.getRulesVatHotelsSupplier());
            widget.setConverter(ControllerInterceptorVatHelper.vatConverter);
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            ((ValuesWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    SERVICE_LOCATION_TYPE{

        public Node createNode(boolean readonly) {
            BooleanValueWidget widget = new BooleanValueWidget(true, readonly);
            widget.setConverter((StringConverter)new BooleanStringConverter(){

                public String toString(Boolean value) {
                    return value != false ? ServiceLocationType.DOMESTIC.toString() : ServiceLocationType.INTERNATIONAL.toString();
                }
            });
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((BooleanValueWidget)node).valueProperty().getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((BooleanValueWidget)node).valueProperty().setValue((Object)((Boolean)value));
        }

        @Override
        public RuleCondition getFixedCondition() {
            return Conditions.EQUALS;
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null;
        }
    }
    ,
    UDID_VALUE_RENDERER{

        public Node createNode(boolean readonly) {
            PopupWidget widget = new PopupWidget();
            GridContainer container = new GridContainer();
            container.setColumnsCount(1);
            container.setAdaptive(true);
            DictBoxWidget dictBoxWidget = new DictBoxWidget(CostCodeCategory.class, readonly);
            dictBoxWidget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.StandardRuleValueRenderers_UdidCategory);
            TextFieldWidget udidValueWidget = new TextFieldWidget(readonly);
            GridCell cellDict = new GridCell((Node)dictBoxWidget);
            cellDict.setCaption(com.gridnine.xtrip.client.fx.standard.l10n.Messages.StandardRuleValueRenderers_UdidCategory);
            GridCell cellText = new GridCell((Node)udidValueWidget);
            cellText.setCaption(com.gridnine.xtrip.client.fx.standard.l10n.Messages.StandardRuleValueRenderers_UdidValue);
            container.getCells().add(0, (Object)cellDict);
            container.getCells().add(1, (Object)cellText);
            widget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.StandardRuleValueRenderers_UdidParameters);
            widget.setView((Node)container);
            widget.setActionText(com.gridnine.xtrip.client.fx.standard.l10n.Messages.StandardRuleValueRenderers_UdidParameters);
            return widget;
        }

        public Object getValue(Node node) {
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell cellDict = (GridCell)listCells.get(0);
            DictBoxWidget dictBoxWidget = (DictBoxWidget)cellDict.getPayload();
            GridCell cellText = (GridCell)listCells.get(1);
            TextFieldWidget udidValueWidget = (TextFieldWidget)cellText.getPayload();
            UDIDRestriction value = new UDIDRestriction();
            value.setUdid(dictBoxWidget.getValue());
            value.setUdidValue(udidValueWidget.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            UDIDRestriction valueUdid = (UDIDRestriction)value;
            GridCell cellDict = (GridCell)listCells.get(0);
            ((DictBoxWidget)cellDict.getPayload()).setValue(valueUdid.getUdid());
            GridCell cellText = (GridCell)listCells.get(1);
            ((TextFieldWidget)cellText.getPayload()).setValue(valueUdid.getUdidValue());
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return node == null;
        }
    }
    ,
    TOUR_CODE_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(TripartiteContractCalculationIndicatorType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        @Override
        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    };


    public String getId() {
        return this.name();
    }

    @Override
    public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
        RuleProperty property = ruleRestriction.getProperty();
        StringBuilder builder = new StringBuilder();
        property.buildInfo(builder, ruleRestriction.getCondition(), ruleRestriction.getValue());
        out.accept(builder.toString());
    }

    public void setReadonly(boolean readonly, Node node) {
        ((HasViewState)node).getViewState().setReadonly(readonly);
    }

    public <T extends Enum> List<T> getSortedEnums(T[] values) {
        return Arrays.stream(values).sorted(MiscUtil.comparator(Enum::toString)).collect(Collectors.toList());
    }
}

