/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers.widget;

import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class FopCellWidget
extends GridPane
implements HasViewState,
HasValue<FopCommissionValue> {
    private static final String MONEY_WIDGET_STYLE_CLASS = "fop-value-widget";
    private final SimpleObjectProperty<FopCommissionValue> value = new SimpleObjectProperty();
    private final PriceValueWidget valueField;
    private final ComboBoxWidget<FopCurrency> currencyField;
    private boolean internalChanges = false;

    public FopCellWidget(boolean readonly) {
        this.getStyleClass().add((Object)MONEY_WIDGET_STYLE_CLASS);
        this.resizeColumns();
        RowConstraints rc = new RowConstraints();
        rc.setMinHeight(Double.NEGATIVE_INFINITY);
        rc.setMaxHeight(Double.NEGATIVE_INFINITY);
        rc.setVgrow(Priority.ALWAYS);
        rc.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)rc);
        this.valueField = new PriceValueWidget(readonly);
        this.currencyField = new ComboBoxWidget(readonly);
        this.currencyField.setConverter(StandardRenderers.GENERIC.createStatefulConverter(() -> ((ViewState)this.valueField.getViewState()).isImmutable()));
        this.currencyField.setItemsSupplier(() -> this.getCurrencyList());
        this.addRow(0, new Node[]{this.valueField, this.currencyField});
        this.currencyField.getViewState().stateProperty().bind((ObservableValue)this.valueField.getViewState().stateProperty());
        this.addListeners();
    }

    public ViewState getViewState() {
        return this.valueField.getViewState();
    }

    public ObjectProperty<FopCommissionValue> valueProperty() {
        return this.value;
    }

    public FopCommissionValue getValue() {
        return (FopCommissionValue)this.value.get();
    }

    public void setValue(FopCommissionValue val) {
        this.value.set((Object)val);
    }

    private void addListeners() {
        this.valueField.valueProperty().addListener((obs, old, val) -> {
            if (!this.internalChanges) {
                FopCommissionValue commission = new FopCommissionValue();
                commission.amount = val == null ? null : Double.valueOf(val.doubleValue());
                commission.code = this.currencyField.getValue() == null ? null : ((FopCurrency)this.currencyField.getValue()).code;
                commission.segmentFlag = this.currencyField.getValue() == null ? null : ((FopCurrency)this.currencyField.getValue()).segmentFlag;
                this.value.set((Object)commission);
            }
        });
        this.currencyField.valueProperty().addListener((obs, old, val) -> {
            if (!this.internalChanges) {
                FopCommissionValue commission = new FopCommissionValue();
                commission.amount = this.valueField.getValue() == null ? null : Double.valueOf(((BigDecimal)this.valueField.getValue()).doubleValue());
                commission.code = val == null ? null : val.code;
                commission.segmentFlag = val == null ? null : val.segmentFlag;
                this.value.set((Object)commission);
            }
        });
        this.value.addListener((obs, old, val) -> {
            this.internalChanges = true;
            BigDecimal amount = val == null || val.amount == null ? null : new BigDecimal(val.amount);
            this.valueField.setValue((Number)amount);
            FopCurrency curr = null;
            if (val != null && val.code != null) {
                curr = new FopCurrency(val.code, val.segmentFlag);
            }
            this.currencyField.setValue(curr);
            this.internalChanges = false;
        });
    }

    private void resizeColumns() {
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setMaxWidth(Double.MAX_VALUE);
        cc1.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().add((Object)cc1);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setMinWidth(Double.NEGATIVE_INFINITY);
        cc2.setMaxWidth(Double.NEGATIVE_INFINITY);
        cc2.setHgrow(Priority.NEVER);
        this.getColumnConstraints().add((Object)cc2);
    }

    private List<FopCurrency> getCurrencyList() {
        ArrayList<FopCurrency> list = new ArrayList<FopCurrency>();
        list.add(new FopCurrency("%"));
        list.add(new FopCurrency("RUB"));
        list.add(new FopCurrency("RUB", Boolean.TRUE));
        list.add(new FopCurrency("EURO"));
        list.add(new FopCurrency("EURO", Boolean.TRUE));
        list.add(new FopCurrency("USD"));
        list.add(new FopCurrency("USD", Boolean.TRUE));
        return list;
    }

    private class FopCurrency {
        String code;
        Boolean segmentFlag;

        FopCurrency(String currency, Boolean flag) {
            this.code = currency;
            this.segmentFlag = flag;
        }

        FopCurrency(String currency) {
            this.code = currency;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            result = 31 * result + (this.segmentFlag == null ? 0 : this.segmentFlag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FopCurrency other = (FopCurrency)obj;
            if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
                return false;
            }
            return !(this.segmentFlag == null ? other.segmentFlag != null : !this.segmentFlag.equals(other.segmentFlag));
        }

        public String toString() {
            String segment = this.segmentFlag != null && this.segmentFlag != false ? " (SEG)" : "";
            return this.code + segment;
        }
    }

    public static class FopCommissionValue {
        public Double amount;
        public String code;
        public Boolean segmentFlag;
    }
}

