/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.gdsnames;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.common.model.dict.GdsName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javafx.scene.Node;

public class GdsSettingsFullPane
extends GridContainer {
    private final Map<GdsName, CheckBoxWidget> widgets = new EnumMap<GdsName, CheckBoxWidget>(GdsName.class);
    private Set<GdsName> data;

    GdsSettingsFullPane() {
        super(4);
        this.setAdaptive(true);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GdsName[] arr = (GdsName[])Arrays.stream(GdsName.values()).filter(e -> e != GdsName.AVIANOVA).toArray(GdsName[]::new);
        Arrays.sort(arr, (pt1, pt2) -> pt1.toString().compareTo(pt2.toString()));
        for (GdsName gds : arr) {
            CheckBoxWidget widget = new CheckBoxWidget(false);
            widget.setText(gds.toString());
            this.widgets.put(gds, widget);
            cells.add(new GridCell((Node)widget));
        }
        this.getCells().addAll(cells);
    }

    int getTotal() {
        return this.widgets.size();
    }

    int getEnabled() {
        return (int)this.widgets.values().stream().filter(widget -> widget.isSelected()).count();
    }

    void readData(Set<GdsName> model) {
        this.data = model;
        for (Map.Entry<GdsName, CheckBoxWidget> entry : this.widgets.entrySet()) {
            entry.getValue().setSelected(model.contains(entry.getKey()));
        }
    }

    void writeData(Set<GdsName> model) {
        model.clear();
        for (Map.Entry<GdsName, CheckBoxWidget> entry : this.widgets.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            model.add(entry.getKey());
        }
        this.data = model;
    }

    boolean isDataChanged() {
        for (Map.Entry<GdsName, CheckBoxWidget> entry : this.widgets.entrySet()) {
            if (!(entry.getValue().isSelected() ? this.data == null || !this.data.contains(entry.getKey()) : this.data != null && this.data.contains(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    void setNotEditable(boolean value) {
        for (Map.Entry<GdsName, CheckBoxWidget> entry : this.widgets.entrySet()) {
            entry.getValue().getViewState().setNotEditable(value);
        }
    }
}

