/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.gdsnames;

import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.settings.SettingsHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.gdsnames.GdsSettingsFullPane;
import com.gridnine.xtrip.client.fx.standard.settings.gdsnames.GdsSettingsHelper;
import com.gridnine.xtrip.common.fx.standard.restriction.resource.StandardUiResource;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class GdsSettingsHandler
implements SettingsHandler<SimpleContainer<InfoLabelWidget>, GdsSettingsFullPane> {
    public String getId() {
        return "gds-settings";
    }

    public double getWeight() {
        return 50.0;
    }

    public Tile<SimpleContainer<InfoLabelWidget>, GdsSettingsFullPane> createTile(Consumer<List<Message>> validationMessagesConsumer) {
        InfoLabelWidget info = new InfoLabelWidget();
        info.setText(Messages.Gds_settings_not_loaded);
        Tile result = new Tile(this.getId(), Messages.Gds_settings, (Node)SimpleContainer.create((Node)info), (Node)new GdsSettingsFullPane());
        result.expandedProperty().addListener((s, o, n) -> {
            if (!n.booleanValue()) {
                this.updateInfoLabel((Tile<SimpleContainer<InfoLabelWidget>, GdsSettingsFullPane>)result);
            }
        });
        return result;
    }

    public String getAclResourceId() {
        return StandardUiResource.SETTINGS_AVAILABLE_GDS.getId();
    }

    public void loadData(Tile<SimpleContainer<InfoLabelWidget>, GdsSettingsFullPane> tile) throws Exception {
        Set<GdsName> gdsNames = GdsSettingsHelper.getGdsNames2();
        FxUtil.waitForFxThread(() -> {
            ((GdsSettingsFullPane)tile.getFullNode()).readData(gdsNames);
            this.updateInfoLabel(tile);
        });
    }

    public void saveData(Tile<SimpleContainer<InfoLabelWidget>, GdsSettingsFullPane> tile) throws Exception {
        HashSet gdsNames = new HashSet();
        FxUtil.waitForFxThread(() -> ((GdsSettingsFullPane)tile.getFullNode()).writeData(gdsNames));
        String value = gdsNames.isEmpty() ? null : gdsNames.stream().map(pt -> pt.name()).collect(Collectors.joining("|"));
        RpcDictHelper.updatePreference(PreferenceKey.GDS_CHOICE_SETTINGS, value);
        FxUtil.submitToFxThread(() -> this.updateInfoLabel(tile));
    }

    public boolean isDataChanged(Tile<SimpleContainer<InfoLabelWidget>, GdsSettingsFullPane> tile) {
        return ((GdsSettingsFullPane)tile.getFullNode()).isDataChanged();
    }

    public void setNotEditable(Tile<SimpleContainer<InfoLabelWidget>, GdsSettingsFullPane> tile, boolean notEditable) {
        ((GdsSettingsFullPane)tile.getFullNode()).setNotEditable(notEditable);
    }

    private void updateInfoLabel(Tile<SimpleContainer<InfoLabelWidget>, GdsSettingsFullPane> tile) {
        ((InfoLabelWidget)((SimpleContainer)tile.getCompactNode()).getContent()).setText(Messages.getGds_available_amount(((GdsSettingsFullPane)tile.getFullNode()).getEnabled(), ((GdsSettingsFullPane)tile.getFullNode()).getTotal()));
    }
}

