/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.general;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.general.GeneralSettingsVM;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import javafx.scene.Node;

class SettingsPane1
extends GridContainer {
    private final ComboBoxWidget<Locale> uiLocale = new ComboBoxWidget(false);
    private final ComboBoxWidget<Locale> dataLocale = new ComboBoxWidget(false);
    private final BooleanValueWidget useSortByLocale = new BooleanValueWidget(false, false);
    private GeneralSettingsVM data;

    SettingsPane1() {
        super(3);
        this.setAdaptive(true);
        this.uiLocale.setItemsSupplier(Suppliers.SUPPORTED_LOCALES);
        this.uiLocale.setConverter(StandardRenderers.LOCALE.createConverter());
        this.uiLocale.setNoNulls(true);
        this.dataLocale.setItemsSupplier(Suppliers.ALL_LOCALES);
        this.dataLocale.setConverter(StandardRenderers.LOCALE.createConverter());
        this.dataLocale.setNoNulls(true);
        this.useSortByLocale.setConverter(Converters.boolConverter((String)Messages.Sort, (String)Messages.No_sort));
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        cells.add(new GridCell(Messages.Interface_language, this.uiLocale));
        cells.add(new GridCell(Messages.Data_language, this.dataLocale));
        cells.add(new GridCell(Messages.Sorting_of_localized_fields_by_language, (Node)this.useSortByLocale));
        cells.add(GridCell.NEW_ROW_MARKER);
        this.getCells().addAll(cells);
    }

    ComboBoxWidget<Locale> getUiLocale() {
        return this.uiLocale;
    }

    void readData(GeneralSettingsVM model) {
        this.data = model;
        this.uiLocale.setValue((Object)model.uiLocale);
        this.dataLocale.setValue((Object)model.dataLocale);
        this.useSortByLocale.setValue(model.useSortByLocale);
    }

    void writeData(GeneralSettingsVM model) {
        model.uiLocale = (Locale)this.uiLocale.getValue();
        model.dataLocale = (Locale)this.dataLocale.getValue();
        model.useSortByLocale = this.useSortByLocale.getValue();
        this.data = model;
    }

    void collectChanges(Set<GeneralSettingsVM.SettingsProperty> changeSet) {
        if (!MiscUtil.equals((Object)(this.data == null ? null : this.data.uiLocale), (Object)this.uiLocale.getValue())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.clientSettings);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : this.data.dataLocale), (Object)this.dataLocale.getValue())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.clientSettings);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.useSortByLocale)), (Object)this.useSortByLocale.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.clientSettings);
        }
    }

    void setNotEditable(boolean value) {
        this.uiLocale.getViewState().setNotEditable(value);
        this.dataLocale.getViewState().setNotEditable(value);
        this.useSortByLocale.getViewState().setNotEditable(value);
    }

    void setAclNotEditable(boolean value) {
        this.uiLocale.getViewState().setAclNotEditable(value);
        this.dataLocale.getViewState().setAclNotEditable(value);
        this.useSortByLocale.getViewState().setAclNotEditable(value);
    }
}

