/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.general;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.general.GeneralSettingsVM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

class SettingsPane2
extends SimpleContainer<TableWidget<ValueHolder<String>>> {
    private final TableWidgetController<TableWidget<ValueHolder<String>>, ValueHolder<String>> preferredCurrencies = new TableWidgetController<TableWidget<ValueHolder<String>>, ValueHolder<String>>(){
        private final TableWidget<ValueHolder<String>> view = new TableWidget(false);
        {
            this.view.setPlaceholder(Messages.Preferred_currencies_are_not_set);
            this.view.setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
            this.view.getStyleClass().add((Object)"value-settings-pane");
            this.view.setItemsProvider(ValueHolder::new);
            ArrayList<ComboBoxWidgetColumn> columns = new ArrayList<ComboBoxWidgetColumn>();
            ComboBoxWidgetColumn column = new ComboBoxWidgetColumn(ValueHolder::get, ValueHolder::set);
            column.setItemsSupplier(Suppliers.ALL_CURRENCIES);
            column.setConverter(StandardRenderers.CURRENCY_NAME.createConverter());
            column.setCaption(Messages.Name);
            column.setId("currency");
            column.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(column.getConverter(), column.getItemsSupplier(), column.isSortItems()));
            columns.add(column);
            this.view.setColumns(columns);
        }

        public TableWidget<ValueHolder<String>> getView() {
            return this.view;
        }
    };

    SettingsPane2() {
        this.setContent(this.preferredCurrencies.getView());
    }

    void readData(GeneralSettingsVM model) {
        this.preferredCurrencies.readData((Collection)model.preferredCurrencies.stream().map(ValueHolder::new).collect(Collectors.toList()));
    }

    void writeData(GeneralSettingsVM model) {
        ArrayList coll = new ArrayList();
        this.preferredCurrencies.writeData(coll);
        model.preferredCurrencies.clear();
        coll.forEach(holder -> {
            if (holder.get() != null) {
                model.preferredCurrencies.add((String)holder.get());
            }
        });
    }

    void collectChanges(Set<GeneralSettingsVM.SettingsProperty> changeSet) {
        if (this.preferredCurrencies.isDataChanged()) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.preferredCurrencies);
        }
    }

    void setNotEditable(boolean value) {
        this.preferredCurrencies.setNotEditable(value);
    }

    void setAclNotEditable(boolean value) {
        this.preferredCurrencies.setAclNotEditable(value);
    }
}

