/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.keybindings;

import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.SimpleObjectWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.SimpleObjectWidgetColumn;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.KeyCombination;
import javafx.util.StringConverter;

class KeyBindingsPane
extends SimpleContainer<TableWidget<MiscUtil.Pair<KeyBindingAction, KeyCombination>>> {
    private final TableWidgetController<TableWidget<MiscUtil.Pair<KeyBindingAction, KeyCombination>>, MiscUtil.Pair<KeyBindingAction, KeyCombination>> controller;

    KeyBindingsPane() {
        final TableWidget table = new TableWidget(false);
        table.setItemsProvider(() -> new MiscUtil.Pair());
        table.setControlButtonsAvailability(bt -> false);
        ArrayList<SimpleObjectWidgetColumn> columns = new ArrayList<SimpleObjectWidgetColumn>();
        SimpleObjectWidgetColumn actionCol = new SimpleObjectWidgetColumn(MiscUtil.Pair::getFirst, MiscUtil.Pair::setFirst);
        actionCol.setId("action");
        actionCol.setCaption(Messages.Keyboard_shortcuts_actionCol);
        actionCol.setNotEditable(Boolean.TRUE);
        actionCol.setConverter((StringConverter)new StringConverter<KeyBindingAction>(){

            public String toString(KeyBindingAction object) {
                return object == null ? null : object.getName();
            }

            public KeyBindingAction fromString(String string) {
                throw new UnsupportedOperationException();
            }
        });
        columns.add(actionCol);
        SimpleObjectWidgetColumn keyCombCol = new SimpleObjectWidgetColumn(MiscUtil.Pair::getSecond, MiscUtil.Pair::setSecond);
        keyCombCol.setId("keyCombination");
        keyCombCol.setCaption(Messages.Keyboard_shortcuts_keyCombCol);
        keyCombCol.setConverter((StringConverter)new StringConverter<KeyCombination>(){

            public String toString(KeyCombination object) {
                return object == null ? null : object.getDisplayText();
            }

            public KeyCombination fromString(String string) {
                return KeyCombination.valueOf((String)string);
            }
        });
        columns.add(keyCombCol);
        table.setColumns(columns);
        table.setOnRowsAction(evt -> {
            if (evt.getEventType() == TableRowEvent.ROW_ADD) {
                ((SimpleObjectWidget)keyCombCol.getWidget(evt.getRowIndex().intValue())).setDefaultValue((Object)((KeyBindingAction)((SimpleObjectWidget)actionCol.getWidget(evt.getRowIndex().intValue())).getValue()).getDefaultKeyCombination());
            }
        });
        this.controller = new TableWidgetController<TableWidget<MiscUtil.Pair<KeyBindingAction, KeyCombination>>, MiscUtil.Pair<KeyBindingAction, KeyCombination>>(){

            public TableWidget<MiscUtil.Pair<KeyBindingAction, KeyCombination>> getView() {
                return table;
            }
        };
        this.setContent((Node)table);
    }

    void readData(List<MiscUtil.Pair<KeyBindingAction, KeyCombination>> model) {
        this.controller.readData(model);
    }

    void writeData(List<MiscUtil.Pair<KeyBindingAction, KeyCombination>> model) {
        this.controller.writeData(model);
    }

    boolean isDataChanged() {
        return this.controller.isDataChanged();
    }

    void setNotEditable(boolean notEditable) {
        this.controller.setNotEditable(notEditable);
    }
}

