/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.system;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.raw.RawEntityEditor;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.CustomProgressIndicator;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.standard.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.standard.settings.system.ProxyData;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

class ProxyPane<E extends BaseSystemSettings>
extends StackPane
implements ViewController<ProxyPane<E>, ProxyData<E>>,
DevTool {
    private final EntityType entityType;
    private CustomProgressIndicator wheel;
    private volatile ViewController<?, DataTransferPackage<E, ?>> standardController;
    private volatile ViewController<?, DataTransferPackage<E, ?>> adminController;
    private ProxyData<E> data;
    private Class<E> entityClass;
    private Class<?> supplementClass;
    private final Consumer<List<Message>> validationMessagesConsumer;
    private final Consumer<EntityModificationEvent> entityModificationEventListener;
    private Supplier<EntityContainer<?>> dataFactory;
    private Boolean readonly;
    private Boolean notEditable;
    private Boolean aclNotEditable;
    private ContentMode contentMode = ContentMode.STANDARD;

    ProxyPane(EntityType ett, Consumer<List<Message>> validation) {
        this.entityType = ett;
        this.validationMessagesConsumer = validation;
        this.wheel = new CustomProgressIndicator();
        this.getChildren().setAll((Object[])new Node[]{this.wheel});
        this.sceneProperty().addListener((obj, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (this.getViewController() != null) {
                return;
            }
            Notifications.get().submitTask(this::createView, ObservableMutex.lookup((Node)this));
        });
        this.entityModificationEventListener = evt -> {
            for (EntityModification mod : evt.getModifications()) {
                if (mod.getReference() == null || EntityModification.ModificationType.CHANGE != mod.getType()) continue;
                try {
                    if (this.getEntityClass() != mod.getReference().getType() || !MiscUtil.equals((Object)((ProxyData)this.getData()).getUid(), (Object)mod.getReference().getUid())) continue;
                    ((ProxyData)this.getData()).ctr = null;
                    this.createView();
                    return;
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }
        };
        EventBus.get().subscribe(EntityModificationEvent.TYPE, this.entityModificationEventListener);
    }

    void setDataFactory(Supplier<EntityContainer<?>> value) {
        this.dataFactory = value;
    }

    private void createView() throws Exception {
        ((ProxyData)this.getData()).load();
        if (this.standardController == null) {
            this.standardController = this.createStandardController();
        }
        if (this.adminController == null) {
            this.adminController = this.createAdminController();
        }
        if (this.readonly != null) {
            this.getViewController().setReadonly(this.readonly.booleanValue());
        }
        if (this.notEditable != null) {
            this.getViewController().setNotEditable(this.notEditable.booleanValue());
        }
        if (this.aclNotEditable != null) {
            this.getViewController().setAclNotEditable(this.aclNotEditable.booleanValue());
        }
        FxUtil.submitToFxThread(() -> {
            Object data = this.getData();
            this.getViewController().readData((Object)new DataTransferPackage(((ProxyData)data).ctr, ((ProxyData)data).supplementData));
            this.getChildren().setAll((Object[])new Node[]{this.getViewController().getView()});
        });
    }

    private ViewController<?, DataTransferPackage<E, ?>> createStandardController() throws Exception {
        RootEntityHandler handler = RootEntityHandler.forEntityClass(this.getEntityClass());
        if (handler != null) {
            return handler.createEditorController(false);
        }
        return EntityEditorHelper.createGenericController(this.getEntityClass());
    }

    EntityType getEntityType() {
        return this.entityType;
    }

    Class<E> getEntityClass() throws Exception {
        if (this.entityClass == null) {
            this.entityClass = XSHelper.getClass((String)this.entityType.getId());
        }
        return this.entityClass;
    }

    public ProxyData<E> getData() {
        if (this.data == null) {
            EntityContainer ctr;
            if (this.dataFactory != null) {
                ctr = this.dataFactory.get();
            } else {
                try {
                    ctr = new EntityContainer(this.getEntityClass());
                    ((BaseSystemSettings)ctr.getEntity()).setName(this.entityType.getDisplayName());
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)"failed creating proxy data", (Throwable)e, (Object[])new Object[0]);
                }
            }
            RootEntityHandler rootEntityHandler = RootEntityHandler.forEntityClass((Class)ctr.getEntityType());
            if (rootEntityHandler != null) {
                this.supplementClass = rootEntityHandler.getSupplementClass();
                if (Void.class.equals(this.supplementClass)) {
                    this.supplementClass = null;
                }
            }
            this.data = new ProxyData(ctr.toReference());
            this.data.ctr = ctr;
            if (this.supplementClass != null) {
                try {
                    this.data.supplementData = this.supplementClass.newInstance();
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)"failed creating supplement class data", (Throwable)e, (Object[])new Object[0]);
                }
            }
            this.data.buildTitle(((BaseSystemSettings)this.data.ctr.getEntity()).getType(), this.entityType.getDisplayName());
        }
        return this.data;
    }

    public ProxyPane<E> getView() {
        return this;
    }

    public void readData(ProxyData<E> model) {
        this.data = model;
        this.getChildren().setAll((Object[])new Node[]{this.wheel});
        if (this.getScene() != null) {
            Notifications.get().submitTask(this::createView, ObservableMutex.lookup((Node)this));
        }
    }

    public void writeData(ProxyData<E> model) {
        model.reference.setType(((ProxyData)this.getData()).reference.getType());
        model.reference.setUid(((ProxyData)this.getData()).reference.getUid());
        model.reference.setCaption(((ProxyData)this.getData()).reference.getCaption());
        Object data = this.getData();
        model.ctr = ((ProxyData)data).ctr;
        model.supplementData = ((ProxyData)data).supplementData;
        if (this.getViewController() != null && this.getViewController().isDataChanged()) {
            ArrayList<Message> messages = new ArrayList<Message>();
            this.validateData(messages);
            if (MessagesHelper.hasErrorMessage(messages)) {
                this.validationMessagesConsumer.accept(messages);
                return;
            }
            this.getViewController().writeData((Object)new DataTransferPackage(model.ctr, ((ProxyData)data).supplementData));
            model.needSaving = true;
            model.buildTitle(((BaseSystemSettings)model.ctr.getEntity()).getType(), ((BaseSystemSettings)model.ctr.getEntity()).getName());
        }
        this.data = model;
    }

    public boolean isReadonly() {
        return this.readonly == null ? false : this.readonly;
    }

    public void setReadonly(boolean value) {
        this.readonly = value;
        if (this.getViewController() != null) {
            this.getViewController().setReadonly(this.readonly.booleanValue());
        }
    }

    public void setNotEditable(boolean value) {
        this.notEditable = value;
        if (this.getViewController() != null) {
            this.getViewController().setNotEditable(this.notEditable.booleanValue());
        }
    }

    public void setAclNotEditable(boolean value) {
        this.aclNotEditable = value;
        if (this.getViewController() != null) {
            this.getViewController().setAclNotEditable(this.aclNotEditable.booleanValue());
        }
    }

    public boolean isDataChanged() {
        return this.getViewController() != null && this.getViewController().isDataChanged();
    }

    public void validateData(List<Message> messages) {
        if (this.getViewController() != null) {
            this.getViewController().validateData(messages);
        }
    }

    void showContainerDataDialog() {
        EntityContainer ctr = ((ProxyData)this.getData()).ctr;
        if (ctr == null) {
            Notifications.get().showFlashNotification("No data.", null);
            return;
        }
        RichContentWidget widget = new RichContentWidget(true);
        widget.setFileNameSupplier(() -> ctr.getUid() + ".xml");
        RichData rd = new RichData();
        rd.setContentType(ContentType.XML);
        try {
            rd.setContent(XSUtil.toByteArray(ctr));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return;
        }
        widget.setData(rd);
        widget.getViewState().setNotEditable(true);
        new Dialog().setTitle("Entity Container Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
    }

    public String toString() {
        if (this.data == null) {
            return this.entityType.getId();
        }
        return String.format("{class=%s, uid=%s, caption=%s}", this.data.reference.getType().getName(), this.data.reference.getUid(), this.data.reference.getCaption());
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(ProxyPane.this.getViewController().getView());
            }

            public String getInfo() {
                return ((Object)((Object)ProxyPane.this)).getClass().getSimpleName();
            }
        };
    }

    private ViewController<?, DataTransferPackage<E, ?>> getViewController() {
        return this.contentMode == ContentMode.XML ? this.adminController : this.standardController;
    }

    private ViewController<?, DataTransferPackage<E, ?>> createAdminController() throws Exception {
        return new ViewController<RawEntityEditor<E>, DataTransferPackage<E, Void>>(){
            private final ViewController<RawEntityEditor<E>, EntityContainer<E>> rawController;
            private DataTransferPackage<E, Void> localData;
            {
                this.rawController = RawEntityEditor.createContainerController(ProxyPane.this.getEntityClass());
            }

            public RawEntityEditor<E> getView() {
                return (RawEntityEditor)this.rawController.getView();
            }

            public DataTransferPackage<E, Void> getData() {
                return this.localData;
            }

            public void readData(DataTransferPackage<E, Void> model) {
                this.localData = model;
                this.rawController.readData((Object)model.getContainer());
            }

            public void writeData(DataTransferPackage<E, Void> model) {
                this.localData = model;
                this.rawController.writeData((Object)model.getContainer());
            }

            public boolean isReadonly() {
                return this.rawController.isReadonly();
            }

            public void setReadonly(boolean value) {
                this.rawController.setReadonly(value);
            }

            public void setNotEditable(boolean value) {
                this.rawController.setNotEditable(value);
            }

            public void setAclNotEditable(boolean value) {
                this.rawController.setAclNotEditable(value);
            }

            public boolean isDataChanged() {
                return this.rawController.isDataChanged();
            }

            public void validateData(List<Message> messages) {
                this.rawController.validateData(messages);
            }
        };
    }

    ContentMode getContentMode() {
        return this.contentMode;
    }

    void setContentMode(ContentMode value) {
        if (value == this.contentMode) {
            return;
        }
        if (!(this.notEditable != null && this.notEditable.booleanValue() || this.aclNotEditable != null && this.aclNotEditable.booleanValue() || this.readonly != null && this.readonly.booleanValue())) {
            this.writeData((ProxyData<E>)this.getData());
        }
        this.contentMode = value;
        if (this.readonly != null) {
            this.getViewController().setReadonly(this.readonly.booleanValue());
        }
        if (this.notEditable != null) {
            this.getViewController().setNotEditable(this.notEditable.booleanValue());
        }
        if (this.aclNotEditable != null) {
            this.getViewController().setAclNotEditable(this.aclNotEditable.booleanValue());
        }
        this.getChildren().setAll((Object[])new Node[]{this.getViewController().getView()});
        this.getViewController().readData((Object)new DataTransferPackage(((ProxyData)this.getData()).ctr));
    }

    static enum ContentMode {
        STANDARD,
        XML;

    }
}

