/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.system;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.BaseGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.CompactGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.GroupsWidgetController;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.system.ProxyData;
import com.gridnine.xtrip.client.fx.standard.settings.system.ProxyPane;
import com.gridnine.xtrip.client.fx.standard.settings.system.SystemSettingsFullPane;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

class SchedulerSettingsFullPane
extends StackPane
implements DevTool {
    final GroupsWidgetController<ProxyPane<ScheduledTaskSettings>, ProxyData<ScheduledTaskSettings>, ProxyPane<ScheduledTaskSettings>> controller;
    private final List<ProxyData<ScheduledTaskSettings>> deleted = new ArrayList<ProxyData<ScheduledTaskSettings>>();

    SchedulerSettingsFullPane(Consumer<List<Message>> validationMessagesConsumer) {
        final CompactGroupsWidget view = new CompactGroupsWidget(false);
        view.setViewFactory(() -> new ProxyPane(MetaRegistryHelper.getEntityType((String)ScheduledTaskSettings.class.getName()), validationMessagesConsumer));
        view.setConverter(SystemSettingsFullPane.createViewConverter());
        view.enableSuggestions(true);
        this.controller = new GroupsWidgetController<ProxyPane<ScheduledTaskSettings>, ProxyData<ScheduledTaskSettings>, ProxyPane<ScheduledTaskSettings>>(){

            public BaseGroupsWidget<ProxyPane<ScheduledTaskSettings>> getView() {
                return view;
            }

            protected ProxyData<ScheduledTaskSettings> createItem() {
                EntityContainer ctr = new EntityContainer(ScheduledTaskSettings.class);
                ProxyData<ScheduledTaskSettings> result = new ProxyData<ScheduledTaskSettings>(ctr.toReference());
                result.ctr = ctr;
                return result;
            }

            protected ProxyPane<ScheduledTaskSettings> createController(ProxyPane<ScheduledTaskSettings> pane) {
                return pane;
            }
        };
        view.setCallbackOnDelete(node -> Dialog.confirm((Node)node, (String)Messages.Delete_scheduler_task, null, (String)Messages.Delete, () -> view.getViews().remove(node), null));
        view.getViews().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (ProxyPane pane : change.getRemoved()) {
                    this.deleted.add((ProxyData<ScheduledTaskSettings>)pane.getData());
                }
            }
        });
        this.getChildren().add((Object)this.controller.getView());
    }

    void loadData() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SCHEDULED_TASK_SETTINGS));
        sq.getPreferredProperties().add(BasicSystemSettingsIndex.Property.type.name());
        sq.getPreferredProperties().add(BasicSystemSettingsIndex.Property.name.name());
        List list = entityService.search(sic, BasicSystemSettingsIndex.class, sq);
        List data = list.stream().map(idx -> {
            ProxyData info = new ProxyData(idx.getSource());
            info.buildTitle(idx.getType(), idx.getName());
            return info;
        }).sorted((lhs, rhs) -> TextUtil.compare((String)lhs.getTitle(), (String)rhs.getTitle(), (boolean)true, (boolean)false)).collect(Collectors.toList());
        FxUtil.waitForFxThread(() -> this.controller.readData((Collection)data));
        this.deleted.clear();
    }

    void saveData() throws Exception {
        ValueHolder changed = new ValueHolder();
        FxUtil.waitForFxThread(() -> changed.set((Object)this.controller.isDataChanged()));
        if (!((Boolean)changed.get()).booleanValue()) {
            this.loadData();
            return;
        }
        ArrayList newData = new ArrayList();
        FxUtil.waitForFxThread(() -> this.controller.writeData((Collection)newData));
        for (ProxyData data : newData) {
            data.save();
        }
        if (!this.deleted.isEmpty()) {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            for (ProxyData<ScheduledTaskSettings> info : this.deleted) {
                if (info.reference == null) continue;
                entityService.delete(sic, info.reference);
            }
            this.deleted.clear();
        }
        this.loadData();
    }

    boolean isDataChanged() {
        return this.controller.isDataChanged();
    }

    EntityReference<ScheduledTaskSettings> getCurrentReference() {
        ProxyPane pp = (ProxyPane)((BaseGroupsWidget)this.controller.getView()).getSelectedView();
        return pp == null ? null : ((ProxyData)pp.getData()).reference;
    }

    EntityContainer<ScheduledTaskSettings> getCurrentContainer() {
        ProxyPane pp = (ProxyPane)((BaseGroupsWidget)this.controller.getView()).getSelectedView();
        return pp == null ? null : ((ProxyData)pp.getData()).ctr;
    }

    void setNotEditable(boolean value) {
        this.controller.setNotEditable(value);
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(((BaseGroupsWidget)SchedulerSettingsFullPane.this.controller.getView()).getSelectedView());
            }

            public String getInfo() {
                return ((Object)((Object)SchedulerSettingsFullPane.this)).getClass().getSimpleName();
            }
        };
    }
}

