/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.startup;

import com.gridnine.xtrip.client.fx.core.acl.AclService;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.service.AppConfigService;
import com.gridnine.xtrip.client.fx.core.startup.AppInitHandler;
import com.gridnine.xtrip.client.fx.core.startup.BaseStartupForm;
import com.gridnine.xtrip.client.fx.core.startup.StartupPane;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.client.fx.standard.startup.ChangePasswordForm;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.fx.model.AppConfigData;
import com.gridnine.xtrip.common.fx.rpc.AclDataService;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.fx.rpc.StandardFxService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.RegistryConfigurator;
import com.gridnine.xtrip.common.model.helpers.PasswordPolicyHelper;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.system.config.RegionalVariation;
import com.gridnine.xtrip.common.model.validation.ValidationMessagesEnvironmentConfigurator;
import com.gridnine.xtrip.common.model.validation.ValidationMessagesResourcesEnvironment;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.stage.Stage;
import org.java.plugin.registry.Extension;
import org.slf4j.LoggerFactory;

public class StandardAppInitHandler
implements AppInitHandler {
    public void doInit(StartupPane pane, Runnable onProceed) throws Exception {
        ValidationMessagesResourcesEnvironment vmre = new ValidationMessagesResourcesEnvironment();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"ValidationMessagesEnvironmentConfigurator")) {
            ((ValidationMessagesEnvironmentConfigurator)JpfUtil.getClass((Extension)ext).newInstance()).configure(vmre);
        }
        Environment.publish((Object)vmre);
        HandlersRegistry registry = new HandlersRegistry();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common.model", (String)"HandlersRegistryConfigurator")) {
            ((RegistryConfigurator)JpfUtil.getClass((Extension)ext).newInstance()).configure(registry);
        }
        Environment.publish((Object)registry);
        final AppConfigData cfg = ((StandardFxService)RpcServiceManager.get().getService(StandardFxService.class)).getAppConfigData(ServiceInvocationContext.get());
        AppConfigHelper.init(cfg);
        Environment.publish(AppConfigService.class, (Object)new AppConfigService(){

            public boolean isExtensionLegal(Extension ext) {
                Extension.Parameter param = ext.getParameter("regionalVariation");
                if (param == null) {
                    return true;
                }
                String value = param.valueAsString();
                RegionalVariation variation = (RegionalVariation)CollectionUtil.findEnumConstant(RegionalVariation.class, (String)value);
                if (variation == null) {
                    return false;
                }
                return cfg.getRegionalVariation() == variation;
            }
        });
        Environment.publish(AclService.class, (Object)new AclService(){

            public Map<String, Map<String, Boolean>> applyAcl(Set<String> resources) throws Exception {
                return ((AclDataService)RpcServiceManager.get().getService(AclDataService.class)).applyAcl(ServiceInvocationContext.get(), resources);
            }

            public Set<String> applyAcl(Map<String, AclQuery> queries) throws Exception {
                return ((AclDataService)RpcServiceManager.get().getService(AclDataService.class)).applyAcl(ServiceInvocationContext.get(), queries);
            }

            public Map<String, Boolean> applyAcl(Class<? extends BaseEntity> entityClass, String entityUid, Integer versionNumber) throws Exception {
                return ((AclDataService)RpcServiceManager.get().getService(AclDataService.class)).applyAcl(ServiceInvocationContext.get(), entityClass, entityUid, versionNumber);
            }
        });
        RulesEnvironment rulesEnv = new RulesEnvironment();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"RulesEnvironmentHook")) {
            if (!AppConfigService.get().isExtensionLegal(ext)) continue;
            try {
                for (Extension.Parameter param : ext.getParameters("class")) {
                    ((RulesEnvironment.Hook)JpfUtil.getClass((Extension.Parameter)param).newInstance()).environmentInitialized(rulesEnv);
                }
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)("failed handling hook " + ext), (Throwable)e, (Object[])new Object[0]);
            }
        }
        Environment.publish((Object)rulesEnv);
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"Publisher")) {
            Class cls = JpfUtil.getClass((Extension)ext);
            ((Publisher)cls.newInstance()).publish();
        }
        this.customizeWidgets();
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        boolean expired = !AclHelper.system.getId().equals(sic.getUser()) && ((ModelService)RpcServiceManager.get().getService(ModelService.class)).isPasswordExpired(sic, sic.getUser());
        FxUtil.runInFxThread(() -> {
            if (expired) {
                StandardAppInitHandler.showChangePasswordForm(pane, onProceed);
            } else {
                onProceed.run();
            }
        });
    }

    private static void showChangePasswordForm(StartupPane pane, Runnable onProceed) {
        ((Stage)pane.getScene().getWindow()).setTitle(Messages.General_Refresh_password);
        pane.getProgressBar().setVisible(false);
        ChangePasswordForm form = new ChangePasswordForm();
        form.button.setOnAction(evt -> {
            pane.getProgressBar().setVisible(true);
            pane.getProgressBar().setProgress(-1.0);
            form.setMessage(null);
            form.busy.set(true);
            String password = form.passwordField.getValue();
            Thread thread = new Thread(() -> {
                try {
                    StandardAppInitHandler.doChangePassword(password, onProceed);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }, "update password process");
            thread.setDaemon(true);
            thread.start();
        });
        ErrorHandler.register(error -> {
            LoggerFactory.getLogger(StandardAppInitHandler.class).error("change password procedure failed", error);
            FxUtil.runInFxThread(() -> {
                form.setMessage((Node)MessagePane.error((String)ErrorHandler.getMessage((Throwable)error)).setWrapText(true));
                form.busy.set(false);
                pane.getProgressBar().setVisible(false);
            });
        });
        pane.setContent((BaseStartupForm)form);
    }

    private static void doChangePassword(String newPassword, Runnable onProceed) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        if (!PasswordPolicyHelper.checkPassword((String)newPassword) || PasswordPolicyHelper.hasInvalidCharacters((String)newPassword)) {
            throw Xeption.forEndUser((String)Messages.General_Password_according_security_warning, (Object[])new Object[0]);
        }
        if (((ModelService)RpcServiceManager.get().getService(ModelService.class)).isPasswordMatchPrevious(sic, sic.getUser(), newPassword.toCharArray())) {
            throw Xeption.forEndUser((String)Messages.General_Previously_used_password_warning, (Object[])new Object[0]);
        }
        Serializable authToken = ((ModelService)RpcServiceManager.get().getService(ModelService.class)).updatePassword(sic, sic.getUser(), newPassword.toCharArray());
        if (authToken != null) {
            ((ServiceInvocationContext)Environment.getPublished(ServiceInvocationContext.class)).setAuthToken(authToken);
        }
        FxUtil.runInFxThread(() -> onProceed.run());
    }

    private void customizeWidgets() {
        CurrencyValueWidget.setAvailableCurrenciesSupplier(() -> {
            try {
                DictQuery query = new DictQuery();
                query.setLimit(Integer.MAX_VALUE);
                query.getFields().add(BaseDictionary.Property.translations.name());
                return ((DictService)RpcServiceManager.get().getService(DictService.class)).search(ServiceInvocationContext.get(), CurrencyInfo.class, query).stream().map(dictItem -> new CurrencyValueWidget.CurrencyItem((DictItem)dictItem){
                    final /* synthetic */ DictItem val$dictItem;
                    {
                        this.val$dictItem = dictItem;
                    }

                    public String getCode() {
                        return this.val$dictItem.getReference().getCode();
                    }

                    public String getDisplayName() {
                        return (String)StandardRenderers.TRANSLATIONS.apply(this.val$dictItem.getFields().get(BaseDictionary.Property.translations.name()));
                    }
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return Collections.emptyList();
            }
        });
    }
}

