/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.service.IndexListService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.helpers.RulesMigrationExchangeDocumentHelper;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.RulesMigrationExchangeDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MigrateRulesTask
extends ClientTask {
    private final List<EntityReference<RulesMigrationSettings>> items;

    public MigrateRulesTask(List<EntityReference<RulesMigrationSettings>> references) {
        this.items = new ArrayList<EntityReference<RulesMigrationSettings>>(references);
    }

    protected String getTitle() {
        return Messages.Formulating_rule_transfer_files;
    }

    protected void execute() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RulesMigrationExchangeDocumentIndex.Property.status.name(), (Object)ProcessingStatus.UNPROCESSED));
        query.getPreferredProperties().add(RulesMigrationExchangeDocumentIndex.Property.migrationSettings.name());
        Set processing = entityService.search(sic, RulesMigrationExchangeDocumentIndex.class, query).stream().map(RulesMigrationExchangeDocumentIndex::getMigrationSettings).filter(Objects::nonNull).collect(Collectors.toSet());
        float progress = 0.0f;
        float step = 100 / this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            EntityReference<RulesMigrationSettings> ref = this.items.get(i);
            if (processing.contains(ref)) {
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Already_a_generated_job, (Object[])new Object[]{ref})});
            } else {
                EntityContainer ctr = EntityContainer.create((BaseEntity)RulesMigrationExchangeDocumentHelper.createUnprocessedExchangeDocument(ref));
                ctr.getVersionInfo().setDataSource("fx-migrate-rules-task");
                entityService.save(sic, ctr, null, true);
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Already_a_generated_job_and_queue, (Object[])new Object[]{ref})});
            }
            this.setProgress((byte)(progress += step), "");
        }
        FxUtil.submitToFxThread(() -> {
            EntityIndexHandler indexHandler = EntityIndexHandler.forIndexClass(RulesMigrationExchangeDocumentIndex.class);
            IndexListService.get().open("rules-migration-exchange-documents", Messages.Rule_Transfer_Files, indexHandler.createListParameters());
        });
    }
}

