/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.VoucherProperties;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;

public class VoucherTask
extends ClientTask {
    private final VoucherProperties properties;

    public VoucherTask(VoucherProperties properties) {
        this.properties = properties;
    }

    protected void execute() throws Exception {
        try {
            BookingFileService.VoucherRPCResult result = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).createVoucher(ServiceInvocationContext.get(), this.properties);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            result.getDocuments().forEach(doc -> {
                EntityContainer docCont = EntityContainer.create((BaseEntity)doc);
                try {
                    docCont.getVersionInfo().setDataSource("fx-voucher-task");
                    entityService.save(sic, docCont, null, true);
                }
                catch (ServiceException e) {
                    ErrorHandler.handle((Throwable)e);
                }
                RootEntityEditingService.navigateTo((EntityReference)docCont.toReference());
            });
            this.addMessages(result.getResultMessageList());
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    protected String getTitle() {
        return Messages.Create_a_voucher;
    }
}

