/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.IntValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductExchangeToVoucherTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BaseExchangeProductToVoucherDialog;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ExchangeSegmentDialogVM;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class AirProductExchangeToVoucherDialog
extends BaseExchangeProductToVoucherDialog {
    private final Product product;
    private final TableWidgetController<TableWidget<ExchangeSegmentDialogVM>, ExchangeSegmentDialogVM> segmentsController;
    private final TableWidget<ExchangeSegmentDialogVM> segmentsWidget;

    public AirProductExchangeToVoucherDialog(RootEntityPane<BookingFile, ?> rootPane, Product product, Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints) {
        super((Node)rootPane);
        this.product = product;
        this.segmentsWidget = this.createSegmentsWidget();
        this.segmentsController = new TableWidgetController<TableWidget<ExchangeSegmentDialogVM>, ExchangeSegmentDialogVM>(){

            public TableWidget<ExchangeSegmentDialogVM> getView() {
                return AirProductExchangeToVoucherDialog.this.segmentsWidget;
            }
        };
        this.segmentsController.readData((Collection)product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).map(seg -> new ExchangeSegmentDialogVM((Segment)seg, segmentsPoints)).collect(Collectors.toList()));
    }

    public void showDialog() {
        GridContainer segmentsContainer = new GridContainer();
        GridCell cell = new GridCell(this.segmentsWidget);
        segmentsContainer.getCells().add((Object)cell);
        CardsContainer cardsContainer = this.createBaseParametersCard();
        cardsContainer.getCards().add((Object)new Card("segments", UiCardsContainer.Style.STATIC, Messages.Segments, (Node)segmentsContainer));
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Air_ticket_exchange).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Exchange, () -> {
            try {
                List<String> segmentDescriptions = this.getSegmentDescriptions();
                ProductExchangeRefundProperties.ExchangeRefundEMD voucherEmd = this.getVoucherEmd();
                BigDecimal fareDifference = MiscUtil.sub((BigDecimal)voucherEmd.getEquivAmount(), (BigDecimal[])new BigDecimal[]{AirProductHelper.getEquivalentFare((Product)this.product)});
                BigDecimal usedEquivFare = MiscUtil.isNegative((BigDecimal)fareDifference) ? fareDifference.negate() : null;
                ProductExchangeRefundProperties props = new ProductExchangeRefundProperties(this.getOperationDate(), this.getAgent(), this.isForced(), null, usedEquivFare, this.getPenalty(), segmentDescriptions, this.getTaxes(), Collections.singletonList(voucherEmd));
                ProductExchangeToVoucherTask task = new ProductExchangeToVoucherTask(this.product.getUid(), props, this.getRootEntityPane());
                Notifications.get().enqueueAsyncTask((ClientTask)task);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show(this.source);
    }

    private ProductExchangeRefundProperties.ExchangeRefundEMD getVoucherEmd() {
        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)this.product);
        BigDecimal emdEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{equivalentFare, this.getAirlineBonus()});
        if (this.getWithholdingAmount() != null) {
            BigDecimal taxesAmount = this.product.getTaxes().stream().map(Tax::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal subtract = this.getWithholdingAmount().subtract(taxesAmount);
            if (!MiscUtil.isNegative((BigDecimal)subtract)) {
                emdEquivalentAmount = MiscUtil.sub((BigDecimal)emdEquivalentAmount, (BigDecimal[])new BigDecimal[]{subtract});
            }
        }
        String equivalentCurrency = Objects.requireNonNull(Prefetched.getData().getEquivalentCurrency());
        Money baseFare = Objects.requireNonNull(AirProductHelper.getBaseFare((Product)this.product));
        BigDecimal emdBaseAmount = MiscUtil.equals((Object)equivalentFare, (Object)emdEquivalentAmount) ? baseFare.getValue() : (equivalentCurrency.equals(baseFare.getCurrency()) ? emdEquivalentAmount : null);
        return new ProductExchangeRefundProperties.ExchangeRefundEMD(this.getVoucherNumber(), emdBaseAmount, baseFare.getCurrency(), emdEquivalentAmount, MCOCategory.VOUCHER, null);
    }

    private List<Tax> getTaxes() throws Exception {
        ArrayList<Tax> result = new ArrayList<Tax>(this.product.getTaxes().size());
        String equivalentCurrency = Objects.requireNonNull(Prefetched.getData().getEquivalentCurrency());
        BigDecimal withholdingAmount = this.getWithholdingAmount();
        for (Tax tax : this.product.getTaxes()) {
            Tax clone = (Tax)XCloneHelper.clone((XCloneable)tax, (boolean)true);
            result.add(clone);
            if (MiscUtil.isZero((BigDecimal)withholdingAmount, (boolean)true) || clone.getEquivalentAmount() == null) continue;
            if (MiscUtil.compare((Comparable)clone.getEquivalentAmount(), (Comparable)withholdingAmount) == 1) {
                clone.setEquivalentAmount(clone.getEquivalentAmount().subtract(withholdingAmount));
                withholdingAmount = BigDecimal.ZERO;
            } else {
                withholdingAmount = withholdingAmount.subtract(clone.getEquivalentAmount());
                clone.setEquivalentAmount(BigDecimal.ZERO);
            }
            if (clone.getAmount() == null) continue;
            if (equivalentCurrency.equals(clone.getAmount().getCurrency())) {
                clone.getAmount().setValue(clone.getEquivalentAmount());
                continue;
            }
            BigDecimal value = MiscUtil.isZero((BigDecimal)clone.getEquivalentAmount(), (boolean)true) ? BigDecimal.ZERO : null;
            clone.getAmount().setValue(value);
        }
        return result;
    }

    private List<String> getSegmentDescriptions() {
        ArrayList segments = new ArrayList();
        this.segmentsController.writeData(segments);
        return segments.stream().filter(ExchangeSegmentDialogVM::isInAction).map(ExchangeSegmentDialogVM::getDescription).collect(Collectors.toList());
    }

    private TableWidget<ExchangeSegmentDialogVM> createSegmentsWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(ExchangeSegmentDialogVM::getDescription, ExchangeSegmentDialogVM::setDescription);
        column.setId("Description");
        column.setCaption("Description");
        column.setHidden(true);
        columns.add(column);
        column = new IntValueWidgetColumn(ExchangeSegmentDialogVM::getNumber, ExchangeSegmentDialogVM::setNumber);
        column.setId("recordNumber");
        column.setCaption(Messages.Number);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new TextWidgetColumn(ExchangeSegmentDialogVM::getDeparturePoint, ExchangeSegmentDialogVM::setDeparturePoint);
        column.setPrefWidth(Double.valueOf(30.0));
        column.setId("departurePoint");
        column.setCaption(Messages.Point_of_departure);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new TextWidgetColumn(ExchangeSegmentDialogVM::getArrivalPoint, ExchangeSegmentDialogVM::setArrivalPoint);
        column.setPrefWidth(Double.valueOf(30.0));
        column.setId("arrivalPoint");
        column.setCaption(Messages.Arrival_Point);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new BooleanValueWidgetColumn(ExchangeSegmentDialogVM::isInAction, ExchangeSegmentDialogVM::setInAction);
        column.setPrefWidth(Double.valueOf(15.0));
        column.setId("inAction");
        column.setCaption(Messages.Accept_for_exchange);
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    private RootEntityPane<BookingFile, ?> getRootEntityPane() {
        return this.source instanceof RootEntityPane ? (RootEntityPane)this.source : null;
    }
}

