/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import javafx.scene.Node;

public abstract class BaseExchangeProductToVoucherDialog {
    protected final Node source;
    private final DateTimeValueWidget operationDateWidget;
    private final EntityBoxWidget<Person> agentWidget;
    private final CheckBoxWidget forcedWidget;
    private final PriceValueWidget airlineBonusWidget;
    private final PriceValueWidget penaltyWidget;
    private final PriceValueWidget withholdingWidget;
    private final TextFieldWidget voucherNumberWidget;

    public BaseExchangeProductToVoucherDialog(Node source) {
        this.source = source;
        this.operationDateWidget = new DateTimeValueWidget(false);
        this.operationDateWidget.setValue(DateUtils.asLocalDateTime((Date)new Date()));
        this.agentWidget = new EntityBoxWidget(Person.class, false);
        this.agentWidget.setListParametersSupplier(ControllerInterceptorsHelper::getEmployees);
        this.agentWidget.setValue(Prefetched.getData().getCurrentAgentData().getAgent());
        this.forcedWidget = new CheckBoxWidget(false);
        this.forcedWidget.setText(Messages.Compelled);
        this.airlineBonusWidget = new PriceValueWidget(false);
        this.penaltyWidget = new PriceValueWidget(false);
        this.withholdingWidget = new PriceValueWidget(false);
        this.voucherNumberWidget = new TextFieldWidget(false);
    }

    protected CardsContainer createBaseParametersCard() {
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.STATIC, Messages.Sharing_Options, (Node)this.createGeneralParamsContainer()));
        return cardsContainer;
    }

    protected Date getOperationDate() {
        return DateUtils.asDate((LocalDateTime)this.operationDateWidget.getValue());
    }

    protected EntityReference<Person> getAgent() {
        return this.agentWidget.getValue();
    }

    protected boolean isForced() {
        return this.forcedWidget.isSelected();
    }

    protected BigDecimal getAirlineBonus() {
        return (BigDecimal)this.airlineBonusWidget.getValue();
    }

    protected BigDecimal getWithholdingAmount() {
        return (BigDecimal)this.withholdingWidget.getValue();
    }

    protected BigDecimal getPenalty() {
        if (this.penaltyWidget.getValue() != null) {
            return MiscUtil.compare((Comparable)((Comparable)((Object)this.penaltyWidget.getValue())), (Comparable)BigDecimal.ZERO) != -1 ? ((BigDecimal)this.penaltyWidget.getValue()).negate() : (BigDecimal)this.penaltyWidget.getValue();
        }
        return null;
    }

    protected String getVoucherNumber() {
        return this.voucherNumberWidget.getValue();
    }

    private GridContainer createGeneralParamsContainer() {
        GridContainer gridContainer = new GridContainer(3);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Date_of_operation, (Node)this.operationDateWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Dimension_agent, this.agentWidget);
        cells.add(cell);
        cell = new GridCell("", (Node)this.forcedWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Airline_Bonus, (Node)this.airlineBonusWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Withholding_Amount, (Node)this.withholdingWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Fine, (Node)this.penaltyWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Voucher_Number, (Node)this.voucherNumberWidget);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }
}

