/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileJoinCardsContainer;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileJoinCardsContainerController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileJoinContainer;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileJoinTableVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.async.JoinBookingFileCreateTaskParameters;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.exceptions.BookingFileNotFoundException;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.JoinProductsPersistentParameters;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.util.StringConverter;
import org.xml.sax.InputSource;

public class BookingFileJoinDialog {
    private final Control source;
    private BookingFileJoinCardsContainerController controller;
    private ChangeListener<Boolean> listener;
    private final List<BookingFileService.JoinProductData> products = new ArrayList<BookingFileService.JoinProductData>();
    private final BookingFileJoinCardsContainer body;

    public BookingFileJoinDialog(Control source, Collection<BookingFileService.JoinProductData> products, Collection<String> uidsOfSelectedProducts, JoinProductsPersistentParameters persistentParameters) {
        this.products.addAll(products);
        this.source = source;
        this.body = this.createBodyDialog();
        this.fillingProducts(uidsOfSelectedProducts);
        this.fillClientAndPayersCells(persistentParameters, false);
        this.createAndShowDialog(this.body);
    }

    private void fillClientAndPayersCells(JoinProductsPersistentParameters persistentParameters, boolean update) {
        HashSet uidsOfSelectedProducts = new HashSet();
        ((TableWidget)this.body.getProductsCard().getContent()).getRowsData().forEach(vm -> {
            if (vm.isIsSelectedColumn()) {
                uidsOfSelectedProducts.add(vm.getProductColumn().getSecond());
            }
        });
        BookingFileJoinContainer content = (BookingFileJoinContainer)this.body.getOptionsCard().getContent();
        if (content.getIsTransferToNewBookingFileNode().getValue()) {
            List clients = this.products.stream().filter(it -> uidsOfSelectedProducts.contains(it.productUid)).map(it -> it.client).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(it -> it.getCaption())).collect(Collectors.toList());
            if (clients.size() == 1 && ((EntityBoxWidget)content.getClientCell().getPayload()).getValue() == null) {
                ((EntityBoxWidget)content.getClientCell().getPayload()).setValue((EntityReference)clients.get(0));
            } else if (clients.isEmpty()) {
                ((EntityBoxWidget)content.getClientCell().getPayload()).setValue(null);
            }
        }
        ObservableList payersValue = ((MultiEntityWidget)content.getPayersCell().getPayload()).getValues();
        payersValue.clear();
        payersValue.addAll((Collection)this.products.stream().filter(it -> uidsOfSelectedProducts.contains(it.productUid)).flatMap(it -> it.payers.stream()).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(it -> it.getCaption())).collect(Collectors.toList()));
        if (!update) {
            ((BooleanValueWidget)content.getChangeRetailPayerCell().getPayload()).setValue(true);
            if (persistentParameters != null) {
                ((BooleanValueWidget)content.getChangeRetailPayerCell().getPayload()).setValue(persistentParameters.isChangeRetailPayer());
            }
        }
    }

    private BookingFileJoinCardsContainer createBodyDialog() {
        BookingFileJoinCardsContainer cardsContainer = new BookingFileJoinCardsContainer(false);
        BookingFileJoinContainer optionsCard = (BookingFileJoinContainer)cardsContainer.getOptionsCard().getContent();
        optionsCard.getDeleteEmptyBookingFilesNode().setSelected(true);
        ((TableWidget)cardsContainer.getProductsCard().getContent()).getColumn("bookingFileColumn").setNotEditable(Boolean.valueOf(true));
        ((TableWidget)cardsContainer.getProductsCard().getContent()).getColumn("productColumn").setNotEditable(Boolean.valueOf(true));
        ((ComboBoxWidgetColumn)((TableWidget)cardsContainer.getProductsCard().getContent()).getColumn("productColumn")).setConverter((StringConverter)new StringConverter<MiscUtil.Pair<String, String>>(){

            public String toString(MiscUtil.Pair<String, String> pair) {
                return pair != null ? (String)pair.getFirst() : null;
            }

            public MiscUtil.Pair<String, String> fromString(String string) {
                return null;
            }
        });
        optionsCard.getIsTransferToNewBookingFileNode().setConverter((StringConverter)new StringConverter<Boolean>(){

            public String toString(Boolean value) {
                return value.equals(true) ? Messages.BookingFile_join_transfer_to_new_bookingFile : Messages.BookingFile_join_transfer_to_existing_bookingFile;
            }

            public Boolean fromString(String string) {
                return null;
            }
        });
        optionsCard.getIsTransferToNewBookingFileCell().setCaption("\u00a0");
        optionsCard.getChangeRetailPayerCell().setHelp(() -> new QuickHelp(Messages.Change_retail_client_help));
        optionsCard.getIsTransferToNewBookingFileNode().valueProperty().addListener((obj, oldValue, newValue) -> {
            optionsCard.getBookingFileCell().setHidden(newValue.booleanValue());
            ((EntityBoxWidget)optionsCard.getClientCell().getPayload()).getViewState().setNotEditable(newValue == false);
            if (newValue.booleanValue()) {
                optionsCard.getBookingFileNode().setValue(null);
            }
            this.fillClientAndPayersCells(null, true);
        });
        optionsCard.getBookingFileNode().setListParametersSupplier(this::getListParametersSupplier);
        optionsCard.getBookingFileNode().valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                Notifications.get().submitTask(() -> {
                    EntityContainer bookingCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), newValue);
                    FxUtil.waitForFxThread(() -> ((EntityBoxWidget)optionsCard.getClientCell().getPayload()).setValue(bookingCtr == null ? null : ((BookingFile)bookingCtr.getEntity()).getCustomerProfile()));
                }, Messages.Notifications_getting_data);
            }
        });
        this.controller = new BookingFileJoinCardsContainerController(cardsContainer, false);
        ((EntityBoxWidget)optionsCard.getClientCell().getPayload()).getViewState().setNotEditable(true);
        this.addActionCard(cardsContainer);
        return cardsContainer;
    }

    private void createAndShowDialog(final BookingFileJoinCardsContainer body) {
        final Dialog dialog = new Dialog();
        dialog.setTitle(Messages.BookingFile_join_merge_split_the_bookings).setBody((Node)body).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
            dialog.setOnCloseRequest(null);
            List<Message> messages = this.validateData(body);
            if (!messages.isEmpty()) {
                dialog.setValidationMessages(true, messages);
                return;
            }
            Notifications.get().enqueueAsyncTask(new ClientTask(){

                protected void execute() throws Exception {
                    try {
                        BookingFileJoinDialog.this.saveParameters();
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }

                protected String getTitle() {
                    return Messages.BookingFile_join;
                }
            });
            Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                protected String getTitle() {
                    return Messages.BookingFile_join;
                }

                protected String getTaskClassName() {
                    return "com.gridnine.xtrip.server.fx.async.entityactions.JoinBookingFileAsyncTask";
                }

                protected Serializable getTaskParameters() {
                    JoinBookingFileCreateTaskParameters params = new JoinBookingFileCreateTaskParameters();
                    params.setDeleteEmptyBookingFiles(((BookingFileJoinContainer)body.getOptionsCard().getContent()).getDeleteEmptyBookingFilesNode().isSelected());
                    params.setTransferToNewBookingFile(((BookingFileJoinContainer)body.getOptionsCard().getContent()).getIsTransferToNewBookingFileNode().getValue());
                    params.setNewBookingFile(((BookingFileJoinContainer)body.getOptionsCard().getContent()).getBookingFileNode().getValue());
                    params.setUser(ServiceInvocationContext.get().getUser());
                    params.setChangeRetailPayer(((BookingFileJoinContainer)body.getOptionsCard().getContent()).getChangeRetailPayerNode().getValue());
                    params.setTargetClient(((BookingFileJoinContainer)body.getOptionsCard().getContent()).getClientNode().getValue());
                    ((TableWidget)body.getProductsCard().getContent()).getRowsData().forEach(vm -> {
                        if (vm.isIsSelectedColumn()) {
                            params.getUidsOfSelectedProductsAndBF().put(vm.getProductColumn().getSecond(), vm.getBookingFileColumn());
                        }
                    });
                    return params;
                }

                protected void onCompleted(Object result, List<Message> log) {
                    try {
                        FxUtil.waitForFxThread(() -> ((Dialog)dialog).close());
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                    if (result != null) {
                        RootEntityEditingService.navigateTo((EntityReference)((EntityReference)result));
                    }
                }

                protected void onInterrupted(List<Message> log) {
                    try {
                        FxUtil.waitForFxThread(() -> ((Dialog)dialog).close());
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }
            });
        }).show((Node)this.source);
    }

    private void addActionCard(final BookingFileJoinCardsContainer body) {
        body.getProductsCard().getActions().add((Object)new CardAction<TableWidget<BookingFileJoinTableVM>>(){

            public String getName(Card<TableWidget<BookingFileJoinTableVM>> card) {
                return Messages.BookingFile_join_add_products_from_bookingFile;
            }

            public String getDescription(Card<TableWidget<BookingFileJoinTableVM>> card) {
                return Messages.BookingFile_join_add_products_from_bookingFile;
            }

            public double getWeight() {
                return 1.0;
            }

            public boolean isEnabled(Card<TableWidget<BookingFileJoinTableVM>> card) {
                return true;
            }

            public void execute(Card<TableWidget<BookingFileJoinTableVM>> card, boolean alt) {
                IndexListParameters parameters = new IndexListParameters();
                parameters.setIndexType(BookingFileIndex.class);
                parameters.setLimit(50);
                TableColumnSettings fullNumberCol = new TableColumnSettings();
                TableColumnSettings pnrCol = new TableColumnSettings();
                TableColumnSettings customerNameCol = new TableColumnSettings();
                TableColumnSettings firstTravellerCol = new TableColumnSettings();
                TableColumnSettings travellersCountCol = new TableColumnSettings();
                fullNumberCol.setId(BookingFileIndex.Property.fullNumber.name());
                pnrCol.setId(BookingFileIndex.Property.pnr.name());
                customerNameCol.setId(BookingFileIndex.Property.customerName.name());
                firstTravellerCol.setId(BookingFileIndex.Property.firstTraveller.name());
                travellersCountCol.setId(BookingFileIndex.Property.travellersCount.name());
                parameters.getColumns().add(fullNumberCol);
                parameters.getColumns().add(pnrCol);
                parameters.getColumns().add(customerNameCol);
                parameters.getColumns().add(firstTravellerCol);
                parameters.getColumns().add(travellersCountCol);
                parameters.getSortings().put(BookingFileIndex.Property.fullNumber.name(), SortOrder.ASC);
                IndexListPane<BookingFile, BookingFileIndex> pane = new IndexListPane<BookingFile, BookingFileIndex>(new ObservableMutex(), parameters, SelectionMode.MULTIPLE, false){

                    protected void newConfigurationPopulated() {
                        super.newConfigurationPopulated();
                        this.getTableView().getColumns().add((Object)TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo((EntityReference)item.getSource())));
                    }
                };
                HashSet uidsOfSelectedProducts = new HashSet();
                ((TableWidget)body.getProductsCard().getContent()).getRowsData().forEach(vm -> {
                    if (vm.isIsSelectedColumn()) {
                        uidsOfSelectedProducts.add(vm.getProductColumn().getSecond());
                    }
                });
                new Dialog().setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.getWritingField((String)Messages.BookingFile)).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_CONTINUE, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Choose, () -> this.lambda$execute$5((IndexListPane)pane, uidsOfSelectedProducts), (BooleanExpression)pane.selectionPresentProperty()).show(card.getContent());
            }

            private /* synthetic */ void lambda$execute$5(IndexListPane pane, Set uidsOfSelectedProducts) {
                Notifications.get().submitTask(() -> {
                    Collection newProducts = null;
                    try {
                        newProducts = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getJoinProducts(ServiceInvocationContext.get(), pane.getSelectedItems().stream().map(BookingFileIndex::getSource).filter(itSource -> BookingFileJoinDialog.this.products.stream().noneMatch(prod -> prod.bookingRef.equals(itSource))).collect(Collectors.toSet()));
                        BookingFileJoinDialog.this.products.addAll(newProducts);
                        FxUtil.waitForFxThread(() -> {
                            BookingFileJoinDialog.this.fillingProducts(uidsOfSelectedProducts);
                            BookingFileJoinDialog.this.fillClientAndPayersCells(null, true);
                        });
                    }
                    catch (BookingFileNotFoundException ex) {
                        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.JoinBookingFiles_BookingFileNotFound, (Object[])new Object[0])});
                    }
                }, Messages.Notifications_getting_data);
            }
        });
    }

    private void fillingProducts(Collection<String> uidsOfSelectedProducts) {
        ArrayList<BookingFileJoinTableVM> collTableVM = new ArrayList<BookingFileJoinTableVM>();
        this.products.forEach(index -> {
            BookingFileJoinTableVM element = new BookingFileJoinTableVM();
            element.setBookingFileColumn(index.bookingRef);
            element.setProductColumn(new MiscUtil.Pair((Object)index.productTitle, (Object)index.productUid));
            element.setTravellerColumn(index.travellerName);
            element.setIsSelectedColumn(uidsOfSelectedProducts.contains(index.productUid));
            collTableVM.add(element);
        });
        collTableVM.sort(Comparator.comparing(BookingFileJoinTableVM::getTravellerColumn).thenComparing(b -> b.getBookingFileColumn().getCaption()).thenComparing(b -> (String)b.getProductColumn().getFirst()));
        this.controller.getProducts().readData(collTableVM);
        BooleanValueWidgetColumn column = (BooleanValueWidgetColumn)((TableWidget)this.body.getProductsCard().getContent()).getColumn("isSelectedColumn");
        if (this.listener != null) {
            column.applyToAllRows(it -> it.valueProperty().removeListener(this.listener));
        }
        this.listener = (observable, oldValue, newValue) -> this.fillClientAndPayersCells(null, true);
        column.applyToAllRows(it -> it.valueProperty().addListener(this.listener));
    }

    private List<Message> validateData(BookingFileJoinCardsContainer body) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (!((BookingFileJoinContainer)body.getOptionsCard().getContent()).getIsTransferToNewBookingFileNode().getValue() && ((BookingFileJoinContainer)body.getOptionsCard().getContent()).getBookingFileNode().getValue() == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BookingFile_join_bookingFile_is_empty, (Object[])new Object[0]));
        }
        boolean productSelected = false;
        for (BookingFileJoinTableVM vm : ((TableWidget)body.getProductsCard().getContent()).getRowsData()) {
            if (!vm.isIsSelectedColumn()) continue;
            productSelected = true;
            break;
        }
        if (!productSelected) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BookingFile_join_products_not_selected, (Object[])new Object[0]));
        }
        return messages;
    }

    public static JoinProductsPersistentParameters loadParameters() throws Exception {
        File file = BookingFileJoinDialog.getPreferredDataFile();
        if (!file.exists()) {
            return null;
        }
        JoinProductsPersistentParameters result = new JoinProductsPersistentParameters();
        result.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(Files.readAllBytes(file.toPath())))).getDocumentElement());
        return result;
    }

    private void saveParameters() throws Exception {
        JoinProductsPersistentParameters persistentParameters = new JoinProductsPersistentParameters();
        persistentParameters.setChangeRetailPayer(((BookingFileJoinContainer)this.body.getOptionsCard().getContent()).getChangeRetailPayerNode().getValue());
        File file = BookingFileJoinDialog.getPreferredDataFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        Files.write(file.toPath(), XSUtil.toByteArray((XSSerializable)persistentParameters), new OpenOption[0]);
    }

    private static File getPreferredDataFile() {
        return new File(Environment.getDataFolder(), "settings/preferred_data_join_products_task.xml");
    }

    private IndexListParameters<BookingFile, BookingFileIndex> getListParametersSupplier() {
        Set productsHasSubagencyShipment;
        IndexListParameters parameters = new IndexListParameters();
        parameters.setIndexType(BookingFileIndex.class);
        ListParametersHelper.setColumns(parameters, BookingFileIndex.Property.client.name(), BookingFileIndex.Property.ticketNumbers.name(), BookingFileIndex.Property.fullNumber.name(), BookingFileIndex.Property.pnr.name(), BookingFileIndex.Property.recordLocators.name(), BookingFileIndex.Property.agency.name(), BookingFileIndex.Property.subagency.name());
        ListParametersHelper.setFilters(parameters, BookingFileIndex.Property.agency.name(), BookingFileIndex.Property.client.name());
        Set uidsOfSelectedProducts = ((TableWidget)this.body.getProductsCard().getContent()).getRowsData().stream().filter(BookingFileJoinTableVM::isIsSelectedColumn).map(vm -> (String)vm.getProductColumn().getSecond()).collect(Collectors.toSet());
        Set selectedProducts = this.products.stream().filter(it -> uidsOfSelectedProducts.contains(it.productUid)).collect(Collectors.toSet());
        Set productsHasClientShipment = selectedProducts.stream().filter(it -> it.hasClientShipment).collect(Collectors.toSet());
        if (!productsHasClientShipment.isEmpty()) {
            parameters.getSearchCriterions().add(SearchCriterion.in((String)BookingFileIndex.Property.client.name(), (Object[])productsHasClientShipment.stream().map(it -> it.client).distinct().toArray()));
            parameters.getSearchCriterions().add(SearchCriterion.in((String)BookingFileIndex.Property.subagency.name(), (Object[])productsHasClientShipment.stream().map(it -> it.subagency).distinct().toArray()));
        }
        if (!(productsHasSubagencyShipment = selectedProducts.stream().filter(it -> it.hasSubagencyShipment).collect(Collectors.toSet())).isEmpty()) {
            parameters.getSearchCriterions().add(SearchCriterion.in((String)BookingFileIndex.Property.subagency.name(), (Object[])productsHasSubagencyShipment.stream().map(it -> it.subagency).distinct().toArray()));
            parameters.getSearchCriterions().add(SearchCriterion.in((String)BookingFileIndex.Property.agency.name(), (Object[])productsHasSubagencyShipment.stream().map(it -> it.agency).distinct().toArray()));
        }
        return parameters;
    }
}

