/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class DebitOrderDetachParametersPane
extends CardsContainer {
    private TableWidgetController<TableWidget<FinanceDocumentWrapper>, FinanceDocumentWrapper> controller;
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);
    private final IntegerProperty selectedCount = new SimpleIntegerProperty();

    public DebitOrderDetachParametersPane() {
        Card<Node> generalPane = this.createGUI();
        this.createBindings();
        this.createListeners();
        this.getCards().add(generalPane);
    }

    private Card<Node> createGUI() {
        this.controller = new TableWidgetController<TableWidget<FinanceDocumentWrapper>, FinanceDocumentWrapper>(){
            private final TableWidget<FinanceDocumentWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data);
                this.view.setControlButtonsAvailability(ControlsPane.NONE);
            }

            public TableWidget<FinanceDocumentWrapper> getView() {
                return this.view;
            }
        };
        ArrayList<Object> columns = new ArrayList<Object>();
        InfoWidgetColumn captionColumn = new InfoWidgetColumn(item -> item.getDocument().getCaption(), (a, b) -> {});
        captionColumn.setCaption(Messages.Financial_Document);
        captionColumn.setId("caption");
        columns.add(captionColumn);
        CheckBoxWidgetColumn selectedColumn = new CheckBoxWidgetColumn(FinanceDocumentWrapper::isSelected, FinanceDocumentWrapper::setSelected);
        selectedColumn.setCaption(Messages.Detach);
        selectedColumn.setId("selected");
        columns.add(selectedColumn);
        ((TableWidget)this.controller.getView()).setColumns(columns);
        Card financeDocumentsPane = new Card("financeDocuments", UiCardsContainer.Style.STATIC, Messages.Finance_Documents, this.controller.getView());
        financeDocumentsPane.setAdaptiveHeight(true);
        return financeDocumentsPane;
    }

    private void createListeners() {
        ((TableWidget)this.controller.getView()).setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex() != null ? event.getRowIndex() : 0;
                FinanceDocumentWrapper wrapper = (FinanceDocumentWrapper)((TableWidget)this.controller.getView()).getData(rowIndex);
                CheckBoxWidget checkBoxWidget = (CheckBoxWidget)((TableWidget)this.controller.getView()).getColumn("selected").getWidget(rowIndex);
                if (wrapper != null && checkBoxWidget != null) {
                    checkBoxWidget.selectedProperty().addListener((observable, oldValue, newValue) -> {
                        Collection wrappers = ((TableWidget)this.controller.getView()).getRowsData();
                        wrappers.stream().filter(item -> wrapper.getDocument().equals(item.getDocument()) || wrapper.getRelatedDocuments().contains(item.getDocument())).forEach(item -> {
                            item.setSelected((boolean)newValue);
                            this.selectedCount.set(this.selectedCount.get() + (newValue != false ? 1 : -1));
                        });
                        this.controller.readData(wrappers);
                    });
                }
            }
        });
    }

    private void createBindings() {
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.selectedCount.get() > 0, (Observable[])new Observable[]{this.selectedCount}));
    }

    public void readData(Map<EntityReference<FinanceDocument>, List<EntityReference<FinanceDocument>>> groupedDocuments) {
        ArrayList<FinanceDocumentWrapper> wrappers = new ArrayList<FinanceDocumentWrapper>();
        for (Map.Entry<EntityReference<FinanceDocument>, List<EntityReference<FinanceDocument>>> documentEntry : groupedDocuments.entrySet()) {
            wrappers.add(new FinanceDocumentWrapper(documentEntry.getKey(), documentEntry.getValue(), true));
            this.selectedCount.setValue((Number)(this.selectedCount.get() + 1));
        }
        this.controller.readData(wrappers);
    }

    public List<EntityReference<FinanceDocument>> getSelectedFinanceDocuments() {
        ArrayList wrappers = new ArrayList();
        this.controller.writeData(wrappers);
        return wrappers.stream().filter(FinanceDocumentWrapper::isSelected).map(FinanceDocumentWrapper::getDocument).collect(Collectors.toList());
    }

    public final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    private static class FinanceDocumentWrapper {
        private EntityReference<FinanceDocument> document;
        private List<EntityReference<FinanceDocument>> relatedDocuments;
        private boolean selected;

        public FinanceDocumentWrapper(EntityReference<FinanceDocument> document, List<EntityReference<FinanceDocument>> relatedDocuments, boolean selected) {
            this.document = document;
            this.relatedDocuments = relatedDocuments;
            this.selected = selected;
        }

        public EntityReference<FinanceDocument> getDocument() {
            return this.document;
        }

        public List<EntityReference<FinanceDocument>> getRelatedDocuments() {
            return this.relatedDocuments;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

