/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.PayDialogFOPVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ProductClientFOPDialog;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ProductUnRefusePayClientFOPDialog
extends ProductClientFOPDialog {
    public ProductUnRefusePayClientFOPDialog(String selectedProductUid, EntityReference<BookingFile> bookingFileEntityReference) {
        super(Collections.singletonMap(bookingFileEntityReference, Collections.singletonList(selectedProductUid)), false);
    }

    @Override
    protected String getAcceptButtonCaption() {
        return Messages.Cancel_Refusal;
    }

    @Override
    protected void saturateTableWidget(List<ProductClientFOPDialog.ProductFop> fops, boolean haveProductColumn) {
        TableWidget tableWidget = (TableWidget)this.tableWidgetController.getView();
        if (!haveProductColumn) {
            tableWidget.hideColumn(tableWidget.getColumn("productName"));
        }
        tableWidget.hideColumn(tableWidget.getColumn("uid"));
        tableWidget.getColumn("agent").setNotEditable(Boolean.valueOf(true));
        tableWidget.getColumn("date").setNotEditable(Boolean.valueOf(true));
        tableWidget.getColumn("check").setCaption(Messages.Cancel);
        this.tableWidgetController.readData(fops.stream().map(fop -> {
            PayDialogFOPVM fopVM = new PayDialogFOPVM();
            BigDecimal equivalentAmount = fop.getFop().getEquivalentAmount();
            BigDecimal equivalentAmountNegate = equivalentAmount.negate();
            fopVM.setProductName(fop.getProductName());
            fopVM.setPaymentType(fop.getFop().getType().toString());
            fopVM.setSum(fop.isRefundOrExchange() ? equivalentAmountNegate : equivalentAmount);
            fopVM.setPayment(fop.isRefundOrExchange() ? equivalentAmountNegate : equivalentAmount);
            fopVM.setDate(DateUtils.asLocalDateTime((Date)fop.getFop().getOperationDate()));
            fopVM.setAgent(fop.getFop().getAgent());
            fopVM.setCheck(true);
            fopVM.setUid(fop.getFop().getUid());
            return fopVM;
        }).collect(Collectors.toList()));
    }

    @Override
    protected void updateSourceFop(GeneralProductFop sourceFop, ProductClientFOPDialog.PayDialogFOP selectedFop, boolean refundOrExchange) {
        BigDecimal value = (BigDecimal)selectedFop.paymentWidget.getValue();
        sourceFop.setEquivalentAmount(refundOrExchange ? value.negate() : value);
        sourceFop.setOperationDate(null);
        sourceFop.setAgent(null);
        sourceFop.setRefused(false);
    }

    @Override
    boolean getAdditionalPredicate(GeneralProductFop fop) {
        return fop.isRefused();
    }

    @Override
    String getCardCaption() {
        return Messages.Cancel_Refund;
    }

    @Override
    boolean isPaymentStatusAppropriate(GeneralProductFop generalProductFop) {
        return generalProductFop.getEquivalentAmount() != null && generalProductFop.getOperationDate() != null;
    }

    @Override
    String getNothingToDoMessage() {
        return Messages.No_Refunds_Found;
    }
}

