/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.worklog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.AppStartHook;
import com.gridnine.xtrip.client.fx.core.service.WindowTitleService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.worklog.WorklogFxHelper;
import com.gridnine.xtrip.client.fx.standard.worklog.WorklogStartDialog;
import com.gridnine.xtrip.client.fx.standard.worklog.Workplace;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.WorklogService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Date;
import javafx.scene.Node;

public class WorklogAppStartHook
implements AppStartHook {
    public String getId() {
        return "worklog-init";
    }

    public double getWeight() {
        return 50.0;
    }

    public void execute() {
        try {
            Environment.publish((Object)new Workplace());
            String title = ServiceInvocationContext.get().getUser();
            EntityReference person = Prefetched.getData().getCurrentAgentData().getAgent();
            if (person != null) {
                title = String.format("%s (%s)", title, person.toString());
            }
            WindowTitleService.get().setUser(title);
            Workplace.get().setWorklogEnabled(RpcDictHelper.getPreferenceValue(PreferenceKey.WORKLOG_ENABLED, false));
            if (Workplace.get().isWorklogEnabled() && person != null) {
                EntityReference worklogReference = ((WorklogService)RpcServiceManager.get().getService(WorklogService.class)).getWorklog(ServiceInvocationContext.get(), person, null, new Date());
                EntityContainer worklogContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), worklogReference);
                if (worklogContainer != null) {
                    FxUtil.submitToFxThread(() -> {
                        Dialog dialog = new Dialog();
                        InfoLabelWidget label = new InfoLabelWidget();
                        label.setDefaultText(Messages.WorklogAppStartHook_choice_start_or_end_worklog);
                        SimpleContainer pane = SimpleContainer.create((Node)label);
                        dialog.setBody((Node)pane).setTitle(Messages.WorklogAppStartHook_choice).setExpandToParent(false).setAutoClose(false).addButton(DialogButtonStyle.AUXILARY, Messages.WorklogAppStartHook_close_worklog_and_open_new_worklog, () -> Notifications.get().submitTask(() -> {
                            WorklogFxHelper.closeWorklog((EntityReference<Worklog>)worklogReference);
                            FxUtil.waitForFxThread(() -> {
                                dialog.close();
                                new WorklogStartDialog().start();
                            });
                        }, Messages.Closing_worklog2)).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.WorklogAppStartHook_continue_worklog, () -> {
                            Workplace.get().setWorklogOpen(true);
                            dialog.close();
                            Notifications.get().submitTask(() -> WindowTitleService.get().setStartDate(((Worklog)worklogContainer.getEntity()).getStartDate()), Messages.Notifications_getting_data);
                        }).showGlobal();
                    });
                } else {
                    new WorklogStartDialog().start();
                }
            } else {
                WindowTitleService.get().setStartDate(null);
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }
}

