/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.worklog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.service.WindowTitleService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.system.WorklogContainer;
import com.gridnine.xtrip.client.fx.model.system.WorklogContainerAmountContainer;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.prefetched.PrefetchedHelper;
import com.gridnine.xtrip.client.fx.standard.worklog.Workplace;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.WorklogService;
import com.gridnine.xtrip.common.fx.rpc.WorklogServiceResult;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.WorklogHelper;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorklogStartDialog {
    private static final Logger log = LoggerFactory.getLogger(WorklogStartDialog.class);
    private final ServiceInvocationContext sic = ServiceInvocationContext.get();
    private WorklogService worklogService;
    private Date date;
    private EntityReference<Person> person;
    private EntityReference<Organization> prefOrganization;
    private EntityReference<SalesPoint> prefetchedSalesPoint;
    private EntityReference<Cash> prefetchedCash;
    private EntityReference<CashRegister> prefCashReg;
    private EntityReference<CashRegisterWorkplace> prefCashRegWorkplace;
    private final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
    private final WorklogContainer body = new WorklogContainer(false);
    private final VBox box = new VBox(new Node[]{this.body});
    private final List<PersonType> listPersonType = new ArrayList<PersonType>();
    private final List<EntityReference<Organization>> listAgency = new ArrayList<EntityReference<Organization>>();
    private final Map<EntityReference<Organization>, List<EntityReference<SalesPoint>>> mapAgencyToSalesPoint = new HashMap<EntityReference<Organization>, List<EntityReference<SalesPoint>>>();
    private final Map<EntityReference<Organization>, List<EntityReference<Cash>>> mapAgencyToCash = new HashMap<EntityReference<Organization>, List<EntityReference<Cash>>>();
    private final Map<EntityReference<SalesPoint>, List<EntityReference<Cash>>> mapSalesPointToCash = new HashMap<EntityReference<SalesPoint>, List<EntityReference<Cash>>>();
    private final Map<EntityReference<SalesPoint>, List<EntityReference<CashRegister>>> mapSalesPointToCashRegister = new HashMap<EntityReference<SalesPoint>, List<EntityReference<CashRegister>>>();
    private final Map<EntityReference<SalesPoint>, List<EntityReference<CashRegisterWorkplace>>> mapSalesPointToCashRegisterWorkplace = new HashMap<EntityReference<SalesPoint>, List<EntityReference<CashRegisterWorkplace>>>();

    WorklogStartDialog() {
    }

    void start() {
        Notifications.get().submitTask(() -> {
            this.loadData();
            FxUtil.waitForFxThread(() -> {
                this.customizeBody();
                this.showDialog();
            });
        }, Messages.Notifications_getting_data);
    }

    private void loadData() throws Exception {
        this.date = new Date();
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        this.person = agentData.getAgent();
        this.prefOrganization = agentData.getSubagency();
        this.prefetchedSalesPoint = agentData.getSalesPoint();
        this.prefetchedCash = agentData.getCash();
        this.prefCashReg = agentData.getCashRegister();
        this.prefCashRegWorkplace = agentData.getCashRegisterWorkplace();
        this.worklogService = (WorklogService)RpcServiceManager.get().getService(WorklogService.class);
        WorklogServiceResult data = this.worklogService.loadDataForDialog(ServiceInvocationContext.get(), agentData, this.date);
        this.listPersonType.addAll(data.getListPersonType());
        this.listAgency.addAll(data.getListAgency());
        this.mapAgencyToSalesPoint.putAll(data.getMapAgencyToSalesPoint());
        this.mapAgencyToCash.putAll(data.getMapAgencyToCash());
        this.mapSalesPointToCash.putAll(data.getMapSalesPointToCash());
        this.mapSalesPointToCashRegister.putAll(data.getMapSalesPointToCashRegister());
        this.mapSalesPointToCashRegisterWorkplace.putAll(data.getMapSalesPointToCashRegisterWorkplace());
    }

    private void actualizeBody() {
        EntityReference salesPoint;
        EntityReference agency;
        this.clearValidationMessagesLock(this.box);
        ObservableList types = this.body.getPersonTypeNode().getValues();
        if (types.contains((Object)PersonType.AGENT)) {
            this.body.getSalesPointNode().getViewState().setNotEditable(false);
            this.body.getCashNode().getViewState().setNotEditable(false);
            this.body.getCashRegisterNode().getViewState().setNotEditable(false);
            this.body.getCashRegisterWorkplaceNode().getViewState().setNotEditable(false);
        } else if (types.contains((Object)PersonType.CASHIER_CLERK)) {
            this.body.getSalesPointNode().getViewState().setNotEditable(false);
            this.body.getCashNode().getViewState().setNotEditable(false);
            this.body.getCashRegisterNode().getViewState().setNotEditable(false);
            this.body.getCashRegisterWorkplaceNode().getViewState().setNotEditable(true);
            this.body.getCashRegisterWorkplaceNode().setValue(null);
        } else if (types.contains((Object)PersonType.CASHIER_ACCOUNTANT)) {
            this.body.getSalesPointNode().getViewState().setNotEditable(false);
            this.body.getCashNode().getViewState().setNotEditable(false);
            this.body.getCashRegisterNode().getViewState().setNotEditable(true);
            this.body.getCashRegisterWorkplaceNode().getViewState().setNotEditable(true);
            this.body.getCashRegisterNode().setValue(null);
            this.body.getCashRegisterWorkplaceNode().setValue(null);
        } else {
            this.body.getSalesPointNode().getViewState().setNotEditable(true);
            this.body.getCashNode().getViewState().setNotEditable(true);
            this.body.getCashRegisterNode().getViewState().setNotEditable(true);
            this.body.getCashRegisterWorkplaceNode().getViewState().setNotEditable(true);
            this.body.getSalesPointNode().setValue(null);
            this.body.getCashNode().setValue(null);
            this.body.getCashRegisterNode().setValue(null);
            this.body.getCashRegisterWorkplaceNode().setValue(null);
        }
        if (!types.contains((Object)PersonType.CASHIER_ACCOUNTANT)) {
            this.body.getAmountContainerNode().getTempNode().getCashCalculatedValueNode().setValue(null);
            this.body.getAmountContainerNode().getTempNode().getCashFactualValueNode().setValue(null);
            this.body.getAmountContainerNode().getTempNode().getCashFactualValueNode().getViewState().setNotEditable(true);
        }
        if (!this.body.getAgencyNode().getViewState().isImmutable() && this.listAgency.isEmpty()) {
            this.box.getChildren().add(0, (Object)new MessagePaneLock(MessageType.ERROR, String.format(Messages.WorklogStartDialog_validation_empty_agencies_lock, this.person, this.format.format(this.date)), null));
        }
        if ((agency = (EntityReference)this.body.getAgencyNode().getValue()) == null) {
            this.body.getSalesPointNode().setValue(null);
            this.body.getCashNode().setValue(null);
        }
        ArrayList listItemSupplierCash = new ArrayList();
        if (agency != null) {
            listItemSupplierCash.addAll(this.mapAgencyToCash.get(agency));
        }
        if ((salesPoint = (EntityReference)this.body.getSalesPointNode().getValue()) != null) {
            listItemSupplierCash.addAll(this.mapSalesPointToCash.get(salesPoint));
            List<EntityReference<CashRegister>> cashRegister = this.mapSalesPointToCashRegister.get(salesPoint);
            this.body.getCashRegisterNode().setItemsSupplier(() -> cashRegister);
            if (!this.body.getCashRegisterNode().getViewState().isImmutable()) {
                if (cashRegister.isEmpty()) {
                    this.box.getChildren().add(0, (Object)new MessagePaneLock(MessageType.ERROR, String.format(Messages.WorklogStartDialog_validation_empty_cash_registry_lock, agency), null));
                } else if (cashRegister.size() == 1) {
                    this.body.getCashRegisterNode().setValue(cashRegister.get(0));
                }
            }
            List<EntityReference<CashRegisterWorkplace>> cashRegisterWorkplace = this.mapSalesPointToCashRegisterWorkplace.get(salesPoint);
            this.body.getCashRegisterWorkplaceNode().setItemsSupplier(() -> cashRegisterWorkplace);
            if (!this.body.getCashRegisterWorkplaceNode().getViewState().isImmutable()) {
                if (cashRegisterWorkplace.isEmpty()) {
                    this.box.getChildren().add(0, (Object)new MessagePaneLock(MessageType.ERROR, String.format(Messages.WorklogStartDialog_validation_empty_cash_registry_workplace_lock, agency), null));
                } else if (cashRegisterWorkplace.size() == 1) {
                    this.body.getCashRegisterWorkplaceNode().setValue(cashRegisterWorkplace.get(0));
                }
            }
        } else {
            this.body.getCashRegisterNode().setValue(null);
            this.body.getCashRegisterWorkplaceNode().setValue(null);
            this.body.getCashRegisterNode().setItemsSupplier(ArrayList::new);
            this.body.getCashRegisterWorkplaceNode().setItemsSupplier(ArrayList::new);
        }
        this.body.getCashNode().setItemsSupplier(() -> listItemSupplierCash);
        if (!this.body.getCashNode().getViewState().isImmutable() && agency != null && salesPoint != null) {
            if (listItemSupplierCash.isEmpty()) {
                this.box.getChildren().add(0, (Object)new MessagePaneLock(MessageType.ERROR, String.format(Messages.WorklogStartDialog_validation_empty_cash_lock, agency, salesPoint), null));
            } else if (listItemSupplierCash.size() == 1) {
                this.body.getCashNode().setValue(listItemSupplierCash.get(0));
            }
        }
        this.body.getSalesPointNode().setItemsSupplier(() -> this.mapAgencyToSalesPoint.get(agency));
        if (!this.body.getSalesPointNode().getViewState().isImmutable() && agency != null) {
            if (this.mapAgencyToSalesPoint.get(agency).isEmpty()) {
                this.box.getChildren().add(0, (Object)new MessagePaneLock(MessageType.ERROR, String.format(Messages.WorklogStartDialog_validation_empty_sales_point_lock, agency), null));
            }
            if (this.mapAgencyToSalesPoint.get(agency).size() == 1) {
                this.body.getSalesPointNode().setValue(this.mapAgencyToSalesPoint.get(agency).get(0));
            }
        }
    }

    private void customizeBody() {
        this.body.getSalesPointNode().getViewState().setNotEditable(true);
        this.body.getCashNode().getViewState().setNotEditable(true);
        this.body.getCashRegisterNode().getViewState().setNotEditable(true);
        this.body.getCashRegisterNode().setLive(true);
        this.body.getCashRegisterWorkplaceNode().getViewState().setNotEditable(true);
        this.body.getSalesPointNode().setLive(true);
        this.body.getCashNode().setLive(true);
        this.body.getPersonTypeNode().setItemsSupplier(() -> this.listPersonType);
        this.body.getPersonTypeNode().getValues().addListener(change -> this.customizeBodyFromPersonType((ObservableList<? extends PersonType>)change.getList()));
        this.body.getAgencyNode().valueProperty().addListener((obs, oldValue, newValue) -> {
            this.body.getSalesPointNode().setValue(null);
            this.body.getCashNode().setValue(null);
            this.actualizeBody();
        });
        this.body.getSalesPointNode().setLive(true);
        this.body.getSalesPointNode().valueProperty().addListener((obs, oldValue, newValue) -> {
            this.body.getCashNode().setValue(null);
            this.body.getCashRegisterNode().setValue(null);
            this.body.getCashRegisterWorkplaceNode().setValue(null);
            this.actualizeBody();
        });
        WorklogContainerAmountContainer amountTable = this.body.getAmountContainerNode().getTempNode();
        this.body.getCashNode().setLive(true);
        this.body.getCashNode().valueProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue == null) {
                amountTable.getCashCalculatedValueNode().setValue(null);
                amountTable.getCashFactualValueNode().setValue(null);
                amountTable.getCashFactualValueNode().getViewState().setNotEditable(true);
            } else if (this.body.getPersonTypeNode().getValues().contains((Object)PersonType.CASHIER_ACCOUNTANT)) {
                Notifications.get().submitTask(() -> {
                    BigDecimal amount = this.worklogService.calculateBalanceCash(this.sic, newValue, (EntityReference)this.body.getAgencyNode().getValue(), this.date).getValue();
                    FxUtil.waitForFxThread(() -> {
                        amountTable.getCashCalculatedValueNode().setValue((Number)amount);
                        amountTable.getCashFactualValueNode().setValue((Number)amount);
                        amountTable.getCashFactualValueNode().getViewState().setNotEditable(false);
                    });
                }, Messages.WorklogStartDialog_calculate_amount_cash);
            }
        });
        this.body.getCashRegisterWorkplaceNode().setLive(true);
        this.body.getCashRegisterWorkplaceNode().valueProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue == null) {
                amountTable.getCashRegistryWorkplaceCalculatedValueNode().setValue(null);
                amountTable.getCashRegistryWorkplaceFactualValueNode().setValue(null);
                amountTable.getCashRegistryWorkplaceFactualValueNode().getViewState().setNotEditable(true);
            } else {
                Notifications.get().submitTask(() -> {
                    BigDecimal amount = this.worklogService.calculateBalanceCashRegisterWorkplace(this.sic, (EntityReference)this.body.getSalesPointNode().getValue(), newValue, this.person, (EntityReference)this.body.getAgencyNode().getValue(), this.date);
                    FxUtil.waitForFxThread(() -> {
                        amountTable.getCashRegistryWorkplaceCalculatedValueNode().setValue((Number)amount);
                        amountTable.getCashRegistryWorkplaceFactualValueNode().setValue((Number)amount);
                        amountTable.getCashRegistryWorkplaceFactualValueNode().getViewState().setNotEditable(false);
                    });
                }, Messages.WorklogStartDialog_calculate_amount_cash_registry_workplace);
            }
        });
        this.body.getAgencyNode().setItemsSupplier(() -> this.listAgency);
        if (this.listAgency.size() == 1) {
            this.body.getAgencyNode().setValue(this.listAgency.get(0));
        }
        if (this.listPersonType.size() == 1) {
            this.body.getPersonTypeNode().getValues().clear();
            this.body.getPersonTypeNode().getValues().add((Object)this.listPersonType.get(0));
        }
    }

    private void customizeBodyFromPersonType(ObservableList<? extends PersonType> types) {
        this.actualizeBody();
    }

    private void showDialog() {
        if (this.listPersonType.isEmpty() || this.listAgency.isEmpty()) {
            String error = String.format(Messages.WorklogStartDialog_main_part_error_msg, ServiceInvocationContext.get().getUser());
            if (this.listPersonType.isEmpty()) {
                error = error + Messages.WorklogStartDialog_main_part_error_msg_empty_role;
            }
            if (this.listAgency.isEmpty()) {
                error = error + Messages.WorklogStartDialog_main_part_error_msg_empty_organization;
            }
            error = error + Messages.WorklogStartDialog_main_part_error_msg_end;
            this.box.getChildren().add(0, (Object)new MessagePaneLock(MessageType.ERROR, error, null));
        }
        this.fillDialogBodyWithPrefetched();
        ObservableMutex mutex = new ObservableMutex();
        Dialog dialog = new Dialog();
        dialog.setAutoClose(false).setExpandToParent(false).setTitle(Messages.WorklogStartDialog_start_work + " " + this.person.getCaption()).setBody((Node)this.box).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.WorklogStartDialog_accept, () -> {
            log.debug(String.format("worklog prepare for %s -> date -> %s", this.sic.getUser(), DebugUtil.toString((Date)this.date)));
            if (this.box.getChildren().get(0) instanceof MessagePaneLock) {
                log.debug(String.format("worklog prepare for %s -> messages exists", this.sic.getUser()));
                return;
            }
            this.clearValidationMessages(this.box);
            List<String> messages = this.validateData();
            if (!messages.isEmpty()) {
                log.debug(String.format("worklog prepare for %s -> validation failed", this.sic.getUser()));
                messages.forEach(message -> {
                    this.box.getChildren().add(0, (Object)MessagePane.error((String)message));
                    Notifications.get().getScheduler().schedule(() -> FxUtil.submitToFxThread(() -> this.clearValidationMessages(this.box)), 10L, TimeUnit.SECONDS);
                });
                return;
            }
            Notifications.get().submitTask(() -> {
                Worklog worklog = new Worklog();
                log.debug(String.format("worklog prepare for %s -> worklog created -> %s", this.sic.getUser(), worklog.getUid()));
                this.writeData(worklog);
                log.debug(String.format("worklog prepare for %s -> worklog -> %s", this.sic.getUser(), DebugUtil.decorate((String)WorklogHelper.toString((Worklog)worklog), null, (String)"worklog", (boolean)true)));
                if (!this.checkWorklog(worklog, true)) {
                    log.debug(String.format("worklog prepare for %s -> check failed", this.sic.getUser()));
                    return;
                }
                worklog.setStartDate(this.date);
                this.handleWorklog(worklog, (BigDecimal)this.body.getAmountContainerNode().getTempNode().getCashRegistryWorkplaceFactualValueNode().getValue(), (BigDecimal)this.body.getAmountContainerNode().getTempNode().getCashRegistryWorkplaceCalculatedValueNode().getValue(), (BigDecimal)this.body.getAmountContainerNode().getTempNode().getCashFactualValueNode().getValue(), (BigDecimal)this.body.getAmountContainerNode().getTempNode().getCashCalculatedValueNode().getValue());
                this.saveNewWorklog(worklog);
                FxUtil.waitForFxThread(() -> {
                    dialog.close();
                    Workplace.get().setWorklogOpen(true);
                });
                WindowTitleService.get().setStartDate(this.date);
            }, mutex);
        }, (BooleanExpression)mutex.acquiredProperty().not()).showGlobal();
    }

    private void handleWorklog(Worklog worklog, BigDecimal cashRegistryWorkplaceFactualValue, BigDecimal cashRegistryWorkplaceCalculatedValue, BigDecimal cashFactualValue, BigDecimal cashCalculatedValue) throws ServiceException {
        log.info(String.format("handle worklog of %s (%s) -> handle start -> user -> %s", worklog.getEmployee(), worklog.getUid(), this.sic.getUser()));
        log.info(String.format("handle worklog of %s (%s) -> worklog -> \n\n%s", worklog.getEmployee(), worklog.getUid(), DebugUtil.decorate((String)WorklogHelper.toString((Worklog)worklog), null, (String)"worklog", (boolean)true)));
        log.info(String.format("handle worklog of %s (%s) -> date -> %s", worklog.getEmployee(), worklog.getUid(), DebugUtil.toString((Date)this.date)));
        log.info(String.format("handle worklog of %s (%s) -> workplaceFactualValue -> %s", worklog.getEmployee(), worklog.getUid(), cashRegistryWorkplaceFactualValue));
        log.info(String.format("handle worklog of %s (%s) -> workplaceCalculatedValue -> %s", worklog.getEmployee(), worklog.getUid(), cashRegistryWorkplaceCalculatedValue));
        log.info(String.format("handle worklog of %s (%s) -> cashFactualValue -> %s", worklog.getEmployee(), worklog.getUid(), cashFactualValue));
        log.info(String.format("handle worklog of %s (%s) -> cashCalculatedValue -> %s", worklog.getEmployee(), worklog.getUid(), cashCalculatedValue));
        this.worklogService.handleWorklog(this.sic, worklog, this.date, cashRegistryWorkplaceFactualValue, cashRegistryWorkplaceCalculatedValue, cashFactualValue, cashCalculatedValue);
        log.info(String.format("handle worklog of %s (%s) -> handle end -> user -> %s", worklog.getEmployee(), worklog.getUid(), this.sic.getUser()));
    }

    private void fillDialogBodyWithPrefetched() {
        this.body.getPersonTypeNode().getValues().clear();
        this.body.getPersonTypeNode().getValues().addAll(this.listPersonType);
        if (this.prefOrganization != null && this.listAgency.contains(this.prefOrganization)) {
            this.body.getAgencyNode().setValue(this.prefOrganization);
            if (this.prefetchedSalesPoint != null && this.mapAgencyToSalesPoint.get(this.prefOrganization).contains(this.prefetchedSalesPoint)) {
                this.body.getSalesPointNode().setValue(this.prefetchedSalesPoint);
                if (this.prefetchedCash != null && (this.mapAgencyToCash.get(this.prefOrganization).contains(this.prefetchedCash) || this.mapSalesPointToCash.get(this.prefetchedSalesPoint).contains(this.prefetchedCash))) {
                    this.body.getCashNode().setValue(this.prefetchedCash);
                }
                if (this.prefCashReg != null && this.mapSalesPointToCashRegister.get(this.prefetchedSalesPoint).contains(this.prefCashReg)) {
                    this.body.getCashRegisterNode().setValue(this.prefCashReg);
                }
                if (this.prefCashRegWorkplace != null && this.mapSalesPointToCashRegisterWorkplace.get(this.prefetchedSalesPoint).contains(this.prefCashRegWorkplace)) {
                    this.body.getCashRegisterWorkplaceNode().setValue(this.prefCashRegWorkplace);
                }
            }
        }
    }

    private void saveNewWorklog(Worklog worklog) throws Exception {
        PrefetchedHelper.saveAgentDataInfo(worklog);
        Prefetched.load();
    }

    private boolean checkWorklog(Worklog worklog, boolean needWarning) throws Exception {
        log.info(String.format("check worklog of %s (%s) -> worklog -> \n\n%s", worklog.getEmployee(), worklog.getUid(), DebugUtil.decorate((String)WorklogHelper.toString((Worklog)worklog), null, (String)"worklog", (boolean)true)));
        if (worklog.getTypes().contains(PersonType.AGENT) || worklog.getTypes().contains(PersonType.CASHIER_CLERK) || worklog.getTypes().contains(PersonType.CASHIER_ACCOUNTANT)) {
            MiscUtil.Pair pair;
            if (worklog.getTypes().contains(PersonType.AGENT)) {
                log.info(String.format("check worklog of %s (%s) -> type -> %s", worklog.getEmployee(), worklog.getUid(), PersonType.AGENT.name()));
                pair = this.worklogService.checkAgentWorklog(this.sic, worklog, this.date);
                if (pair != null) {
                    log.info(String.format("check worklog of %s (%s) -> workplace occupied -> %s (%s)", worklog.getEmployee(), worklog.getUid(), pair.getSecond(), pair.getFirst()));
                    if (needWarning) {
                        FxUtil.waitForFxThread(() -> this.createWarningDialog((MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>>)pair, Messages.WorklogStartDialog_workplace_is_occupied));
                    }
                    return false;
                }
            }
            if (worklog.getTypes().contains(PersonType.CASHIER_CLERK)) {
                log.info(String.format("check worklog of %s (%s) -> type -> %s", worklog.getEmployee(), worklog.getUid(), PersonType.CASHIER_CLERK.name()));
                pair = this.worklogService.checkCashierClerkWorklog(this.sic, worklog, this.date);
                if (pair != null) {
                    log.info(String.format("check worklog of %s (%s) -> workplace occupied -> %s (%s)", worklog.getEmployee(), worklog.getUid(), pair.getSecond(), pair.getFirst()));
                    if (needWarning) {
                        FxUtil.waitForFxThread(() -> this.createWarningDialog((MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>>)pair, Messages.WorklogStartDialog_cash_register_workplace_is_occupied));
                    }
                    return false;
                }
            }
            if (worklog.getTypes().contains(PersonType.CASHIER_ACCOUNTANT)) {
                log.info(String.format("check worklog of %s (%s) -> type -> %s", worklog.getEmployee(), worklog.getUid(), PersonType.CASHIER_ACCOUNTANT.name()));
                pair = this.worklogService.checkCashierAccountantWorklog(this.sic, worklog, this.date);
                if (pair != null) {
                    log.info(String.format("check worklog of %s (%s) -> workplace occupied -> %s (%s)", worklog.getEmployee(), worklog.getUid(), pair.getSecond(), pair.getFirst()));
                    if (needWarning) {
                        FxUtil.waitForFxThread(() -> this.createWarningDialog((MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>>)pair, Messages.WorklogStartDialog_cash_is_occupied));
                    }
                    return false;
                }
            }
        } else {
            log.info(String.format("check worklog of %s (%s) -> type -> %s", worklog.getEmployee(), worklog.getUid(), "XXX"));
            MiscUtil.Pair pair = this.worklogService.checkEmployeeWorklog(this.sic, worklog, this.date);
            if (pair != null) {
                log.info(String.format("check worklog of %s (%s) -> workplace occupied -> %s (%s)", worklog.getEmployee(), worklog.getUid(), pair.getSecond(), pair.getFirst()));
                if (needWarning) {
                    FxUtil.waitForFxThread(() -> this.createWarningDialog((MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>>)pair, Messages.WorklogStartDialog_agent_is_working));
                }
                return false;
            }
        }
        return true;
    }

    private void createWarningDialog(MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> pair, String msg) {
        SimpleContainer body = new SimpleContainer();
        InfoLabelWidget label = new InfoLabelWidget();
        label.getViewState().setReadonly(true);
        label.setDefaultText(String.format(msg, pair.getSecond()));
        body.setContent((Node)label);
        Dialog dialogAgent = new Dialog();
        dialogAgent.setAutoClose(false).setTitle(Messages.WorklogStartDialog_start_work + " " + this.person.getCaption()).setBody((Node)body).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialogAgent).close()).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.WorklogStartDialog_end_work, () -> {
            Notifications.get().submitTask(() -> {
                ((WorklogService)RpcServiceManager.get().getService(WorklogService.class)).closeWorklog(this.sic, (EntityReference)pair.getFirst(), MiscUtil.getBeforeTime((Date)this.date), true);
                Workplace.get().setWorklogOpen(false);
            }, Messages.Notifications_getting_data);
            dialogAgent.close();
        }).showGlobal();
    }

    private void writeData(Worklog worklog) {
        worklog.setEmployee(this.person);
        worklog.getTypes().clear();
        worklog.getTypes().addAll(this.body.getPersonTypeNode().getValues());
        worklog.setAgency((EntityReference)this.body.getAgencyNode().getValue());
        worklog.setSalesPoint((EntityReference)this.body.getSalesPointNode().getValue());
        worklog.setCash((EntityReference)this.body.getCashNode().getValue());
        worklog.setCashRegister((EntityReference)this.body.getCashRegisterNode().getValue());
        worklog.setCashRegisterWorkplace((EntityReference)this.body.getCashRegisterWorkplaceNode().getValue());
    }

    private void clearValidationMessages(VBox vbox) {
        vbox.getChildren().removeAll((Collection)vbox.getChildren().stream().filter(node -> !MessagePaneLock.class.isAssignableFrom(node.getClass()) && node.getClass().isAssignableFrom(MessagePane.class)).collect(Collectors.toList()));
    }

    private void clearValidationMessagesLock(VBox vbox) {
        vbox.getChildren().removeAll((Collection)vbox.getChildren().stream().filter(node -> node.getClass().isAssignableFrom(MessagePaneLock.class)).collect(Collectors.toList()));
    }

    private List<String> validateData() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.body.getPersonTypeNode().getValues().isEmpty()) {
            result.add(Messages.WorklogStartDialog_validation_empty_person_type);
        }
        if (this.body.getAgencyNode().getValue() == null) {
            result.add(Messages.WorklogStartDialog_validation_empty_agency);
        }
        if (!this.body.getSalesPointNode().getViewState().isImmutable() && this.body.getSalesPointNode().getValue() == null) {
            result.add(Messages.WorklogStartDialog_validation_empty_sales_point);
        }
        if (!this.body.getCashNode().getViewState().isImmutable() && this.body.getCashNode().getValue() == null) {
            result.add(Messages.WorklogStartDialog_validation_empty_cash);
        }
        if (!this.body.getCashRegisterNode().getViewState().isImmutable() && this.body.getCashRegisterNode().getValue() == null) {
            result.add(Messages.WorklogStartDialog_validation_empty_cash_registry);
        }
        if (!this.body.getCashRegisterWorkplaceNode().getViewState().isImmutable() && this.body.getCashRegisterWorkplaceNode().getValue() == null) {
            result.add(Messages.WorklogStartDialog_validation_empty_cash_registry_workplace);
        }
        return result;
    }

    private class MessagePaneLock
    extends MessagePane {
        private MessagePaneLock(MessageType type, String message, String details) {
            super(type, message, details);
        }
    }
}

