/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.workspace;

import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.workspace.WorkspaceEditorPane;
import com.gridnine.xtrip.client.fx.standard.workspace.WorkspaceEditorTool;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import javafx.scene.control.TreeItem;

public enum Tools implements WorkspaceEditorTool
{
    ADD{

        @Override
        public String getName(WorkspaceEditorPane editor) {
            return Messages.To_Create;
        }

        @Override
        public String getDescription(WorkspaceEditorPane editor) {
            return Messages.Create_new_element;
        }

        @Override
        public boolean isEnabled(WorkspaceEditorPane editor) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            return item != null;
        }

        @Override
        public void execute(WorkspaceEditorPane editor, boolean alt) {
            TreeItem<FxWorkspaceItem> child;
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            if (item != null && (child = editor.createTreeItem()) != null) {
                editor.addTreeItem(item, child, 0);
            }
        }
    }
    ,
    CLONE{

        @Override
        public String getName(WorkspaceEditorPane editor) {
            return Messages.Copy;
        }

        @Override
        public String getDescription(WorkspaceEditorPane editor) {
            return Messages.Create_copy;
        }

        @Override
        public boolean isEnabled(WorkspaceEditorPane editor) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            return item != null && item.getParent() != null;
        }

        @Override
        public void execute(WorkspaceEditorPane editor, boolean alt) {
            TreeItem<FxWorkspaceItem> child;
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            if (item != null && item.getParent() != null && (child = editor.cloneTreeItem(item)) != null) {
                editor.addTreeItem((TreeItem<FxWorkspaceItem>)item.getParent(), child, item.getParent().getChildren().indexOf(item) + 1);
            }
        }
    }
    ,
    DELETE{

        @Override
        public String getName(WorkspaceEditorPane editor) {
            return Messages.Delete;
        }

        @Override
        public String getDescription(WorkspaceEditorPane editor) {
            return Messages.Delete;
        }

        @Override
        public boolean isEnabled(WorkspaceEditorPane editor) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            return item != null && item.getParent() != null;
        }

        @Override
        public void execute(WorkspaceEditorPane editor, boolean alt) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            if (item != null && item.getParent() != null) {
                editor.removeTreeItem(item);
            }
        }
    }
    ,
    UP{

        @Override
        public String getName(WorkspaceEditorPane editor) {
            return Messages.Upward;
        }

        @Override
        public String getDescription(WorkspaceEditorPane editor) {
            return Messages.Move_Up;
        }

        @Override
        public boolean isEnabled(WorkspaceEditorPane editor) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            return item != null && item.getParent() != null && item.getParent().getChildren().indexOf(item) > 0;
        }

        @Override
        public void execute(WorkspaceEditorPane editor, boolean alt) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            if (item != null && item.getParent() != null && item.getParent().getChildren().indexOf(item) > 0) {
                editor.moveTreeItem(item, false);
            }
        }
    }
    ,
    DOWN{

        @Override
        public String getName(WorkspaceEditorPane editor) {
            return Messages.Downward;
        }

        @Override
        public String getDescription(WorkspaceEditorPane editor) {
            return Messages.Move_Down;
        }

        @Override
        public boolean isEnabled(WorkspaceEditorPane editor) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            return item != null && item.getParent() != null && item.getParent().getChildren().indexOf(item) < item.getParent().getChildren().size() - 1;
        }

        @Override
        public void execute(WorkspaceEditorPane editor, boolean alt) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            if (item != null && item.getParent() != null && item.getParent().getChildren().indexOf(item) < item.getParent().getChildren().size() - 1) {
                editor.moveTreeItem(item, true);
            }
        }
    }
    ,
    MOVE{

        @Override
        public String getName(WorkspaceEditorPane editor) {
            return Messages.Move;
        }

        @Override
        public String getDescription(WorkspaceEditorPane editor) {
            return Messages.Move_selected_element_to_the_specified_position;
        }

        @Override
        public boolean isEnabled(WorkspaceEditorPane editor) {
            return false;
        }

        @Override
        public void execute(WorkspaceEditorPane editor, boolean alt) {
            StandardNotifications.NOT_IMPLEMENTED.show(null);
        }
    }
    ,
    VIEW{

        @Override
        public String getName(WorkspaceEditorPane editor) {
            return Messages.To_View;
        }

        @Override
        public String getDescription(WorkspaceEditorPane editor) {
            return Messages.View_the_selected_item;
        }

        @Override
        public boolean isEnabled(WorkspaceEditorPane editor) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            if (item != null && ((FxWorkspaceItem)item.getValue()).getToolId() != null) {
                NavTool tool = NavTool.forId((String)((FxWorkspaceItem)item.getValue()).getToolId());
                return tool.isExecutable();
            }
            return false;
        }

        @Override
        public void execute(WorkspaceEditorPane editor, boolean alt) {
            TreeItem<FxWorkspaceItem> item = editor.getSelectedItem();
            if (item != null) {
                editor.previewTreeItem(item);
            }
        }
    };


    @Override
    public double getWeight() {
        return this.ordinal();
    }
}

