/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.workspace;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.standard.workspace.Tools;
import com.gridnine.xtrip.client.fx.standard.workspace.WorkspaceEditorPane;
import com.gridnine.xtrip.client.fx.standard.workspace.WorkspaceManagerAction;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;

public class WorkspaceManagerPane
extends BaseContentPane
implements ShortcutHandler {
    private final ObservableMutex mutex;
    private final ActionsPane<WorkspaceManagerAction> actionsPane = new ActionsPane<WorkspaceManagerAction>(){

        protected boolean isDefault(WorkspaceManagerAction action) {
            return false;
        }

        protected boolean isEnabled(WorkspaceManagerAction action) {
            if (WorkspaceManagerPane.this.getMutex().isAcquired()) {
                return false;
            }
            return action.isEnabled((Object)WorkspaceManagerPane.this);
        }

        protected void execute(Control source, WorkspaceManagerAction action, boolean alt) {
            action.execute(source, (Object)WorkspaceManagerPane.this, alt);
        }

        protected String getName(WorkspaceManagerAction action) {
            return action.getName(WorkspaceManagerPane.this);
        }

        protected String getDescription(WorkspaceManagerAction action) {
            return action.getDescription(WorkspaceManagerPane.this);
        }

        protected ActionIcon getIcon(WorkspaceManagerAction action) {
            return action.getIcon((Object)WorkspaceManagerPane.this);
        }
    };
    private final Tile<Node, WorkspaceEditorPane> tile;
    private InvalidationListener acquiredListener;

    WorkspaceManagerPane(ObservableMutex mtx) {
        this.mutex = mtx;
        this.getStyleClass().add((Object)"xtrip-workspace-editor-pane");
        TilesSpace space = new TilesSpace(1);
        this.tile = new Tile("main", "Standard workspace", null, (Node)new WorkspaceEditorPane(this));
        for (final Tools tool : Tools.values()) {
            this.tile.getActions().add((Object)new TileAction<Node, WorkspaceEditorPane>(){

                public boolean isEnabled(Tile<Node, WorkspaceEditorPane> tl) {
                    return tool.isEnabled((WorkspaceEditorPane)tl.getFullNode());
                }

                public double getWeight() {
                    return tool.getWeight();
                }

                public String getName(Tile<Node, WorkspaceEditorPane> tl) {
                    return tool.getName((WorkspaceEditorPane)tl.getFullNode());
                }

                public String getDescription(Tile<Node, WorkspaceEditorPane> tl) {
                    return tool.getDescription((WorkspaceEditorPane)tl.getFullNode());
                }

                public void execute(Control source, Tile<Node, WorkspaceEditorPane> tl, boolean alt) {
                    tool.execute((WorkspaceEditorPane)tl.getFullNode(), alt);
                }
            });
        }
        space.addTiles(new Tile[]{this.tile});
        this.actionsPane.populate((Collection)ClientRegistry.get().allOf(WorkspaceManagerAction.TYPE).values().stream().filter(action -> action.isAvailable((Object)this)).collect(Collectors.toList()));
        this.acquiredListener = obj -> this.actionsPane.revalidate();
        this.mutex.acquiredProperty().addListener(this.acquiredListener);
        this.composePane((Node)space, null, this.actionsPane, null);
    }

    public void dispose() {
        this.mutex.acquiredProperty().removeListener(this.acquiredListener);
        super.dispose();
    }

    public ObservableMutex getMutex() {
        return this.mutex;
    }

    public WorkspaceEditorPane getEditor() {
        return (WorkspaceEditorPane)this.tile.getFullNode();
    }

    public void handleShortcut(KeyEvent event) {
        if (this.mutex.isAcquired()) {
            return;
        }
        this.actionsPane.handleShortcut(event);
    }

    void revalidate() {
        this.actionsPane.revalidate();
        this.tile.revalidateActions();
    }

    void setCaption(String caption) {
        this.tile.setCaption(caption);
    }

    boolean isDataChanged() {
        return this.getEditor().isDataChanged();
    }
}

