/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common;

import com.gridnine.xtrip.common.Disposable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Environment {
    static final Logger log = LoggerFactory.getLogger(Environment.class);
    private static final String instanceId = UUID.randomUUID().toString();
    private static String applicationId;
    private static String gitRevision;
    private static File configurationFolder;
    private static File dataFolder;
    private static File tempFolder;
    private static File rootFolder;
    private static final ConcurrentMap<Class<?>, Object> publishedObjects;
    private static final ConcurrentLinkedQueue<Class<?>> queue;
    private static final ConcurrentMap<Class<?>, Object> publishMonitors;
    private static volatile boolean test;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withPublishMonitor(Class<?> cls, Consumer<Object> f) {
        Object monitor;
        Object object = monitor = publishMonitors.computeIfAbsent(cls, c -> new Object());
        synchronized (object) {
            f.accept(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withPublishMonitor(Class<?> cls, Function<Object, T> f) {
        Object monitor;
        Object object = monitor = publishMonitors.computeIfAbsent(cls, c -> new Object());
        synchronized (object) {
            return f.apply(monitor);
        }
    }

    public static void configure(String appId, File aRootFolder, File configFolder, File aDataFolder, File aTempFolder) {
        if (applicationId != null) {
            throw new IllegalStateException("environment already configured");
        }
        if (appId == null) {
            throw new IllegalArgumentException("application ID");
        }
        applicationId = appId;
        if (!test) {
            try (InputStream is = Environment.class.getClassLoader().getResourceAsStream("git.properties");){
                Properties gitProperties = new Properties();
                gitProperties.load(is);
                gitRevision = gitProperties.getProperty("git.revision", "-");
            }
            catch (IOException | NullPointerException ex) {
                gitRevision = "-";
            }
        }
        rootFolder = aRootFolder;
        configurationFolder = configFolder;
        dataFolder = aDataFolder;
        tempFolder = aTempFolder;
        log.debug("application ID is " + applicationId);
        log.debug("instance ID is " + instanceId);
        log.debug("root folder is " + rootFolder);
        log.debug("configuration folder is " + configurationFolder);
        log.debug("data folder is " + dataFolder);
        log.debug("TEMP folder is " + tempFolder);
        log.info("configured");
    }

    public static void dispose() {
        ArrayList list = null;
        list = new ArrayList(queue);
        Collections.reverse(list);
        for (Class<?> cls : list) {
            log.info("dispose " + cls);
            Environment.unpublish(cls);
        }
        if (!publishedObjects.isEmpty()) {
            log.warn("not all objects were unpublished");
            publishedObjects.clear();
        }
        applicationId = null;
    }

    public static <T> void publish(T obj) {
        Class<?> key = obj.getClass();
        Environment.withPublishMonitor(key, (Object monitor) -> {
            if (publishedObjects.putIfAbsent(key, obj) != null) {
                throw new IllegalArgumentException(String.format("object of class %s already published", obj.getClass().getName()));
            }
            queue.add(key);
            log.info("published " + obj);
            monitor.notifyAll();
        });
    }

    public static <T> void publish(Class<? super T> cls, T obj) {
        Environment.withPublishMonitor(cls, (Object monitor) -> {
            if (publishedObjects.putIfAbsent(cls, obj) != null) {
                throw new IllegalArgumentException(String.format("object of class %s already published", cls.getName()));
            }
            queue.add(cls);
            log.info(String.format("published %s, class = %s", obj, cls.getName()));
            monitor.notifyAll();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void publishOrReplace(T obj) {
        ConcurrentMap<Class<?>, Object> concurrentMap = publishedObjects;
        synchronized (concurrentMap) {
            Class<?> key = obj.getClass();
            if (Environment.isPublished(key)) {
                publishedObjects.put(key, obj);
                log.info("replaced " + obj);
            } else {
                Environment.publish(obj);
            }
        }
    }

    public static void unpublish(Class<?> cls) {
        Object object = publishedObjects.get(cls);
        if (object != null) {
            if (object instanceof Disposable) {
                try {
                    ((Disposable)object).dispose();
                }
                catch (Throwable t) {
                    log.error("failed disposing " + object, t);
                }
            } else if (object instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)object).close();
                }
                catch (Throwable t) {
                    log.error("failed closing " + object, t);
                }
            }
            publishedObjects.remove(cls);
            queue.remove(cls);
        }
    }

    public static boolean isPublished(Class<?> cls) {
        return publishedObjects.containsKey(cls);
    }

    public static <T> T getPublished(Class<T> cls) {
        Object result = publishedObjects.get(cls);
        if (result == null) {
            throw new IllegalArgumentException(String.format("object of class %s not published", cls.getName()));
        }
        return (T)result;
    }

    public static <T> T getPublishedWithWait(Class<T> cls) {
        return (T)Environment.withPublishMonitor(cls, (Object monitor) -> {
            while (!publishedObjects.containsKey(cls)) {
                try {
                    log.warn("waiting for {} to be published", (Object)cls.getName());
                    monitor.wait();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            Object result = publishedObjects.get(cls);
            if (result == null) {
                throw new IllegalArgumentException(String.format("object of class %s not published", cls.getName()));
            }
            log.info("got published {} after waiting", (Object)cls.getName());
            return result;
        });
    }

    public static Map<Class<?>, Object> getPublishedObjects() {
        return Collections.unmodifiableMap(publishedObjects);
    }

    public static String getInstanceId() {
        return instanceId;
    }

    public static String getApplicationId() {
        return applicationId;
    }

    public static String getGitRevision() {
        return gitRevision;
    }

    public static File getConfigurationFolder() {
        return configurationFolder;
    }

    public static File getDataFolder() {
        return dataFolder;
    }

    public static File getTempFolder() {
        return tempFolder;
    }

    public static File getRootFolder() {
        return rootFolder;
    }

    public static void initTest() {
        test = true;
    }

    public static boolean isTest() {
        return TestHolder.TEST;
    }

    private Environment() {
    }

    static /* synthetic */ boolean access$000() {
        return test;
    }

    static {
        publishedObjects = new ConcurrentHashMap();
        queue = new ConcurrentLinkedQueue();
        publishMonitors = new ConcurrentHashMap();
    }

    private static class TestHolder {
        public static final boolean TEST = Environment.access$000();

        private TestHolder() {
        }
    }
}

