/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.format.object;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.format.object.FormatObject;
import com.gridnine.xtrip.common.format.object.FormatObjectBinder;
import com.gridnine.xtrip.common.format.object.FormatObjectProperty;
import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxyBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FormatObjectsRegistry {
    private Lock lock = new Lock(){

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            return null;
        }
    };
    private final Map<String, FormatObject> objects = new HashMap<String, FormatObject>();
    private final Map<String, FormatObjectProperty> properties = new HashMap<String, FormatObjectProperty>();
    private final Map<String, Set<String>> object2properties = new HashMap<String, Set<String>>();
    private final Map<String, FormatObjectBinder> binders = new HashMap<String, FormatObjectBinder>();
    private final Map<String, Set<String>> object2binders = new HashMap<String, Set<String>>();
    private final Map<String, FormatObjectPropertyHandler> handlers = new HashMap<String, FormatObjectPropertyHandler>();
    private final Map<String, String> property2handler = new HashMap<String, String>();
    private final Map<String, FormatObjectProxyBuilder> proxyBuilders = new HashMap<String, FormatObjectProxyBuilder>();
    private final Map<String, String> object2proxyBuilder = new HashMap<String, String>();

    public static FormatObjectsRegistry get() {
        return Environment.getPublished(FormatObjectsRegistry.class);
    }

    public Collection<FormatObject> getObjects() {
        this.lock.lock();
        try {
            Collection<FormatObject> collection = Collections.unmodifiableCollection(this.objects.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FormatObject getObject(String objectId) {
        if (objectId == null) {
            return null;
        }
        this.lock.lock();
        try {
            FormatObject formatObject = this.objects.get(objectId);
            return formatObject;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getObjectProperties(String objectId) {
        if (objectId == null) {
            return Collections.emptySet();
        }
        this.lock.lock();
        try {
            Set<String> propertyIds = this.object2properties.get(objectId);
            if (propertyIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(propertyIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getObjectBinders(String objectId) {
        if (objectId == null) {
            return Collections.emptySet();
        }
        this.lock.lock();
        try {
            Set<String> binderIds = this.object2binders.get(objectId);
            if (binderIds == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(binderIds);
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getObjectProxyBuilder(String objectId) {
        if (objectId == null) {
            return null;
        }
        this.lock.lock();
        try {
            String string = this.object2proxyBuilder.get(objectId);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addObject(FormatObject object) {
        if (object == null || object.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.objects.get(object.getId()) != null) {
                throw new IllegalArgumentException(String.format("object with id %s already added", object.getId()));
            }
            this.objects.put(object.getId(), object);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeObject(FormatObject object) {
        if (object == null || object.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.objects.remove(object.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<FormatObjectProperty> getProperties() {
        this.lock.lock();
        try {
            Collection<FormatObjectProperty> collection = Collections.unmodifiableCollection(this.properties.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FormatObjectProperty getProperty(String propertyId) {
        if (propertyId == null) {
            return null;
        }
        this.lock.lock();
        try {
            FormatObjectProperty formatObjectProperty = this.properties.get(propertyId);
            return formatObjectProperty;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getPropertyHandler(String propertyId) {
        if (propertyId == null) {
            return null;
        }
        this.lock.lock();
        try {
            String string = this.property2handler.get(propertyId);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addProperty(FormatObjectProperty property) {
        if (property == null || property.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.properties.get(property.getId()) != null) {
                throw new IllegalArgumentException(String.format("property with id %s already added", property.getId()));
            }
            this.properties.put(property.getId(), property);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeProperty(FormatObjectProperty property) {
        if (property == null || property.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.properties.remove(property.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<FormatObjectBinder> getBinders() {
        this.lock.lock();
        try {
            Collection<FormatObjectBinder> collection = Collections.unmodifiableCollection(this.binders.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FormatObjectBinder getBinder(String binderId) {
        if (binderId == null) {
            return null;
        }
        this.lock.lock();
        try {
            FormatObjectBinder formatObjectBinder = this.binders.get(binderId);
            return formatObjectBinder;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addBinder(FormatObjectBinder binder) {
        if (binder == null || binder.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.binders.get(binder.getId()) != null) {
                throw new IllegalArgumentException(String.format("binder with id %s already added", binder.getId()));
            }
            this.binders.put(binder.getId(), binder);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeBinder(FormatObjectBinder binder) {
        if (binder == null || binder.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.binders.remove(binder.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<FormatObjectPropertyHandler> getHandlers() {
        this.lock.lock();
        try {
            Collection<FormatObjectPropertyHandler> collection = Collections.unmodifiableCollection(this.handlers.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FormatObjectPropertyHandler getHandler(String handlerId) {
        if (handlerId == null) {
            return null;
        }
        this.lock.lock();
        try {
            FormatObjectPropertyHandler formatObjectPropertyHandler = this.handlers.get(handlerId);
            return formatObjectPropertyHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addHandler(FormatObjectPropertyHandler handler) {
        if (handler == null || handler.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.handlers.get(handler.getId()) != null) {
                throw new IllegalArgumentException(String.format("handler with id %s already added", handler.getId()));
            }
            this.handlers.put(handler.getId(), handler);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeHandler(FormatObjectPropertyHandler handler) {
        if (handler == null || handler.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.handlers.remove(handler.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<FormatObjectProxyBuilder> getProxyBuilders() {
        this.lock.lock();
        try {
            Collection<FormatObjectProxyBuilder> collection = Collections.unmodifiableCollection(this.proxyBuilders.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FormatObjectProxyBuilder getProxyBuilder(String proxyBuilderId) {
        if (proxyBuilderId == null) {
            return null;
        }
        this.lock.lock();
        try {
            FormatObjectProxyBuilder formatObjectProxyBuilder = this.proxyBuilders.get(proxyBuilderId);
            return formatObjectProxyBuilder;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addProxyBuilder(FormatObjectProxyBuilder proxyBuilder) {
        if (proxyBuilder == null || proxyBuilder.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.proxyBuilders.get(proxyBuilder.getId()) != null) {
                throw new IllegalArgumentException(String.format("proxy builder with id %s already added", proxyBuilder.getId()));
            }
            this.proxyBuilders.put(proxyBuilder.getId(), proxyBuilder);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeProxyBuilder(FormatObjectProxyBuilder proxyBuilder) {
        if (proxyBuilder == null || proxyBuilder.getId() == null) {
            return;
        }
        this.lock.lock();
        try {
            this.proxyBuilders.remove(proxyBuilder.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void register() {
        this.object2properties.clear();
        this.object2binders.clear();
        this.object2proxyBuilder.clear();
        for (FormatObjectProperty property : this.properties.values()) {
            this.registerProperty(property.getObjectId(), property.getId());
        }
        for (FormatObjectBinder binder : this.binders.values()) {
            this.registerBinder(binder.getObjectId(), binder.getId());
        }
        for (FormatObjectPropertyHandler handler : this.handlers.values()) {
            this.registerHandler(handler.getPropertyId(), handler.getId());
        }
        for (FormatObjectProxyBuilder proxyBuilder : this.proxyBuilders.values()) {
            this.registerProxyBuilder(proxyBuilder.getObjectId(), proxyBuilder.getId());
        }
        this.lock = new ReentrantLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProperty(String objectId, String propertyId) {
        if (objectId == null || propertyId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> propertyIds = this.object2properties.get(objectId);
            if (propertyIds == null) {
                propertyIds = new HashSet<String>();
                this.object2properties.put(objectId, propertyIds);
            }
            propertyIds.add(propertyId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBinder(String objectId, String binderId) {
        if (objectId == null || binderId == null) {
            return;
        }
        this.lock.lock();
        try {
            Set<String> binderIds = this.object2binders.get(objectId);
            if (binderIds == null) {
                binderIds = new HashSet<String>();
                this.object2binders.put(objectId, binderIds);
            }
            binderIds.add(binderId);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void registerHandler(String propertyId, String handlerId) {
        if (propertyId == null || handlerId == null) {
            return;
        }
        this.lock.lock();
        try {
            this.property2handler.put(propertyId, handlerId);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void registerProxyBuilder(String objectId, String proxyBuilderId) {
        if (objectId == null || proxyBuilderId == null) {
            return;
        }
        this.lock.lock();
        try {
            this.object2proxyBuilder.put(objectId, proxyBuilderId);
        }
        finally {
            this.lock.unlock();
        }
    }
}

