/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.model;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.BaseProperty;
import com.gridnine.xtrip.common.meta.BaseReferenceProperty;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.HistoricalValueSHelper;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.PeriodicalPropertyHelper;
import com.gridnine.xtrip.common.model.PeriodicalPropertySHelper;
import com.gridnine.xtrip.common.model.PeriodicalValue;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.w3c.dom.Element;

final class PropertyGenerator {
    static <P extends BaseProperty> void generateAccessors(JavaWriter writer, P prop, BaseType bt, GenerationContext ctx) throws Exception {
        Property property;
        String type = ModelCodeGenHelper.getType(prop, ctx);
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        if (prop.isLocalizable()) {
            if (!"text".equals(type) && !"String".equals(type)) {
                throw new Exception(String.format("%s in %s can not be localizable", prop.getId(), bt.getId()));
            }
            if (prop instanceof BaseReferenceProperty && ((BaseReferenceProperty)prop).isHistorical()) {
                PropertyGenerator.generateLocalizableHistoricalStringAccessor(writer, (BaseReferenceProperty)prop, ctx);
            } else {
                PropertyGenerator.generateLocalizableStringAccessor(writer, prop, ctx);
            }
            return;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                if (!("text".equals(type) || "String".equals(type) || "boolean".equals(type) || "Boolean".equals(type) || "double".equals(type) || "Double".equals(type) || BigDecimal.class.getName().equals(type) || Date.class.getName().equals(type) || ctx.getMetaRegistry().getDictionaries().containsKey(prop.getType()) || ctx.getMetaRegistry().getEntities().containsKey(prop.getType()))) {
                    throw new Exception(String.format("%s in %s can not be historical", prop.getId(), bt.getId()));
                }
                PropertyGenerator.generateHistoricalPropertyAccessor(writer, brp, ctx);
                return;
            }
            if (brp.isPeriodical()) {
                if (!("text".equals(type) || "String".equals(type) || ctx.getMetaRegistry().getDictionaries().containsKey(prop.getType()) || ctx.getMetaRegistry().getEntities().containsKey(prop.getType()))) {
                    throw new Exception(String.format("%s in %s can not be periodical", prop.getId(), bt.getId()));
                }
                PropertyGenerator.generatePeriodicalPropertyAccessor(writer, brp, ctx);
                return;
            }
        }
        Boolean defaultValue = Boolean.FALSE;
        if (prop instanceof Property && (property = (Property)prop).getDefaultBooleanValue() != null) {
            defaultValue = property.getDefaultBooleanValue();
        }
        if (Boolean.TRUE.equals(defaultValue)) {
            writer.code("private %s %s = true;", type, prop.getId());
        } else {
            writer.code("private %s %s;", type, prop.getId());
        }
        writer.blank();
        if (prop instanceof Property && ((Property)prop).isPrivateField()) {
            return;
        }
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        if ("boolean".equals(prop.getType())) {
            writer.beginBlock("public %s is%s()", type, GenUtil.capitalize(prop.getId()));
        } else {
            writer.beginBlock("public %s get%s()", type, GenUtil.capitalize(prop.getId()));
        }
        if (prop.isFinalProperty()) {
            writer.beginBlock("if(%s == null)", prop.getId());
            writer.code("%s = new %s();", prop.getId(), prop.getType());
            writer.endBlock();
        }
        writer.code("return %s;", prop.getId());
        writer.endBlock();
        if (prop.isFinalProperty()) {
            return;
        }
        if (prop instanceof Property && ((Property)prop).isReadonly()) {
            return;
        }
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public void set%s(final %s value)", GenUtil.capitalize(prop.getId()), type);
        writer.code("this.%s = value;", prop.getId());
        writer.endBlock();
    }

    private static <P extends BaseReferenceProperty> void generateHistoricalPropertyAccessor(JavaWriter writer, P prop, GenerationContext ctx) throws Exception {
        String type = ModelCodeGenHelper.getType(prop, ctx);
        if ("boolean".equals(type)) {
            type = "Boolean";
        }
        if ("double".equals(type)) {
            type = "Double";
        }
        writer.code("private final %s<%s<%s>> %s = new %s<%2$s<%3$s>>();", List.class.getName(), HistoricalValue.class.getName(), type, prop.getId(), ArrayList.class.getName());
        writer.blank();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        if ("boolean".equals(prop.getType()) || "Boolean".equals(prop.getType())) {
            writer.beginBlock("public %s is%s()", type, GenUtil.capitalize(prop.getId()));
        } else {
            writer.beginBlock("public %s get%s()", type, GenUtil.capitalize(prop.getId()));
        }
        writer.code("return %s.getValue(%s);", HistoricalValueHelper.class.getName(), prop.getId());
        writer.endBlock();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public void set%s(final %s value)", GenUtil.capitalize(prop.getId()), type);
        writer.code("%s.setValue(this.%s, value);", HistoricalValueHelper.class.getName(), prop.getId());
        writer.endBlock();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public %s<%s<%s>> get%sHistory()", List.class.getName(), HistoricalValue.class.getName(), type, GenUtil.capitalize(prop.getId()));
        writer.code("return %s;", prop.getId());
        writer.endBlock();
    }

    private static <P extends BaseReferenceProperty> void generatePeriodicalPropertyAccessor(JavaWriter writer, P prop, GenerationContext ctx) throws Exception {
        String type = ModelCodeGenHelper.getType(prop, ctx);
        writer.code("private final %s<%s<%s>> %s = new %s<%2$s<%3$s>>();", List.class.getName(), PeriodicalValue.class.getName(), type, prop.getId(), ArrayList.class.getName());
        writer.blank();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public %s get%s()", type, GenUtil.capitalize(prop.getId()));
        writer.code("return %s.getValue(%s);", PeriodicalPropertyHelper.class.getName(), prop.getId());
        writer.endBlock();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public void set%s(final %s value)", GenUtil.capitalize(prop.getId()), type);
        writer.code("%s.setValue(this.%s, value);", PeriodicalPropertyHelper.class.getName(), prop.getId());
        writer.endBlock();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public %s<%s<%s>> get%sList()", List.class.getName(), PeriodicalValue.class.getName(), type, GenUtil.capitalize(prop.getId()));
        writer.code("return %s;", prop.getId());
        writer.endBlock();
    }

    private static <P extends BaseProperty> void generateLocalizableStringAccessor(JavaWriter writer, P prop, GenerationContext ctx) throws Exception {
        writer.code("private %s %s = new %1$s();", L10nString.class.getName(), prop.getId());
        writer.blank();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public %s get%s()", L10nString.class.getName(), GenUtil.capitalize(prop.getId()));
        writer.code("return %s;", prop.getId());
        writer.endBlock();
    }

    private static <P extends BaseProperty> void generateLocalizableHistoricalStringAccessor(JavaWriter writer, P prop, GenerationContext ctx) throws Exception {
        String type = L10nString.class.getName();
        writer.code("private final %s<%s<%s>> %s = new %s<%2$s<%3$s>>();", List.class.getName(), HistoricalValue.class.getName(), type, prop.getId(), ArrayList.class.getName());
        writer.blank();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public %s get%s()", type, GenUtil.capitalize(prop.getId()));
        writer.code("return %s.getValue(%s);", HistoricalValueHelper.class.getName(), prop.getId());
        writer.endBlock();
        if (prop.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public %s<%s<%s>> get%sHistory()", List.class.getName(), HistoricalValue.class.getName(), type, GenUtil.capitalize(prop.getId()));
        writer.code("return %s;", prop.getId());
        writer.endBlock();
    }

    static void generateIndexAccessors(JavaWriter writer, IndexProperty prop, BaseType bt, GenerationContext ctx) throws Exception {
        String type = PropertyGenerator.getIndexType(prop, ctx);
        if (prop.isLocalizable()) {
            if (!"text".equals(type) && !"String".equals(type)) {
                throw new Exception(String.format("%s in %s can not be localizable", prop.getId(), bt.getId()));
            }
            PropertyGenerator.generateLocalizableStringAccessor(writer, prop, ctx);
            return;
        }
        writer.code("private %s %s;", type, prop.getId());
        writer.blank();
        if ("boolean".equals(prop.getType())) {
            writer.beginBlock("public %s is%s()", type, GenUtil.capitalize(prop.getId()));
        } else {
            writer.beginBlock("public %s get%s()", type, GenUtil.capitalize(prop.getId()));
        }
        writer.code("return %s;", prop.getId());
        writer.endBlock();
        writer.beginBlock("public void set%s(final %s value)", GenUtil.capitalize(prop.getId()), type);
        writer.code("this.%s = value;", prop.getId());
        writer.endBlock();
    }

    static void generateInstumentedIndexAccessors(JavaWriter writer, IndexProperty prop, BaseType bt, GenerationContext ctx) throws Exception {
        String type = PropertyGenerator.getIndexType(prop, ctx);
        writer.code("@Override", new Object[0]);
        if ("boolean".equals(prop.getType())) {
            writer.beginBlock("public %s is%s()", type, GenUtil.capitalize(prop.getId()));
            writer.code("%s.get().statRetrieving(\"%s\",\"%s\" );", IndexUsageHandler.class.getName(), bt.getId(), prop.getId());
            writer.code("return super.is%s();", GenUtil.capitalize(prop.getId()));
        } else {
            if (prop.isLocalizable()) {
                type = L10nString.class.getName();
            }
            writer.beginBlock("public %s get%s()", type, GenUtil.capitalize(prop.getId()));
            writer.code("%s.get().statRetrieving(\"%s\",\"%s\" );", IndexUsageHandler.class.getName(), bt.getId(), prop.getId());
            writer.code("return super.get%s();", GenUtil.capitalize(prop.getId()));
        }
        writer.endBlock();
    }

    static <P extends BaseProperty> void generateFromXML(JavaWriter writer, P prop, BaseType bt, GenerationContext ctx) throws Exception {
        writer.comment("PROPERTY %s", prop.getId());
        if (ctx.getMetaRegistry().getEnumRefs().containsKey(prop.getType()) || ctx.getMetaRegistry().getEnums().containsKey(prop.getType())) {
            Set<String> enumItemRenamers = null;
            enumItemRenamers = ctx.getMetaRegistry().getEnumRefs().containsKey(prop.getType()) ? ctx.getMetaRegistry().getEnumRefs().get(prop.getType()).getEnumItemRenamers() : ctx.getMetaRegistry().getEnums().get(prop.getType()).getEnumItemRenamers();
            ModelCodeGenHelper.generateEnumItemRenamerCode(writer, enumItemRenamers, prop.getId(), "elm");
            writer.code("%s = %s.readEnum(elm, \"%1$s\", %s.class);", prop.getId(), XHelper.class.getName(), prop.getType());
        } else if (!PropertyGenerator.entityFromXML(writer, prop, ctx) && !PropertyGenerator.dictionaryFromXML(writer, prop, ctx)) {
            if (prop.isLocalizable()) {
                if (prop instanceof BaseReferenceProperty && ((BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.readHistoricalLocalizableProperty(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                } else {
                    writer.beginBlock();
                    writer.comment("Check if this property had historical values before, but now marked as non-historical (then take the last historical value)", new Object[0]);
                    writer.code("java.util.List<%s<%s>> tempValues = new java.util.ArrayList<>();", HistoricalValue.class.getName(), L10nString.class.getName());
                    writer.code("%s.readHistoricalLocalizableProperty(elm, \"%s\", tempValues);", HistoricalValueHelper.class.getName(), prop.getId());
                    writer.beginBlock("if (%s.getValue(tempValues) != null)", HistoricalValueHelper.class.getName());
                    writer.code("%s = %s.getValue(tempValues);", prop.getId(), HistoricalValueHelper.class.getName());
                    writer.restartBlock("else", new Object[0]);
                    writer.code("%s = %s.readLocalizationString(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
                    writer.endBlock();
                    writer.endBlock();
                }
            } else if ("String".equals(prop.getType()) || "text".equals(prop.getType())) {
                if (prop instanceof BaseReferenceProperty) {
                    BaseReferenceProperty brp = (BaseReferenceProperty)prop;
                    if (brp.isHistorical()) {
                        writer.code("%s.readHistoricalString(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                        return;
                    }
                    if (brp.isPeriodical()) {
                        writer.code("%s.readPeriodicalString(elm, \"%s\", %2$s);", PeriodicalPropertyHelper.class.getName(), prop.getId());
                        return;
                    }
                }
                writer.code("%s = %s.readString(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("boolean".equals(prop.getType())) {
                Property property;
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.readHistoricalBoolean(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                Boolean defaultValue = Boolean.FALSE;
                if (prop instanceof Property && (property = (Property)prop).getDefaultBooleanValue() != null) {
                    defaultValue = property.getDefaultBooleanValue();
                }
                writer.code("%s = %s.readBoolean(elm, \"%1$s\", %s);", prop.getId(), XHelper.class.getName(), defaultValue);
            } else if ("Boolean".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.readHistoricalBoolean(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s = %s.readBoolean(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("byte".equals(prop.getType())) {
                writer.code("%s = %s.readByte(elm, \"%1$s\", (byte) 0);", prop.getId(), XHelper.class.getName());
            } else if ("Byte".equals(prop.getType())) {
                writer.code("%s = %s.readByte(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("char".equals(prop.getType())) {
                writer.code("%s = %s.readChar(elm, \"%1$s\", '\\u0000');", prop.getId(), XHelper.class.getName());
            } else if ("Character".equals(prop.getType())) {
                writer.code("%s = %s.readChar(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("short".equals(prop.getType())) {
                writer.code("%s = %s.readShort(elm, \"%1$s\", (short) 0);", prop.getId(), XHelper.class.getName());
            } else if ("Short".equals(prop.getType())) {
                writer.code("%s = %s.readShort(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("int".equals(prop.getType())) {
                writer.code("%s = %s.readInt(elm, \"%1$s\", 0);", prop.getId(), XHelper.class.getName());
            } else if ("Integer".equals(prop.getType())) {
                writer.code("%s = %s.readInt(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("long".equals(prop.getType())) {
                writer.code("%s = %s.readLong(elm, \"%1$s\", 0L);", prop.getId(), XHelper.class.getName());
            } else if ("Long".equals(prop.getType())) {
                writer.code("%s = %s.readLong(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("float".equals(prop.getType())) {
                writer.code("%s = %s.readFloat(elm, \"%1$s\", 0.0F);", prop.getId(), XHelper.class.getName());
            } else if ("Float".equals(prop.getType())) {
                writer.code("%s = %s.readFloat(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("double".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.readHistoricalDouble(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s = %s.readDouble(elm, \"%1$s\", 0.0);", prop.getId(), XHelper.class.getName());
            } else if ("Double".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.readHistoricalDouble(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s = %s.readDouble(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (BigDecimal.class.getName().equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.readHistoricalBigDecimal(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s = %s.readBigDecimal(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (BigInteger.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readBigInteger(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (Date.class.getName().equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.readHistoricalDate(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s = %s.readDate(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (org.joda.time.LocalDate.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJodaLocalDate(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (LocalTime.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJodaLocalTime(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (org.joda.time.LocalDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJodaLocalDateTime(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (DateTime.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJodaDateTime(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (LocalDate.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJavaLocalDate(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (java.time.LocalTime.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJavaLocalTime(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (LocalDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJavaLocalDateTime(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (OffsetDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJavaOffsetDateTime(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (Instant.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJavaInstant(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (DayOfWeek.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readJavaDayOfWeek(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (Locale.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readLocale(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (URL.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readURL(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (URI.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readURI(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (UUID.class.getName().equals(prop.getType())) {
                writer.code("%s = %s.readUUID(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("byte[]".equals(prop.getType()) || "compressed".equals(prop.getType())) {
                writer.code("%s = %s.readBytes(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if ("Object".equals(prop.getType()) || "java.lang.Object".equals(prop.getType())) {
                writer.code("%s = %s.readObject(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else if (PropertyGenerator.isXSerializable(prop.getType())) {
                writer.code("%s = %s.readObject(elm, \"%1$s\");", prop.getId(), XHelper.class.getName());
            } else {
                throw new Exception(String.format("fromXML(): unsupported type %s of property %s in entity %s", prop.getType(), prop.getId(), bt.getId()));
            }
        }
    }

    private static boolean isXSerializable(String type) throws ClassNotFoundException {
        Class<?> cls = Class.forName(type);
        return XSerializable.class.isAssignableFrom(cls);
    }

    private static boolean isXSSerializable(String type) throws ClassNotFoundException {
        Class<?> cls = Class.forName(type);
        return XSSerializable.class.isAssignableFrom(cls);
    }

    private static boolean isXCloneable(String type) throws ClassNotFoundException {
        Class<?> cls = Class.forName(type);
        return XCloneable.class.isAssignableFrom(cls);
    }

    static <P extends BaseProperty> void generateWriteXMLElements(JavaWriter writer, P prop, BaseType bt, GenerationContext ctx) throws Exception {
        writer.comment("PROPERTY %s", prop.getId());
        if (ctx.getMetaRegistry().getEnums().containsKey(prop.getType()) || ctx.getMetaRegistry().getEnumRefs().containsKey(prop.getType())) {
            writer.code("%s.writeEnum(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
        } else if (!PropertyGenerator.entityWriteXMLElements(writer, prop, ctx) && !PropertyGenerator.dictionaryWriteXMLElements(writer, prop, ctx)) {
            if (prop.isLocalizable()) {
                if (prop instanceof BaseReferenceProperty && ((BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalLocalizableProperty(writer, \"%s\", %2$s);", HistoricalValueSHelper.class.getName(), prop.getId());
                } else {
                    writer.code("%s.writeLocalizationString(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
                }
            } else if ("String".equals(prop.getType())) {
                if (prop instanceof BaseReferenceProperty) {
                    BaseReferenceProperty brp = (BaseReferenceProperty)prop;
                    if (brp.isHistorical()) {
                        writer.code("%s.writeHistoricalString(writer, \"%s\", %2$s, false);", HistoricalValueSHelper.class.getName(), prop.getId());
                        return;
                    }
                    if (brp.isPeriodical()) {
                        writer.code("%s.writePeriodicalString(writer, \"%s\", %2$s, false);", PeriodicalPropertySHelper.class.getName(), prop.getId());
                        return;
                    }
                }
                writer.code("%s.writeString(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("text".equals(prop.getType())) {
                if (prop instanceof BaseReferenceProperty) {
                    BaseReferenceProperty brp = (BaseReferenceProperty)prop;
                    if (brp.isHistorical()) {
                        writer.code("%s.writeHistoricalString(writer, \"%s\", %2$s, true);", HistoricalValueSHelper.class.getName(), prop.getId());
                        return;
                    }
                    if (brp.isPeriodical()) {
                        writer.code("%s.writePeriodicalString(writer, \"%s\", %2$s, true);", PeriodicalPropertySHelper.class.getName(), prop.getId());
                        return;
                    }
                }
                writer.code("%s.writeString(writer, \"%s\", %2$s, true);", XSHelper.class.getName(), prop.getId());
            } else if ("boolean".equals(prop.getType()) || "Boolean".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalBoolean(writer, \"%s\", %2$s, false);", HistoricalValueSHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s.writeBoolean(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("byte".equals(prop.getType()) || "Byte".equals(prop.getType())) {
                writer.code("%s.writeByte(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("char".equals(prop.getType()) || "Character".equals(prop.getType())) {
                writer.code("%s.writeChar(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("short".equals(prop.getType()) || "Short".equals(prop.getType())) {
                writer.code("%s.writeShort(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("int".equals(prop.getType()) || "Integer".equals(prop.getType())) {
                writer.code("%s.writeInt(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("long".equals(prop.getType()) || "Long".equals(prop.getType())) {
                writer.code("%s.writeLong(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("float".equals(prop.getType()) || "Float".equals(prop.getType())) {
                writer.code("%s.writeFloat(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("double".equals(prop.getType()) || "Double".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalDouble(writer, \"%s\", %2$s, false);", HistoricalValueSHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s.writeDouble(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (BigDecimal.class.getName().equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalBigDecimal(writer, \"%s\", %2$s, false);", HistoricalValueSHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s.writeBigDecimal(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (BigInteger.class.getName().equals(prop.getType())) {
                writer.code("%s.writeBigInteger(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (Date.class.getName().equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalDate(writer, \"%s\", %2$s, false);", HistoricalValueSHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s.writeDate(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (org.joda.time.LocalDate.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJodaLocalDate(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (LocalTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJodaLocalTime(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (org.joda.time.LocalDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJodaLocalDateTime(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (DateTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJodaDateTime(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (LocalDate.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaLocalDate(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (java.time.LocalTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaLocalTime(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (LocalDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaLocalDateTime(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (OffsetDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaOffsetDateTime(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (Instant.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaInstant(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (DayOfWeek.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaDayOfWeek(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (Locale.class.getName().equals(prop.getType())) {
                writer.code("%s.writeLocale(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (URL.class.getName().equals(prop.getType())) {
                writer.code("%s.writeURL(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (URI.class.getName().equals(prop.getType())) {
                writer.code("%s.writeURI(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (UUID.class.getName().equals(prop.getType())) {
                writer.code("%s.writeUUID(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if ("byte[]".equals(prop.getType())) {
                writer.code("%s.writeBytes(writer, \"%s\", %2$s, \"base64\");", XSHelper.class.getName(), prop.getId());
            } else if ("compressed".equals(prop.getType())) {
                writer.code("%s.writeBytes(writer, \"%s\", %2$s, \"base64compressed\");", XSHelper.class.getName(), prop.getId());
            } else if ("Object".equals(prop.getType()) || "java.lang.Object".equals(prop.getType())) {
                writer.code("%s.writeObject(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else if (PropertyGenerator.isXSSerializable(prop.getType())) {
                writer.code("%s.writeObject(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
            } else {
                throw new Exception(String.format("writeXMLElements(): unsupported type %s of property %s in entity %s", prop.getType(), prop.getId(), bt.getId()));
            }
        }
    }

    private static <P extends BaseProperty> void generateCopyFromImmutable(JavaWriter writer, P prop) throws Exception {
        writer.code("this.%s = source.%1$s;", prop.getId());
    }

    private static <P extends BaseProperty> void generateCopyFromCloneObject(JavaWriter writer, P prop) throws Exception {
        writer.code("this.%s = %s.cloneObject(source.%1$s, newUids, uids);", prop.getId(), XCloneHelper.class.getName());
    }

    private static <P extends BaseProperty> void generateCopyFromCloneCollection(JavaWriter writer, P prop) throws Exception {
        writer.code("this.%s.clear(); this.%1$s.addAll(%s.cloneCollection(source.%1$s, newUids, uids));", prop.getId(), XCloneHelper.class.getName());
    }

    static <P extends BaseProperty> void generateCopyFrom(JavaWriter writer, P prop, BaseType bt, GenerationContext ctx) throws Exception {
        writer.comment("PROPERTY %s", prop.getId());
        if (ctx.getMetaRegistry().getEnums().containsKey(prop.getType()) || ctx.getMetaRegistry().getEnumRefs().containsKey(prop.getType())) {
            PropertyGenerator.generateCopyFromImmutable(writer, prop);
        } else if (!PropertyGenerator.entityCopyFrom(writer, prop, ctx) && !PropertyGenerator.dictionaryCopyFrom(writer, prop, ctx)) {
            if (prop.isLocalizable()) {
                if (prop instanceof BaseReferenceProperty && ((BaseReferenceProperty)prop).isHistorical()) {
                    PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                } else {
                    PropertyGenerator.generateCopyFromCloneObject(writer, prop);
                }
            } else if ("String".equals(prop.getType())) {
                if (prop instanceof BaseReferenceProperty) {
                    BaseReferenceProperty brp = (BaseReferenceProperty)prop;
                    if (brp.isHistorical()) {
                        PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                        return;
                    }
                    if (brp.isPeriodical()) {
                        PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                        return;
                    }
                }
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("text".equals(prop.getType())) {
                if (prop instanceof BaseReferenceProperty) {
                    BaseReferenceProperty brp = (BaseReferenceProperty)prop;
                    if (brp.isHistorical()) {
                        PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                        return;
                    }
                    if (brp.isPeriodical()) {
                        PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                        return;
                    }
                }
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("boolean".equals(prop.getType()) || "Boolean".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                    return;
                }
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("byte".equals(prop.getType()) || "Byte".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("char".equals(prop.getType()) || "Character".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("short".equals(prop.getType()) || "Short".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("int".equals(prop.getType()) || "Integer".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("long".equals(prop.getType()) || "Long".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("float".equals(prop.getType()) || "Float".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("double".equals(prop.getType()) || "Double".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                    return;
                }
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (BigDecimal.class.getName().equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                    return;
                }
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (BigInteger.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (Date.class.getName().equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                    return;
                }
                PropertyGenerator.generateCopyFromCloneObject(writer, prop);
            } else if (org.joda.time.LocalDate.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (LocalTime.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (org.joda.time.LocalDateTime.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (DateTime.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (LocalDate.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (java.time.LocalTime.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (LocalDateTime.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (OffsetDateTime.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (Locale.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (URL.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (URI.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if (UUID.class.getName().equals(prop.getType())) {
                PropertyGenerator.generateCopyFromImmutable(writer, prop);
            } else if ("byte[]".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromCloneObject(writer, prop);
            } else if ("compressed".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromCloneObject(writer, prop);
            } else if ("Object".equals(prop.getType()) || "java.lang.Object".equals(prop.getType())) {
                PropertyGenerator.generateCopyFromCloneObject(writer, prop);
            } else if (PropertyGenerator.isXCloneable(prop.getType())) {
                PropertyGenerator.generateCopyFromCloneObject(writer, prop);
            } else {
                throw new Exception(String.format("copyFrom(): unsupported type %s of property %s in entity %s", prop.getType(), prop.getId(), bt.getId()));
            }
        }
    }

    static <P extends BaseProperty> void generateToXML(JavaWriter writer, P prop, BaseType bt, GenerationContext ctx) throws Exception {
        writer.comment("PROPERTY %s", prop.getId());
        if (ctx.getMetaRegistry().getEnums().containsKey(prop.getType()) || ctx.getMetaRegistry().getEnumRefs().containsKey(prop.getType())) {
            writer.code("%s.writeEnum(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
        } else if (!PropertyGenerator.entityToXML(writer, prop, ctx) && !PropertyGenerator.dictionaryToXML(writer, prop, ctx)) {
            if (prop.isLocalizable()) {
                if (prop instanceof BaseReferenceProperty && ((BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalLocalizableProperty(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                } else {
                    writer.code("%s.writeLocalizationString(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
                }
            } else if ("String".equals(prop.getType())) {
                if (prop instanceof BaseReferenceProperty) {
                    BaseReferenceProperty brp = (BaseReferenceProperty)prop;
                    if (brp.isHistorical()) {
                        writer.code("%s.writeHistoricalString(elm, \"%s\", %2$s, false);", HistoricalValueHelper.class.getName(), prop.getId());
                        return;
                    }
                    if (brp.isPeriodical()) {
                        writer.code("%s.writePeriodicalString(elm, \"%s\", %2$s, false);", PeriodicalPropertyHelper.class.getName(), prop.getId());
                        return;
                    }
                }
                writer.code("%s.writeString(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("text".equals(prop.getType())) {
                if (prop instanceof BaseReferenceProperty) {
                    BaseReferenceProperty brp = (BaseReferenceProperty)prop;
                    if (brp.isHistorical()) {
                        writer.code("%s.writeHistoricalString(elm, \"%s\", %2$s, true);", HistoricalValueHelper.class.getName(), prop.getId());
                        return;
                    }
                    if (brp.isPeriodical()) {
                        writer.code("%s.writePeriodicalString(elm, \"%s\", %2$s, true);", PeriodicalPropertyHelper.class.getName(), prop.getId());
                        return;
                    }
                }
                writer.code("%s.writeString(elm, \"%s\", %2$s, true);", XHelper.class.getName(), prop.getId());
            } else if ("boolean".equals(prop.getType()) || "Boolean".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalBoolean(elm, \"%s\", %2$s, false);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s.writeBoolean(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("byte".equals(prop.getType()) || "Byte".equals(prop.getType())) {
                writer.code("%s.writeByte(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("char".equals(prop.getType()) || "Character".equals(prop.getType())) {
                writer.code("%s.writeChar(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("short".equals(prop.getType()) || "Short".equals(prop.getType())) {
                writer.code("%s.writeShort(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("int".equals(prop.getType()) || "Integer".equals(prop.getType())) {
                writer.code("%s.writeInt(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("long".equals(prop.getType()) || "Long".equals(prop.getType())) {
                writer.code("%s.writeLong(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("float".equals(prop.getType()) || "Float".equals(prop.getType())) {
                writer.code("%s.writeFloat(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("double".equals(prop.getType()) || "Double".equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalDouble(elm, \"%s\", %2$s, false);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s.writeDouble(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (BigDecimal.class.getName().equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalBigDecimal(elm, \"%s\", %2$s, false);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s.writeBigDecimal(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (BigInteger.class.getName().equals(prop.getType())) {
                writer.code("%s.writeBigInteger(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (Date.class.getName().equals(prop.getType())) {
                BaseReferenceProperty brp;
                if (prop instanceof BaseReferenceProperty && (brp = (BaseReferenceProperty)prop).isHistorical()) {
                    writer.code("%s.writeHistoricalDate(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                    return;
                }
                writer.code("%s.writeDate(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (org.joda.time.LocalDate.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJodaLocalDate(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (LocalTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJodaLocalTime(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (org.joda.time.LocalDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJodaLocalDateTime(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (DateTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJodaDateTime(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (LocalDate.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaLocalDate(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (java.time.LocalTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaLocalTime(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (LocalDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaLocalDateTime(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (OffsetDateTime.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaOffsetDateTime(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (Instant.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaInstant(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (DayOfWeek.class.getName().equals(prop.getType())) {
                writer.code("%s.writeJavaDayOfWeek(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (Locale.class.getName().equals(prop.getType())) {
                writer.code("%s.writeLocale(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (URL.class.getName().equals(prop.getType())) {
                writer.code("%s.writeURL(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (URI.class.getName().equals(prop.getType())) {
                writer.code("%s.writeURI(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (UUID.class.getName().equals(prop.getType())) {
                writer.code("%s.writeUUID(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if ("byte[]".equals(prop.getType())) {
                writer.code("%s.writeBytes(elm, \"%s\", %2$s, \"base64\");", XHelper.class.getName(), prop.getId());
            } else if ("compressed".equals(prop.getType())) {
                writer.code("%s.writeBytes(elm, \"%s\", %2$s, \"base64compressed\");", XHelper.class.getName(), prop.getId());
            } else if ("Object".equals(prop.getType()) || "java.lang.Object".equals(prop.getType())) {
                writer.code("%s.writeObject(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else if (PropertyGenerator.isXSerializable(prop.getType())) {
                writer.code("%s.writeObject(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
            } else {
                throw new Exception(String.format("toXML(): unsupported type %s of property %s in entity %s", prop.getType(), prop.getId(), bt.getId()));
            }
        }
    }

    private static String getIndexType(IndexProperty prop, GenerationContext ctx) {
        String type;
        if (ctx.getMetaRegistry().getDictionaries().containsKey(prop.getType())) {
            type = String.format("%s<%s>", DictionaryReference.class.getName(), prop.getType());
        } else if (ModelCodeGenHelper.isNestedEntityReferenceType(prop.getType())) {
            MiscUtil.Pair<String, String> types = ModelCodeGenHelper.getNestedEntityReferenceTypes(prop.getType());
            type = String.format("%s<%s,  %s>", NestedEntityReference.class.getName(), types.getFirst(), types.getSecond());
        } else if (ctx.getMetaRegistry().getEntities().containsKey(prop.getType()) || ctx.getMetaRegistry().getEntityRefs().containsKey(prop.getType())) {
            String subtype = prop.getType();
            EntityType ett = ctx.getMetaRegistry().getEntities().get(prop.getType());
            if (ett == null || ett.isAbstract()) {
                subtype = "? extends " + subtype;
            }
            type = EntityReference.class.getName() + "<" + subtype + ">";
        } else {
            type = "text".equals(prop.getType()) ? "String" : prop.getType();
        }
        return type;
    }

    private static boolean entityFromXML(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        if (!ctx.getMetaRegistry().getEntities().containsKey(prop.getType()) && !ctx.getMetaRegistry().getEntityRefs().containsKey(prop.getType())) {
            return false;
        }
        if (prop instanceof IndexProperty) {
            return false;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                writer.code("%s.readHistoricalProperty(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                return true;
            }
            if (brp.isPeriodical()) {
                writer.code("%s.readPeriodicalProperty(elm, \"%s\", %2$s);", PeriodicalPropertyHelper.class.getName(), prop.getId());
                return true;
            }
        }
        if (prop.getType().startsWith(EntityContainer.class.getName())) {
            writer.beginBlock();
            writer.code("%s objElm = %s.getElement(elm, \"%s\");", Element.class.getName(), XmlUtil.class.getName(), prop.getId());
            writer.code("%s = new %s(%s.getClass(%3$s.readString(objElm, \"entityType\")), %3$s.readString(objElm, \"uid\"));", prop.getId(), EntityContainer.class.getName(), XHelper.class.getName());
            writer.code("%s.fromXML(objElm);", prop.getId());
            writer.endBlock();
        } else if (prop instanceof BaseReferenceProperty && ((BaseReferenceProperty)prop).isReference()) {
            writer.beginBlock();
            writer.code("%s objElm = %s.getElement(elm, \"%s\");", Element.class.getName(), XmlUtil.class.getName(), prop.getId());
            writer.beginBlock("if (objElm != null)", new Object[0]);
            ModelCodeGenHelper.generateRenameReferenceCode(writer, ModelCodeGenHelper.getEntityRenamersClassNames(ctx.getMetaRegistry(), prop.getType()), "objElm");
            writer.code("String className = objElm.getAttribute(\"class\");", new Object[0]);
            writer.beginBlock("if(%s.isBlank(className))", TextUtil.class.getName());
            writer.code("String ecUid = %s.getValue(objElm, \"uid\");", XmlUtil.class.getName());
            writer.code("String refCaption = %s.getValue(objElm, \"caption\");", XmlUtil.class.getName());
            writer.code("Class<%s> etType = (Class<%1$s>) %s.getClass(%s.getValue(objElm, \"type\"));", prop.getType(), XHelper.class.getName(), XmlUtil.class.getName());
            writer.code("%s = new %s<%s>(ecUid, etType, refCaption);", prop.getId(), EntityReference.class.getName(), prop.getType());
            writer.restartBlock("else", new Object[0]);
            writer.code("%s = (%s<%s>) %s.readObject(elm, \"%1$s\");", prop.getId(), EntityReference.class.getName(), prop.getType(), XHelper.class.getName());
            writer.endBlock();
            writer.restartBlock("else", new Object[0]);
            writer.code("%s = null;", prop.getId());
            writer.endBlock();
            writer.endBlock();
        } else {
            Set<String> renamers = ModelCodeGenHelper.getEntityRenamersClassNames(ctx.getMetaRegistry(), prop.getType());
            if (!renamers.isEmpty()) {
                writer.beginBlock();
                writer.code("%s objElm = %s.getElement(elm, \"%s\");", Element.class.getName(), XmlUtil.class.getName(), prop.getId());
                writer.beginBlock("if(objElm != null)", new Object[0]);
                ModelCodeGenHelper.generateRenameEntityCode(writer, renamers, "objElm");
                writer.endBlock();
                writer.endBlock();
            }
            writer.code("%s = (%s) %s.readObject(elm, \"%1$s\");", prop.getId(), prop.getType(), XHelper.class.getName());
        }
        return true;
    }

    private static boolean dictionaryFromXML(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        if (!ctx.getMetaRegistry().getDictionaries().containsKey(prop.getType())) {
            return false;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                writer.code("%s.readHistoricalDictProperty(elm, \"%s\", %s, new %s.DictionaryReferenceCreator<com.gridnine.xtrip.common.model.dict.DictionaryReference<%s>>()", HistoricalValueHelper.class.getName(), prop.getId(), prop.getId(), HistoricalValueHelper.class.getName(), prop.getType());
                writer.beginBlock();
                writer.code("@Override", new Object[0]);
                writer.beginBlock("public %sReference createDictElement(final String code, String caption)", prop.getType());
                writer.code("%sReference item = new %sReference();", prop.getType(), prop.getType());
                writer.code("item.setCode(code);", new Object[0]);
                writer.code("item.setCaption(caption);", new Object[0]);
                writer.code("return item;", new Object[0]);
                writer.endBlock();
                writer.endBlock();
                writer.code(");", new Object[0]);
                return true;
            }
            if (brp.isPeriodical()) {
                writer.code("%s.readPeriodicalProperty(elm, \"%s\", %2$s);", PeriodicalPropertyHelper.class.getName(), prop.getId());
                return true;
            }
        }
        writer.beginBlock();
        writer.comment("Check if this property had historical values before, but now marked as non-historical (then take the last historical value)", new Object[0]);
        writer.code("String dictCode = null;", new Object[0]);
        writer.code("java.util.List<%s<com.gridnine.xtrip.common.model.dict.DictionaryReference<%s>>> tempValues = new java.util.ArrayList<>();", HistoricalValue.class.getName(), prop.getType());
        writer.code("%s.readHistoricalDictProperty(elm, \"%s\", tempValues, new %s.DictionaryReferenceCreator<com.gridnine.xtrip.common.model.dict.DictionaryReference<%s>>()", HistoricalValueHelper.class.getName(), prop.getId(), HistoricalValueHelper.class.getName(), prop.getType());
        writer.beginBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public %sReference createDictElement(final String code, String caption)", prop.getType());
        writer.code("%sReference item = new %sReference();", prop.getType(), prop.getType());
        writer.code("item.setCode(code);", new Object[0]);
        writer.code("item.setCaption(caption);", new Object[0]);
        writer.code("return item;", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.code(");", new Object[0]);
        writer.beginBlock("if (%s.getValue(tempValues) != null)", HistoricalValueHelper.class.getName());
        writer.code("dictCode = %s.getValue(tempValues).getCode();", HistoricalValueHelper.class.getName());
        writer.restartBlock("else", new Object[0]);
        writer.code("dictCode = %s.getValue(elm, \"%s\");", XmlUtil.class.getName(), prop.getId());
        writer.endBlock();
        writer.beginBlock("if (dictCode != null)", new Object[0]);
        writer.code("%s = new %sReference(dictCode, %s.getValue(elm, \"%1$s@caption\"));", prop.getId(), prop.getType(), XmlUtil.class.getName());
        writer.restartBlock("else", new Object[0]);
        writer.code("%s = null;", prop.getId());
        writer.endBlock();
        writer.endBlock();
        return true;
    }

    private static boolean entityToXML(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        if (!ctx.getMetaRegistry().getEntities().containsKey(prop.getType()) && !ctx.getMetaRegistry().getEntityRefs().containsKey(prop.getType())) {
            return false;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                writer.code("%s.writeHistoricalProperty(elm, \"%s\", %2$s);", HistoricalValueHelper.class.getName(), prop.getId());
                return true;
            }
            if (brp.isPeriodical()) {
                writer.code("%s.writePeriodicalProperty(elm, \"%s\", %2$s);", PeriodicalPropertyHelper.class.getName(), prop.getId());
                return true;
            }
        }
        writer.code("%s.writeObject(elm, \"%s\", %2$s);", XHelper.class.getName(), prop.getId());
        return true;
    }

    private static boolean dictionaryToXML(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        if (!ctx.getMetaRegistry().getDictionaries().containsKey(prop.getType())) {
            return false;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                writer.code("%s.writeHistoricalDictProperty(elm, \"%s\", %s, new %s.DictionaryReferenceGetter<%sReference>()", HistoricalValueHelper.class.getName(), prop.getId(), prop.getId(), HistoricalValueHelper.class.getName(), prop.getType());
                writer.beginBlock();
                writer.code("@Override", new Object[0]);
                writer.beginBlock("public String getCaption(final %sReference value)", prop.getType());
                writer.code("return value.getCaption();", new Object[0]);
                writer.endBlock();
                writer.code("@Override", new Object[0]);
                writer.beginBlock("public String getCode(final %sReference value)", prop.getType());
                writer.code("return value.getCode();", new Object[0]);
                writer.endBlock();
                writer.endBlock();
                writer.code(");", new Object[0]);
                return true;
            }
            if (brp.isPeriodical()) {
                writer.code("%s.writePeriodicalProperty(elm, \"%s\", %2$s);", PeriodicalPropertyHelper.class.getName(), prop.getId());
                return true;
            }
        }
        writer.beginBlock("if (%s != null)", prop.getId());
        writer.code("%s elm2 = %s.writeString(elm, \"%s\", %3$s.getCode());", Element.class.getName(), XHelper.class.getName(), prop.getId());
        writer.code("elm2.setAttribute(\"class\", \"%sReference\");", prop.getType());
        writer.beginBlock("if (!%s.isBlank(%s.getCaption()))", TextUtil.class.getName(), prop.getId());
        writer.code("elm2.setAttribute(\"caption\", %s.getCaption());", prop.getId());
        writer.endBlock();
        writer.endBlock();
        return true;
    }

    private static boolean entityWriteXMLElements(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        if (!ctx.getMetaRegistry().getEntities().containsKey(prop.getType()) && !ctx.getMetaRegistry().getEntityRefs().containsKey(prop.getType())) {
            return false;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                writer.code("%s.writeHistoricalProperty(writer, \"%s\", %2$s);", HistoricalValueSHelper.class.getName(), prop.getId());
                return true;
            }
            if (brp.isPeriodical()) {
                writer.code("%s.writePeriodicalProperty(writer, \"%s\", %2$s);", PeriodicalPropertySHelper.class.getName(), prop.getId());
                return true;
            }
        }
        writer.code("%s.writeObject(writer, \"%s\", %2$s);", XSHelper.class.getName(), prop.getId());
        return true;
    }

    private static boolean dictionaryWriteXMLElements(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        if (!ctx.getMetaRegistry().getDictionaries().containsKey(prop.getType())) {
            return false;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                writer.code("%s.writeHistoricalDictProperty(writer, \"%s\", %s, new %s.DictionaryReferenceGetter<%sReference>()", HistoricalValueSHelper.class.getName(), prop.getId(), prop.getId(), HistoricalValueSHelper.class.getName(), prop.getType());
                writer.beginBlock();
                writer.code("@Override", new Object[0]);
                writer.beginBlock("public String getCaption(final %sReference value)", prop.getType());
                writer.code("return value.getCaption();", new Object[0]);
                writer.endBlock();
                writer.code("@Override", new Object[0]);
                writer.beginBlock("public String getCode(final %sReference value)", prop.getType());
                writer.code("return value.getCode();", new Object[0]);
                writer.endBlock();
                writer.endBlock();
                writer.code(");", new Object[0]);
                return true;
            }
            if (brp.isPeriodical()) {
                writer.code("%s.writePeriodicalProperty(writer, \"%s\", %2$s);", PeriodicalPropertySHelper.class.getName(), prop.getId());
                return true;
            }
        }
        writer.beginBlock("if (%s != null)", prop.getId());
        writer.code("%s<String, String> attributes = new %s<String,String>();", Map.class.getName(), HashMap.class.getName());
        writer.code("attributes.put(\"class\", \"%sReference\");", prop.getType());
        writer.beginBlock("if (!%s.isBlank(%s.getCaption()))", TextUtil.class.getName(), prop.getId());
        writer.code("attributes.put(\"caption\", %s.getCaption());", prop.getId());
        writer.endBlock();
        writer.code("%s.writeString(writer, \"%s\", %2$s.getCode(), attributes);", XSHelper.class.getName(), prop.getId());
        writer.endBlock();
        return true;
    }

    private static boolean entityCopyFrom(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        if (!ctx.getMetaRegistry().getEntities().containsKey(prop.getType()) && !ctx.getMetaRegistry().getEntityRefs().containsKey(prop.getType())) {
            return false;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                return true;
            }
            if (brp.isPeriodical()) {
                PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                return true;
            }
        }
        PropertyGenerator.generateCopyFromCloneObject(writer, prop);
        return true;
    }

    private static boolean dictionaryCopyFrom(JavaWriter writer, BaseProperty prop, GenerationContext ctx) throws Exception {
        if (!ctx.getMetaRegistry().getDictionaries().containsKey(prop.getType())) {
            return false;
        }
        if (prop instanceof BaseReferenceProperty) {
            BaseReferenceProperty brp = (BaseReferenceProperty)prop;
            if (brp.isHistorical()) {
                PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                return true;
            }
            if (brp.isPeriodical()) {
                PropertyGenerator.generateCopyFromCloneCollection(writer, prop);
                return true;
            }
        }
        PropertyGenerator.generateCopyFromCloneObject(writer, prop);
        return true;
    }

    private PropertyGenerator() {
    }
}

