/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.rest;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.rest.BaseRestMetaElement;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.meta.rest.RestStringWithLang;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class RestCodeGenHelper {
    public static boolean isValidatable(RestEntityType type, RestMetaRegistry registry) {
        if (type.isValidatable()) {
            return true;
        }
        if (type.getExtendsId() == null) {
            return false;
        }
        RestEntityType parent = registry.getEntities().get(type.getExtendsId());
        if (parent == null) {
            return false;
        }
        return RestCodeGenHelper.isValidatable(parent, registry);
    }

    static boolean isParentWithMessages(RestEntityType type, RestMetaRegistry registry) {
        if (type.getExtendsId() == null) {
            return false;
        }
        RestEntityType parent = registry.getEntities().get(type.getExtendsId());
        if (parent == null) {
            return false;
        }
        if (parent.isWithMessages()) {
            return true;
        }
        return RestCodeGenHelper.isParentWithMessages(parent, registry);
    }

    static long generateSerialVersionUID(RestEntityType ett) {
        long result = 65881L * (long)ett.getId().hashCode();
        for (RestProperty restProperty : new TreeMap<String, RestProperty>(ett.getProperties()).values()) {
            result += 35731L * (long)restProperty.getId().hashCode() * (long)restProperty.getType().hashCode();
        }
        for (RestCollection restCollection : new TreeMap<String, RestCollection>(ett.getCollections()).values()) {
            result += 597419L * (long)restCollection.getId().hashCode() * (long)restCollection.getElementType().hashCode();
        }
        for (RestMap restMap : new TreeMap<String, RestMap>(ett.getMaps()).values()) {
            result += 3579119L * (long)restMap.getId().hashCode() * (long)restMap.getKeyType().hashCode() * (long)restMap.getValueType().hashCode();
        }
        return result;
    }

    static RestEntityType getEntityType(GenerationContext ctx, String id) {
        return ctx.getRestMetaRegistry().getEntities().get(id);
    }

    static void maybeDeprecated(BaseMetaElement meta, JavaWriter writer) throws IOException {
        if (meta.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
    }

    static String genValidationContextClassName(String mainClassId) {
        return GenUtil.getSimpleClassName(mainClassId) + "ValidationContext";
    }

    static void generateTypeDoc(JavaWriter writer, GenerationContext ctx, BaseRestMetaElement type, String typeName, List<RestStringWithLang> documentation) throws IOException {
        StringBuilder buf = new StringBuilder();
        String doc = RestMetaRegistryHelper.joinStrings("<br>", documentation, ctx.getDocLang());
        if (!TextUtil.isBlank(doc)) {
            buf.append(doc).append("<br><br>");
        }
        buf.append(typeName).append(" generated from REST metadata.\n");
        buf.append("<dl>\n");
        buf.append("<dt>ID</dt><dd>").append(type.getId()).append("</dd>\n");
        buf.append("<dt>sources</dt><dd>").append((Object)ctx.getRestMetaRegistry().getSources(type).stream().map(url -> {
            String result = url.toExternalForm();
            int p = result.indexOf("plugins/");
            return p == -1 ? result : result.substring(p);
        }).collect(Collectors.joining("<br>"))).append("</dd>\n");
        buf.append("</dl>");
        if (!type.getAttrubutes().isEmpty()) {
            buf.append("\nAttributes:\n");
            buf.append("<table border=1 cellspacing=0 cellpadding=5>\n");
            buf.append("<tr><th>Name</th><th>Value</th></tr>\n");
            type.getAttrubutes().entrySet().forEach(attributeEntry -> {
                String key = (String)attributeEntry.getKey();
                ((List)attributeEntry.getValue()).forEach(value -> buf.append("<tr><td>").append(key).append("</td><td>").append((String)value).append("</td></tr>\n"));
            });
            buf.append("</table>");
        }
        writer.doc(buf.toString(), new Object[0]);
    }

    private RestCodeGenHelper() {
    }
}

