/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.help;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HelpManager {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, URL> urls = new HashMap<String, URL>();

    public static HelpManager get() {
        return Environment.getPublished(HelpManager.class);
    }

    public void registerResource(URL url) throws Exception {
        if (url == null) {
            return;
        }
        if (!IoUtil.isResourceExists(url)) {
            this.log.warn("resource file does not exist: url=" + url);
            return;
        }
        File directory = IoUtil.url2file(url);
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                if (!file.getName().endsWith(".xml")) continue;
                try {
                    this.registerFile(IoUtil.file2url(file));
                    this.log.info("registered resource " + file.getAbsolutePath());
                }
                catch (Exception e) {
                    this.log.error("failed registering resource " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        } else {
            this.log.warn("resource file is not a directory: url=" + url);
        }
    }

    private void registerFile(URL url) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(IoUtil.getResourceInputStream(url));
        NodeList linkNodeList = document.getElementsByTagName("link");
        for (int i = 0; i < linkNodeList.getLength(); ++i) {
            Element linkElement = (Element)linkNodeList.item(i);
            String id = XmlUtil.getValue(linkElement, "@id");
            String link = XmlUtil.getValue(linkElement, ".");
            this.urls.put(id.trim(), new URL(link.trim()));
        }
    }

    public URL getUrl(String id) {
        URL url = this.urls.get(id);
        return url != null ? url : this.urls.get("");
    }
}

