/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.helper;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.List;

public class SearchHelper {
    public static <E extends BaseEntity, I extends EntityIndex<E>> List<I> searchEntity(Class<I> clazz, SearchCriterion ... criterions) {
        SearchQuery query = new SearchQuery();
        if (criterions != null) {
            for (SearchCriterion criterion : criterions) {
                query.getCriteria().getCriterions().add(criterion);
            }
        }
        return EntityStorage.get().search(clazz, query).getData();
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> boolean hasEntity(Class<I> clazz, SearchCriterion ... criterions) {
        SearchQuery query = new SearchQuery();
        if (criterions != null) {
            for (SearchCriterion criterion : criterions) {
                query.getCriteria().getCriterions().add(criterion);
            }
        }
        query.setLimit(1);
        query.getPreferredProperties().add("uid");
        return EntityStorage.get().search(clazz, query).getData().size() != 0;
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> I uniqueEntity(Class<I> clazz, SearchCriterion ... criterions) {
        List<I> data;
        SearchQuery query = new SearchQuery();
        query.setLimit(1);
        if (criterions != null) {
            for (SearchCriterion criterion : criterions) {
                query.getCriteria().getCriterions().add(criterion);
            }
        }
        return (I)(!(data = EntityStorage.get().search(clazz, query).getData()).isEmpty() ? (EntityIndex)data.get(0) : null);
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> EntityContainer<E> uniqueEntityContainer(Class<I> clazz, SearchCriterion ... criterions) {
        List<I> data;
        SearchQuery query = new SearchQuery();
        query.setLimit(1);
        if (criterions != null) {
            for (SearchCriterion criterion : criterions) {
                query.getCriteria().getCriterions().add(criterion);
            }
        }
        return !(data = EntityStorage.get().search(clazz, query).getData()).isEmpty() ? EntityStorage.get().resolve(((EntityIndex)data.get(0)).getSource()) : null;
    }

    public static <T extends BaseAsset> List<T> searchAsset(Class<T> clazz, SearchCriterion ... criterions) {
        SearchQuery query = new SearchQuery();
        if (criterions != null) {
            for (SearchCriterion criterion : criterions) {
                query.getCriteria().getCriterions().add(criterion);
            }
        }
        return AssetsStorage.get().search(clazz, query).getData();
    }

    public static <T extends BaseAsset> T uniqueAsset(Class<T> clazz, SearchCriterion ... criterions) {
        List<T> data = SearchHelper.searchAsset(clazz, criterions);
        return (T)(!data.isEmpty() ? (BaseAsset)data.get(0) : null);
    }

    public static <T extends BaseAsset> boolean hasAsset(Class<T> clazz, SearchCriterion ... criterions) {
        SearchQuery query = new SearchQuery();
        if (criterions != null) {
            for (SearchCriterion criterion : criterions) {
                query.getCriteria().getCriterions().add(criterion);
            }
        }
        query.setLimit(1);
        query.getPreferredProperties().add("uid");
        return AssetsStorage.get().search(clazz, query).getData().size() != 0;
    }
}

