/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.helper;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.gridnine.xtrip.common.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UniqueSettingsRegistry {
    private final transient Logger log = LoggerFactory.getLogger(UniqueSettingsRegistry.class);
    private final BiMap<String, String> uniqueEntitiesUids = HashBiMap.create();

    public static UniqueSettingsRegistry get() {
        return Environment.getPublished(UniqueSettingsRegistry.class);
    }

    public void register(String className, String uid) {
        try {
            if (!this.uniqueEntitiesUids.containsKey((Object)className)) {
                this.uniqueEntitiesUids.put((Object)className, (Object)uid);
            } else {
                this.log.warn("ClassName already present, cannot register Entry {class=" + className + " uid=" + uid + "}");
            }
        }
        catch (IllegalArgumentException e) {
            if (((String)this.uniqueEntitiesUids.get((Object)className)).equals(uid)) {
                return;
            }
            this.log.warn("UID already present, cannot register Entry {class=" + className + " uid=" + uid + "}");
        }
    }

    public String getUidByClassName(String className) {
        return (String)this.uniqueEntitiesUids.get((Object)className);
    }
}

