/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.key.bindings;

import com.gridnine.xtrip.common.key.bindings.KeyStrokeHelper;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import javax.swing.KeyStroke;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class KeyBinding
implements Serializable,
XSerializable,
XSSerializable {
    private static final long serialVersionUID = -3620661958409440090L;
    private String actionId;
    private KeyStroke keyStroke;

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.actionId = XHelper.readString(elm, "actionId");
        int modifiers = XHelper.readInt(elm, "modifiers", 0);
        int keyCode = XHelper.readInt(elm, "keyCode", 0);
        if (keyCode != 0) {
            this.keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        }
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        int modifiers = 0;
        int keyCode = 0;
        while (reader.nextTag() != 2) {
            String tag = reader.getName().getLocalPart();
            if ("actionId".equals(tag)) {
                this.actionId = XSHelper.readString(reader);
                continue;
            }
            if ("modifiers".equals(tag)) {
                modifiers = XSHelper.readInt(reader, 0);
                continue;
            }
            if ("keyCode".equals(tag)) {
                keyCode = XSHelper.readInt(reader, 0);
                continue;
            }
            XSHelper.skipElement(reader);
        }
        if (keyCode != 0) {
            this.keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeString(elm, "actionId", this.actionId);
        int modifiers = this.keyStroke.getModifiers();
        int keyCode = this.keyStroke.getKeyCode();
        if (keyCode != 0) {
            XHelper.writeInt(elm, "modifiers", modifiers);
            XHelper.writeInt(elm, "keyCode", keyCode);
        }
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "actionId", this.actionId);
        int modifiers = this.keyStroke.getModifiers();
        int keyCode = this.keyStroke.getKeyCode();
        if (keyCode != 0) {
            XSHelper.writeInt(writer, "modifiers", modifiers);
            XSHelper.writeInt(writer, "keyCode", keyCode);
        }
    }

    public String toString() {
        return String.format("%s %s", this.actionId, this.keyStroke != null ? KeyStrokeHelper.toString(this.keyStroke) : "");
    }
}

