/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n;

import com.gridnine.xtrip.common.l10n.EnglishNumber2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.UnsupportedCurrencyException;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class EnglishNumber2WordsConverterTest {
    @Test
    public void toNumberWordsReturnsCorrectText() {
        EnglishNumber2WordsConverter objectUnderTest = new EnglishNumber2WordsConverter();
        Assert.assertEquals((Object)"one", (Object)objectUnderTest.toNumberWords(BigDecimal.ONE));
        Assert.assertEquals((Object)"eleven thousand two hundred thirty-five", (Object)objectUnderTest.toNumberWords(BigDecimal.valueOf(11235L)));
        Assert.assertEquals((Object)"one thousand", (Object)objectUnderTest.toNumberWords(BigDecimal.valueOf(1000L)));
    }

    @Test
    public void getLocaleReturnsCorrectLocale() {
        EnglishNumber2WordsConverter objectUnderTest = new EnglishNumber2WordsConverter();
        Assert.assertEquals((Object)"en", (Object)objectUnderTest.getLocale().getLanguage());
    }

    @Test
    public void toCurrencyWordsReturnsCorrectResults() throws UnsupportedCurrencyException {
        EnglishNumber2WordsConverter objectUnderTest = new EnglishNumber2WordsConverter();
        Assert.assertEquals((Object)"eleven Russian Rubles 52 kopecks", (Object)objectUnderTest.toCurrencyWords(BigDecimal.valueOf(11.52), "RUR", false, false, false, false));
        Assert.assertEquals((Object)"eleven rub. 52 kop.", (Object)objectUnderTest.toCurrencyWords(BigDecimal.valueOf(11.52), "RUR", false, false, false, true));
        Assert.assertEquals((Object)"one thousand rub. 00 kop.", (Object)objectUnderTest.toCurrencyWords(BigDecimal.valueOf(1000.0), "RUR", false, false, false, true));
    }
}

