/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class L10nMessage
implements Serializable,
XCloneable {
    private static final long serialVersionUID = 6267681939008561435L;
    private String key;
    private final List<Object> parameters = new ArrayList<Object>();

    public String getKey() {
        return this.key;
    }

    public void setKey(String value) {
        this.key = value;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof L10nMessage)) {
            return false;
        }
        L10nMessage message = (L10nMessage)obj;
        if (!TextUtil.isSame(message.getKey(), this.key)) {
            return false;
        }
        return CollectionUtil.equals(this.parameters, message.getParameters(), false);
    }

    public int hashCode() {
        int hashCode = 0;
        if (!TextUtil.isBlank(this.key)) {
            hashCode ^= this.key.hashCode();
        }
        for (Object obj : this.parameters) {
            if (obj == null) continue;
            hashCode ^= obj.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        if (!Environment.isPublished(LocaleManager.class)) {
            return L10nResourcesManager.replace(this.key, this.parameters.toArray());
        }
        return LocaleManager.get().getL10nResourceManager().getMessage(this);
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        L10nMessage clone = new L10nMessage();
        clone.key = this.key;
        for (Object item : this.parameters) {
            clone.parameters.add(XCloneHelper.cloneObject(item, newUids, uids));
        }
        return clone;
    }
}

