/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.LocaleString;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class L10nString
implements Serializable,
XCloneable,
LocaleString {
    private static final long serialVersionUID = -4714053822625685102L;
    private final Map<Locale, String> values = new HashMap<Locale, String>();

    public Map<Locale, String> getValues() {
        return this.values;
    }

    public void setStringValue(String value) {
        this.values.clear();
        this.values.putAll(this.fromLocalizableString(value));
    }

    public String getStringValue() {
        return this.toLocalizableString(this.values);
    }

    public String toString() {
        Locale locale = null;
        if (Environment.isPublished(LocaleManager.class)) {
            locale = LocaleManager.get().getCurrentLocale();
        }
        return this.toString(locale);
    }

    @Override
    public String toString(Locale locale) {
        return L10nStringHelper.getValue(this, locale, false);
    }

    private Map<Locale, String> fromLocalizableString(String value) {
        if (TextUtil.isBlank(value)) {
            return Collections.emptyMap();
        }
        HashMap<Locale, String> values = new HashMap<Locale, String>();
        if (!Pattern.compile("\\|\\|").matcher(value).find()) {
            values.put(Locale.ROOT, value);
        } else {
            String[] tokens = value.split("\\|\\|");
            for (int i = 0; i < tokens.length; ++i) {
                if (i + 1 >= tokens.length || TextUtil.isBlank(tokens[i]) || TextUtil.isBlank(tokens[i + 1])) continue;
                values.put(this.fromLocaleString(tokens[i]), tokens[i + 1]);
                ++i;
            }
        }
        return values;
    }

    private String toLocalizableString(Map<Locale, String> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Locale, String> entry : values.entrySet()) {
            Locale locale = entry.getKey();
            String value = entry.getValue();
            if (locale == null || TextUtil.isBlank(value)) continue;
            stringBuilder.append("||");
            stringBuilder.append(this.toLocaleString(locale));
            stringBuilder.append("||");
            stringBuilder.append(value);
        }
        return stringBuilder.toString();
    }

    private Locale fromLocaleString(String localeString) {
        String[] entries = localeString.split("_");
        if (entries.length > 2) {
            return new Locale(entries[0], entries[1], entries[2]);
        }
        if (entries.length > 1) {
            return new Locale(entries[0], entries[1], "");
        }
        if (entries.length > 0) {
            return new Locale(entries[0], "", "");
        }
        return Locale.ROOT;
    }

    private String toLocaleString(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtil.isBlank(locale.getLanguage())) {
            stringBuilder.append(locale.getLanguage());
        }
        stringBuilder.append("_");
        if (!TextUtil.isBlank(locale.getCountry())) {
            stringBuilder.append(locale.getCountry());
        }
        stringBuilder.append("_");
        if (!TextUtil.isBlank(locale.getVariant())) {
            stringBuilder.append(locale.getVariant());
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        L10nString other = (L10nString)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        L10nString clone = new L10nString();
        clone.values.putAll(this.values);
        return clone;
    }
}

