/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleData;
import com.gridnine.xtrip.common.l10n.model.ResourceBundleControlExt;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleManager {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final ThreadLocal<Locale> currentLocales = new ThreadLocal<Locale>(){

        @Override
        protected Locale initialValue() {
            Locale result = LocaleManager.this.getDefaultLocale();
            if (!LocaleManager.this.isSupportedLocale(result)) {
                result = Locale.ENGLISH;
            }
            return result;
        }
    };
    final Map<Locale, LocaleData> supportedLocales = new LinkedHashMap<Locale, LocaleData>();
    private final Map<String, Locale> localeAliases = new HashMap<String, Locale>();
    private final L10nResourcesManager l10nResourceManager = new L10nResourcesManager();
    private Locale defaultLocale = Locale.getDefault();

    public static LocaleManager get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(LocaleManager.class);
    }

    public L10nResourcesManager getL10nResourceManager() {
        return this.l10nResourceManager;
    }

    public void registerSupportedLocale(Locale locale) {
        String alias;
        this.supportedLocales.put(locale, this.loadLocaleData(locale));
        this.log.debug("registered supported locale " + locale);
        if (!TextUtil.isBlank(locale.getVariant())) {
            alias = locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant();
            this.localeAliases.put(alias, locale);
            this.log.debug("registered supported locale alias " + alias);
        }
        if (!TextUtil.isBlank(locale.getCountry())) {
            alias = locale.getLanguage() + '_' + locale.getCountry();
            this.localeAliases.put(alias, locale);
            this.log.debug("registered supported locale alias " + alias);
        }
        this.localeAliases.put(locale.getLanguage(), locale);
        this.log.debug("registered supported locale alias " + locale.getLanguage());
    }

    protected LocaleData loadLocaleData(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(LocaleData.class.getName(), locale, LocaleData.class.getClassLoader(), new ResourceBundleControlExt("UTF8"));
        LocaleData result = new LocaleData();
        result.setLocale(locale);
        String str = bundle.getString("icon");
        result.setIcon(LocaleManager.class.getResource(str));
        if (result.getIcon() == null) {
            result.setIcon(this.getClass().getClassLoader().getResource(str));
            if (result.getIcon() == null) {
                try {
                    result.setIcon(new URL(str));
                }
                catch (MalformedURLException e) {
                    this.log.warn("failed parsing icon URL " + str);
                }
            }
        }
        if (result.getIcon() == null) {
            this.log.warn("no icon URL set for locale " + locale);
        }
        result.setDateFormatPattern(bundle.getString("dateFormat"));
        result.setDateTimeFormatPattern(bundle.getString("dateTimeFormat"));
        result.setTimeFormatPattern(bundle.getString("timeFormat"));
        result.setNumberFormatPattern(bundle.getString("numberFormat"));
        result.setPriceFormatPattern(bundle.getString("priceFormat"));
        result.setTimeZonePattern(bundle.getString("timeZone"));
        this.log.debug("loaded data for locale " + locale);
        return result;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale value) {
        this.defaultLocale = value;
    }

    public Locale getCurrentLocale() {
        return this.currentLocales.get();
    }

    public LocaleData getCurrentLocaleData() {
        return this.getLocaleData(this.currentLocales.get());
    }

    public void setCurrentLocale(Locale value) {
        Locale supportedLocale = this.findSupportedLocale(value);
        if (supportedLocale == null) {
            throw new IllegalArgumentException("unsupported locale " + value);
        }
        this.currentLocales.set(supportedLocale);
    }

    public Collection<LocaleData> getSupportedLocales() {
        return this.supportedLocales.values();
    }

    public boolean isSupportedLocale(Locale locale) {
        return this.findSupportedLocale(locale) != null;
    }

    public LocaleData getLocaleData(Locale locale) {
        Locale supportedLocale = this.findSupportedLocale(locale);
        if (supportedLocale == null) {
            throw new IllegalArgumentException("unsupported locale " + locale);
        }
        return this.supportedLocales.get(supportedLocale);
    }

    private Locale findSupportedLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        Locale result = this.localeAliases.get(locale.toString());
        if (result != null) {
            return result;
        }
        if (!TextUtil.isBlank(locale.getVariant()) && (result = this.localeAliases.get(locale.getLanguage() + '_' + locale.getCountry())) != null) {
            return result;
        }
        return this.localeAliases.get(locale.getLanguage());
    }

    private static class Holder {
        public static final LocaleManager INSTANCE = Environment.getPublished(LocaleManager.class);

        private Holder() {
        }
    }
}

