/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Element;

public abstract class BaseMetaElement {
    private String id;
    private boolean deprecated;
    protected final Set<Resources> resources = new LinkedHashSet<Resources>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInfo(String key, Locale locale, String def) {
        return this.resources.stream().filter(Objects::nonNull).map(r -> r.findResource(key, locale)).filter(Objects::nonNull).findFirst().orElse(def);
    }

    public String getDisplayName() {
        return this.getDisplayName(LocaleManager.get().getCurrentLocale());
    }

    public String getShortName() {
        String key = TextUtil.concat(this.getResourceKey(), ".shortName");
        return this.getInfo(key, LocaleManager.get().getCurrentLocale(), key);
    }

    public String getDisplayName(Locale locale) {
        String key = TextUtil.concat(this.getResourceKey(), ".name");
        return this.getInfo(key, locale, key);
    }

    public String getDescription() {
        return this.getInfo(TextUtil.concat(this.getResourceKey(), ".description"), LocaleManager.get().getCurrentLocale(), null);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    protected abstract String getResourceKey();

    protected void fromXml(Element elm, Resources res) {
        if (TextUtil.isBlank(this.id)) {
            this.id = XHelper.readString(elm, "@id");
            if (this.id != null) {
                this.id = this.id.trim();
            }
        }
        if (res != null) {
            this.resources.add(res);
        }
        this.deprecated = this.deprecated || XHelper.readBoolean(elm, "@deprecated", false);
    }
}

