/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class BaseType
extends BaseMetaElement {
    private final List<URL> sources = new ArrayList<URL>();
    private final Map<String, List<String>> codeFragments = new HashMap<String, List<String>>();
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();

    public Collection<URL> getSources() {
        return this.sources;
    }

    void addSource(URL value) {
        this.sources.add(value);
    }

    public List<String> getCodeFragments(String context) {
        List<String> result = this.codeFragments.get(TextUtil.isBlank(context) ? "" : context);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    protected String getResourceKey() {
        return this.getId();
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        for (Element codeElm : XmlUtil.getElements(elm, "code-fragment")) {
            List<String> list;
            String value = XmlUtil.getValue(codeElm);
            if (TextUtil.isBlank(value)) continue;
            String context = XmlUtil.getValue(codeElm, "@context");
            if (TextUtil.isBlank(context)) {
                context = "";
            }
            if ((list = this.codeFragments.get(context)) == null) {
                list = new ArrayList<String>();
                this.codeFragments.put(context, list);
            }
            list.add(value);
        }
        for (Element paramElm : XmlUtil.getElements(elm, "param")) {
            this.parameters.put(XHelper.readString(paramElm, "@name"), XHelper.readString(paramElm, "@value"));
        }
        for (Map.Entry entry : XmlUtil.getAttributes(elm).entrySet()) {
            if (!((String)entry.getKey()).contains("_")) continue;
            this.parameters.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Element child : XmlUtil.getChildren(elm)) {
            if (!child.getNodeName().contains("_")) continue;
            this.parameters.put(child.getNodeName(), XmlUtil.getValue(child));
        }
    }
}

