/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class EntityCollection
extends BaseMetaElement {
    private boolean viewable;
    private String type;
    private String keyType;
    private String elementType;
    private boolean keyReference;
    private boolean reference;
    private String format;
    private boolean privateCollection;
    private boolean nullable;
    private String instantiator;
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private UnitTestParameters unitTestParameters;
    private final String owner;

    EntityCollection(String ownerId) {
        this.owner = ownerId;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public String getType() {
        return this.type;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getElementType() {
        return this.elementType;
    }

    public boolean isKeyReference() {
        return this.keyReference;
    }

    public boolean isReference() {
        return this.reference;
    }

    public String getFormat() {
        return this.format;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public UnitTestParameters getUnitTestParameters() {
        return this.unitTestParameters;
    }

    @Override
    protected String getResourceKey() {
        return this.owner + '.' + this.getId();
    }

    public boolean isPrivateCollection() {
        return this.privateCollection;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getInstantiator() {
        return this.instantiator;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        if (TextUtil.isBlank(this.type)) {
            this.type = XHelper.readString(elm, "@type");
        }
        if (TextUtil.isBlank(this.keyType)) {
            this.keyType = XHelper.readString(elm, "@key-type");
        }
        if (TextUtil.isBlank(this.instantiator)) {
            this.instantiator = XHelper.readString(elm, "instantiator");
        }
        if (TextUtil.isBlank(this.elementType)) {
            this.elementType = XHelper.readString(elm, "@element-type");
        }
        this.viewable = this.viewable || XHelper.readBoolean(elm, "@viewable", true);
        this.keyReference = this.keyReference || XHelper.readBoolean(elm, "@key-reference", false);
        this.reference = this.reference || XHelper.readBoolean(elm, "@reference", false);
        this.privateCollection = this.privateCollection || XHelper.readBoolean(elm, "@private", false);
        boolean bl = this.nullable = this.nullable || XHelper.readBoolean(elm, "@nullable", false);
        if (TextUtil.isBlank(this.format)) {
            this.format = XHelper.readString(elm, "@format");
        }
        for (Element paramElm : XmlUtil.getElements(elm, "param")) {
            this.parameters.put(XHelper.readString(paramElm, "@name"), XHelper.readString(paramElm, "@value"));
        }
        Element utpElm = XmlUtil.getElement(elm, "unit-test-parameters");
        if (utpElm != null) {
            this.unitTestParameters = new UnitTestParameters();
            this.unitTestParameters.fromXML(utpElm);
        }
        for (Map.Entry<String, String> entry : XmlUtil.getAttributes(elm).entrySet()) {
            if (!entry.getKey().contains("_")) continue;
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    public static class UnitTestParameters {
        private boolean ordered;
        private final List<String> designators = new ArrayList<String>();

        public boolean isOrdered() {
            return this.ordered;
        }

        public List<String> getDesignators() {
            return this.designators;
        }

        public void fromXML(Element elm) {
            this.ordered = XHelper.readBoolean(elm, "@ordered", true);
            String designatorsStr = XHelper.readString(elm, "@designators");
            if (!TextUtil.isBlank(designatorsStr)) {
                this.designators.addAll(Arrays.asList(designatorsStr.split(",")));
            }
        }
    }
}

