/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class EnumItem
extends BaseMetaElement {
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String codeFragment = null;
    private final String owner;

    EnumItem(String ownerId) {
        this.owner = ownerId;
    }

    public String getOwner() {
        return this.owner;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getCodeFragment() {
        return this.codeFragment;
    }

    @Override
    protected String getResourceKey() {
        return this.owner + '.' + this.getId();
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        this.codeFragment = XHelper.readString(elm, "code-fragment");
        for (Element paramElm : XmlUtil.getElements(elm, "param")) {
            this.parameters.put(XHelper.readString(paramElm, "@name"), XHelper.readString(paramElm, "@value"));
        }
    }
}

