/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class InterfaceType
extends BaseType {
    private final Set<String> interfaces = new LinkedHashSet<String>();
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();
    private final Map<String, EntityCollection> collections = new LinkedHashMap<String, EntityCollection>();

    InterfaceType() {
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(new ArrayList<String>(this.interfaces));
    }

    public Map<String, Property> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, EntityCollection> getCollections() {
        return Collections.unmodifiableMap(this.collections);
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        for (Element itfElm : XmlUtil.getElements(elm, "interface")) {
            this.interfaces.add(XmlUtil.getValue(itfElm, "@id"));
        }
        for (Element propElm : XmlUtil.getElements(elm, "property")) {
            String propId = XHelper.readString(propElm, "@id");
            Property prop = this.properties.get(propId);
            if (prop == null) {
                prop = new Property(this.getId());
                this.properties.put(propId, prop);
            }
            prop.fromXml(propElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "collection")) {
            String collId = XHelper.readString(collElm, "@id");
            EntityCollection coll = this.collections.get(collId);
            if (coll == null) {
                coll = new EntityCollection(this.getId());
                this.collections.put(collId, coll);
            }
            coll.fromXml(collElm, res);
        }
    }
}

