/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class XSerializableConcurrentMap<K, V>
extends ConcurrentHashMap<K, V>
implements XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = -7499353185115046750L;

    @Override
    public void toXML(Element elm) throws Exception {
        for (Map.Entry entry : this.entrySet()) {
            Element elem = XmlUtil.addElement(elm, "item");
            XHelper.writeObject(elem, "key", entry.getKey());
            XHelper.writeObject(elem, "value", entry.getValue());
        }
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        for (Map.Entry entry : this.entrySet()) {
            writer.writeStartElement("item");
            XSHelper.writeObject(writer, "key", entry.getKey());
            XSHelper.writeObject(writer, "value", entry.getValue());
            writer.writeEndElement();
        }
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.clear();
        for (Element elem : XmlUtil.getElements(elm, "item")) {
            this.put(XHelper.readObject(elem, "key"), XHelper.readObject(elem, "value"));
        }
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        this.clear();
        while (reader.nextTag() != 2) {
            if ("item".equals(reader.getName().getLocalPart())) {
                Object key = null;
                Object value = null;
                while (reader.nextTag() != 2) {
                    String tagName = reader.getName().getLocalPart();
                    if ("key".equals(tagName)) {
                        key = XSHelper.readObject(reader);
                        continue;
                    }
                    if ("value".equals(tagName)) {
                        value = XSHelper.readObject(reader);
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                this.put(key, value);
                continue;
            }
            XSHelper.skipElement(reader);
        }
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        XSerializableConcurrentMap clone = new XSerializableConcurrentMap();
        for (Map.Entry entry : this.entrySet()) {
            clone.put(XCloneHelper.cloneObject(entry.getKey(), newUids, uids), XCloneHelper.cloneObject(entry.getValue(), newUids, uids));
        }
        return clone;
    }
}

