/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.rest;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.rest.BaseRestType;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class RestEntityType
extends BaseRestType {
    private boolean isAbstract;
    private String extendsId;
    private boolean validatable;
    private boolean withMessages;
    private final Set<String> interfaces = new LinkedHashSet<String>();
    private final Set<String> descendants = new LinkedHashSet<String>();
    private final Map<String, RestProperty> properties = new LinkedHashMap<String, RestProperty>();
    private final Map<String, RestCollection> collections = new LinkedHashMap<String, RestCollection>();
    private final Map<String, RestMap> maps = new LinkedHashMap<String, RestMap>();

    RestEntityType() {
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String getExtendsId() {
        return this.extendsId;
    }

    public boolean isValidatable() {
        return this.validatable;
    }

    public boolean isWithMessages() {
        return this.withMessages;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public Set<String> getDescendants() {
        return this.descendants;
    }

    public Map<String, RestProperty> getProperties() {
        return this.properties;
    }

    public Map<String, RestCollection> getCollections() {
        return this.collections;
    }

    public Map<String, RestMap> getMaps() {
        return this.maps;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        String collId;
        super.fromXml(elm, res);
        boolean bl = this.isAbstract = this.isAbstract || XHelper.readBoolean(elm, "@abstract", false);
        if (this.extendsId == null) {
            this.extendsId = XHelper.readString(elm, "@extends");
        }
        this.validatable = this.validatable || XHelper.readBoolean(elm, "@validatable", false);
        this.withMessages = this.withMessages || XHelper.readBoolean(elm, "@with-messages", false);
        for (Element itfElm : XmlUtil.getElements(elm, "interface")) {
            this.interfaces.add(XmlUtil.getValue(itfElm, "@id"));
        }
        for (Element propElm : XmlUtil.getElements(elm, "property")) {
            String propId = XHelper.readString(propElm, "@id");
            RestProperty prop = this.properties.get(propId);
            if (prop == null) {
                prop = new RestProperty(this.getId());
                this.properties.put(propId, prop);
            }
            prop.fromXml(propElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "collection")) {
            collId = XHelper.readString(collElm, "@id");
            RestCollection coll = this.collections.get(collId);
            if (coll == null) {
                coll = new RestCollection(this.getId());
                this.collections.put(collId, coll);
            }
            coll.fromXml(collElm, res);
        }
        for (Element mapElm : XmlUtil.getElements(elm, "map")) {
            collId = XHelper.readString(mapElm, "@id");
            RestMap map = this.maps.get(collId);
            if (map == null) {
                map = new RestMap(this.getId());
                this.maps.put(collId, map);
            }
            map.fromXml(mapElm, res);
        }
    }
}

