/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.rest;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.rest.BaseRestType;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.w3c.dom.Element;

public class RestInterfaceType
extends BaseRestType {
    private final Collection<String> iterfaces = new LinkedHashSet<String>();
    private final Map<String, RestProperty> properties = new LinkedHashMap<String, RestProperty>();
    private final Map<String, RestCollection> collections = new LinkedHashMap<String, RestCollection>();

    public Map<String, RestProperty> getProperties() {
        return this.properties;
    }

    public Map<String, RestCollection> getCollections() {
        return this.collections;
    }

    public Collection<String> getInterfaces() {
        return this.iterfaces;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        for (Element propElm : XmlUtil.getElements(elm, "property")) {
            String propId = XHelper.readString(propElm, "@id");
            RestProperty prop = this.properties.get(propId);
            if (prop == null) {
                prop = new RestProperty(this.getId());
                this.properties.put(propId, prop);
            }
            prop.fromXml(propElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "collection")) {
            String collId = XHelper.readString(collElm, "@id");
            RestCollection coll = this.collections.get(collId);
            if (coll == null) {
                coll = new RestCollection(this.getId());
                this.collections.put(collId, coll);
            }
            coll.fromXml(collElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "interface")) {
            String interfaceId = XHelper.readString(collElm, "@id");
            if (this.iterfaces.contains(interfaceId)) continue;
            this.iterfaces.add(interfaceId);
        }
    }
}

