/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.rest;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.rest.BaseRestMetaElement;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestEnumType;
import com.gridnine.xtrip.common.meta.rest.RestInformationMessagesType;
import com.gridnine.xtrip.common.meta.rest.RestInterfaceType;
import com.gridnine.xtrip.common.meta.rest.RestService;
import com.gridnine.xtrip.common.meta.rest.RestServiceGroup;
import com.gridnine.xtrip.common.meta.rest.RestServiceOperation;
import com.gridnine.xtrip.common.meta.rest.RestServicePage;
import com.gridnine.xtrip.common.meta.rest.RestValidationMessagesType;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RestMetaRegistry
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Schema SCHEMA;
    private final Map<String, List<URL>> sources = new HashMap<String, List<URL>>();
    private final Map<String, RestEntityType> entities = new LinkedHashMap<String, RestEntityType>();
    private final Map<String, RestEnumType> enums = new LinkedHashMap<String, RestEnumType>();
    private final Map<String, RestValidationMessagesType> validationMessages = new LinkedHashMap<String, RestValidationMessagesType>();
    private final Map<String, RestInformationMessagesType> informationMessages = new LinkedHashMap<String, RestInformationMessagesType>();
    private final Map<String, RestService> services = new LinkedHashMap<String, RestService>();
    private final Map<String, RestInterfaceType> interfaces = new LinkedHashMap<String, RestInterfaceType>();

    public static RestMetaRegistry get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(RestMetaRegistry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(final URL meta) throws Exception {
        this.log.debug("registering meta data from " + meta);
        try (InputStream strm = meta.openStream();){
            RestService service;
            String serviceId;
            String id;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            if (SCHEMA != null) {
                factory.setSchema(SCHEMA);
            }
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    System.out.println(meta);
                    throw ex;
                }

                @Override
                public void fatalError(SAXParseException ex) throws SAXException {
                    System.out.println(meta);
                    throw ex;
                }

                @Override
                public void warning(SAXParseException ex) {
                }
            });
            Resources resources = new Resources(meta);
            Element root = docBuilder.parse(strm).getDocumentElement();
            this.appendElements(this.entities, XmlUtil.getElements(root, "entity"), new ObjectFactory<RestEntityType>(){

                @Override
                public RestEntityType createObject() {
                    return new RestEntityType();
                }
            }, meta, resources);
            this.appendElements(this.enums, XmlUtil.getElements(root, "enum"), new ObjectFactory<RestEnumType>(){

                @Override
                public RestEnumType createObject() {
                    return new RestEnumType();
                }
            }, meta, resources);
            this.appendElements(this.validationMessages, XmlUtil.getElements(root, "validation-messages"), new ObjectFactory<RestValidationMessagesType>(){

                @Override
                public RestValidationMessagesType createObject() {
                    return new RestValidationMessagesType();
                }
            }, meta, resources);
            this.appendElements(this.informationMessages, XmlUtil.getElements(root, "information-messages"), new ObjectFactory<RestInformationMessagesType>(){

                @Override
                public RestInformationMessagesType createObject() {
                    return new RestInformationMessagesType();
                }
            }, meta, resources);
            this.appendElements(this.services, XmlUtil.getElements(root, "service"), new ObjectFactory<RestService>(){

                @Override
                public RestService createObject() {
                    return new RestService();
                }
            }, meta, resources);
            this.appendElements(this.interfaces, XmlUtil.getElements(root, "interface"), new ObjectFactory<RestInterfaceType>(){

                @Override
                public RestInterfaceType createObject() {
                    return new RestInterfaceType();
                }
            }, meta, resources);
            for (Element elm : XmlUtil.getElements(root, "service-group")) {
                id = XHelper.readString(elm, "@id");
                serviceId = XHelper.readString(elm, "@service-id");
                service = this.services.get(serviceId);
                if (service == null) {
                    this.log.error(String.format("unknown service %s for group %s", serviceId, id));
                    continue;
                }
                RestServiceGroup group = service.getGroups().get(id);
                if (group == null) {
                    group = new RestServiceGroup();
                    service.getGroups().put(id, group);
                }
                group.fromXml(elm, resources);
                this.addSource(group, meta);
            }
            for (Element elm : XmlUtil.getElements(root, "service-operation")) {
                id = XHelper.readString(elm, "@id");
                serviceId = XHelper.readString(elm, "@service-id");
                service = this.services.get(serviceId);
                if (service == null) {
                    this.log.error(String.format("unknown service %s for operation %s", serviceId, id));
                    continue;
                }
                RestServiceOperation op = service.getOperations().get(id);
                if (op == null) {
                    op = new RestServiceOperation();
                    service.getOperations().put(id, op);
                    op.fromXml(elm, resources);
                    this.addSource(op, meta);
                    continue;
                }
                RestServiceOperation dup = new RestServiceOperation();
                dup.fromXml(elm, resources);
                throw new IllegalStateException(String.format("Service operations duplication detected.%n1: id = %s, method = %s, path = %s%n2: id = %s, method = %s, path = %s%nIDs must differ.", op.getId(), op.getMethod(), op.getPath(), dup.getId(), dup.getMethod(), dup.getPath()));
            }
            for (Element elm : XmlUtil.getElements(root, "service-page")) {
                id = XHelper.readString(elm, "@id");
                serviceId = XHelper.readString(elm, "@service-id");
                service = this.services.get(serviceId);
                if (service == null) {
                    this.log.error(String.format("unknown service %s for page %s", serviceId, id));
                    continue;
                }
                RestServicePage page = service.getPages().get(id);
                if (page == null) {
                    page = new RestServicePage();
                    service.getPages().put(id, page);
                }
                page.fromXml(elm, resources);
                this.addSource(page, meta);
            }
        }
        this.log.info("meta data registered from " + meta);
    }

    public Collection<URL> getSources(BaseRestMetaElement metaElm) {
        List<URL> result = this.sources.get(metaElm.getId());
        return result == null ? Collections.emptyList() : result;
    }

    public Map<String, RestEntityType> getEntities() {
        return Collections.unmodifiableMap(this.entities);
    }

    public Map<String, RestEnumType> getEnums() {
        return Collections.unmodifiableMap(this.enums);
    }

    public Map<String, RestValidationMessagesType> getValidationMessages() {
        return Collections.unmodifiableMap(this.validationMessages);
    }

    public Map<String, RestInformationMessagesType> getInformationMessages() {
        return Collections.unmodifiableMap(this.informationMessages);
    }

    public Map<String, RestService> getServices() {
        return Collections.unmodifiableMap(this.services);
    }

    public Map<String, RestInterfaceType> getInterfaces() {
        return Collections.unmodifiableMap(this.interfaces);
    }

    private void addSource(BaseRestMetaElement metaElm, URL source) {
        List<URL> list = this.sources.get(metaElm.getId());
        if (list == null) {
            list = new ArrayList<URL>();
            this.sources.put(metaElm.getId(), list);
        }
        if (!list.contains(source)) {
            list.add(source);
        }
    }

    private <T extends BaseRestMetaElement> void appendElements(Map<String, T> map, Element[] elements, ObjectFactory<T> factory, URL meta, Resources resources) {
        for (Element elm : elements) {
            String id = XHelper.readString(elm, "@id");
            BaseRestMetaElement item = (BaseRestMetaElement)map.get(id);
            if (item == null) {
                item = (BaseRestMetaElement)factory.createObject();
                map.put(id, item);
            }
            item.fromXml(elm, resources);
            this.addSource(item, meta);
        }
    }

    @Override
    public void dispose() {
        this.services.clear();
        this.enums.clear();
        this.validationMessages.clear();
        this.informationMessages.clear();
        this.entities.clear();
        this.sources.clear();
        this.interfaces.clear();
        this.log.debug("disposed");
    }

    static {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(RestMetaRegistry.class.getResource("restmodel_1_0.xsd"));
        }
        catch (SAXException e) {
            LoggerFactory.getLogger(RestMetaRegistry.class).error("failed loading XML schema", (Throwable)e);
        }
        SCHEMA = schema;
    }

    private static class Holder {
        public static final RestMetaRegistry INSTANCE = Environment.getPublished(RestMetaRegistry.class);

        private Holder() {
        }
    }
}

