/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.rest;

import com.gridnine.xtrip.common.meta.rest.BaseTypeMember;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestEnumType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.meta.rest.RestStringWithLang;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RestMetaRegistryHelper {
    public static RestEntityType getEntityType(String id) {
        return RestMetaRegistry.get().getEntities().get(id);
    }

    public static RestEnumType getEnumType(String id) {
        return RestMetaRegistry.get().getEnums().get(id);
    }

    public static Map<String, RestProperty> getAllProperties(RestEntityType type) {
        LinkedHashMap<String, RestProperty> result = new LinkedHashMap<String, RestProperty>();
        RestMetaRegistryHelper.collectProperties(result, type);
        return result;
    }

    private static void collectProperties(Map<String, RestProperty> properties, RestEntityType type) {
        if (type.getExtendsId() != null) {
            RestMetaRegistryHelper.collectProperties(properties, RestMetaRegistry.get().getEntities().get(type.getExtendsId()));
        }
        for (RestProperty property : type.getProperties().values()) {
            properties.put(property.getId(), property);
        }
    }

    public static Map<String, RestCollection> getAllCollections(RestEntityType type) {
        LinkedHashMap<String, RestCollection> result = new LinkedHashMap<String, RestCollection>();
        RestMetaRegistryHelper.collectCollections(result, type);
        return result;
    }

    private static void collectCollections(Map<String, RestCollection> collections, RestEntityType type) {
        if (type.getExtendsId() != null) {
            RestMetaRegistryHelper.collectCollections(collections, RestMetaRegistry.get().getEntities().get(type.getExtendsId()));
        }
        for (RestCollection collection : type.getCollections().values()) {
            collections.put(collection.getId(), collection);
        }
    }

    public static Map<String, RestMap> getAllMaps(RestEntityType type) {
        LinkedHashMap<String, RestMap> result = new LinkedHashMap<String, RestMap>();
        RestMetaRegistryHelper.collectMaps(result, type);
        return result;
    }

    private static void collectMaps(Map<String, RestMap> maps, RestEntityType type) {
        if (type.getExtendsId() != null) {
            RestMetaRegistryHelper.collectMaps(maps, RestMetaRegistry.get().getEntities().get(type.getExtendsId()));
        }
        for (RestMap map : type.getMaps().values()) {
            maps.put(map.getId(), map);
        }
    }

    public static Map<String, BaseTypeMember> getAllMembers(RestEntityType type) {
        LinkedHashMap<String, BaseTypeMember> result = new LinkedHashMap<String, BaseTypeMember>();
        result.putAll(RestMetaRegistryHelper.getAllProperties(type));
        result.putAll(RestMetaRegistryHelper.getAllCollections(type));
        result.putAll(RestMetaRegistryHelper.getAllMaps(type));
        return result;
    }

    public static String getNullableCollectionPropName(String collId) {
        return String.format("%sEqualNull", collId);
    }

    public static String joinStrings(String delimiter, List<RestStringWithLang> strings, String lang) {
        return String.join((CharSequence)delimiter, RestMetaRegistryHelper.getStrings(strings, lang));
    }

    public static List<String> getStrings(List<RestStringWithLang> strings, String lang) {
        List<String> result = RestMetaRegistryHelper.getStringsInternal(strings, lang);
        return result.isEmpty() && lang != null ? RestMetaRegistryHelper.getStringsInternal(strings, null) : result;
    }

    private static List<String> getStringsInternal(List<RestStringWithLang> strings, String lang) {
        return strings.stream().filter(d -> Objects.equals(lang, d.getLang())).map(RestStringWithLang::getValue).collect(Collectors.toList());
    }
}

