/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.meta.ui.UiCellsContainer;
import com.gridnine.xtrip.common.meta.ui.UiGridContainer;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.meta.ui.UiSimpleContainer;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import org.w3c.dom.Element;

public abstract class BaseUiContainer
extends BaseUiMetaElement {
    private UiModel model;

    static BaseUiContainer read(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        String id = XHelper.readString(elm, "@id");
        if ("grid-container".equals(elm.getTagName())) {
            UiGridContainer result = callback.getOrCreateContainer(id, () -> new UiGridContainer());
            result.fromXml(elm, res, callback);
            return result;
        }
        if ("cells-container".equals(elm.getTagName())) {
            UiCellsContainer result = callback.getOrCreateContainer(id, () -> new UiCellsContainer());
            result.fromXml(elm, res, callback);
            return result;
        }
        if ("cards-container".equals(elm.getTagName())) {
            UiCardsContainer result = callback.getOrCreateContainer(id, () -> new UiCardsContainer());
            result.fromXml(elm, res, callback);
            return result;
        }
        if ("simple-container".equals(elm.getTagName())) {
            UiSimpleContainer result = callback.getOrCreateContainer(id, () -> new UiSimpleContainer());
            result.fromXml(elm, res, callback);
            return result;
        }
        return null;
    }

    @Override
    protected String getResourceKey() {
        return this.getId();
    }

    public UiModel getModel() {
        return this.model;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        throw new UnsupportedOperationException();
    }

    void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        Element modelElm;
        super.fromXml(elm, res);
        Element aclElm = XmlUtil.getElement(elm, "acl");
        if (aclElm != null) {
            this.acl = new UiAclResource();
            this.acl.fromXml(aclElm, res, callback);
        }
        if ((modelElm = XmlUtil.getElement(elm, "model")) != null) {
            if (this.model == null) {
                this.model = new UiModel();
            }
            this.model.fromXml(modelElm);
        }
    }
}

