/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainerCell;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.ListWithInjections;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class UiGridContainer
extends BaseUiContainer {
    private final List<UiModel.Field> properties = new ArrayList<UiModel.Field>();
    private final ListWithInjections<Cell> cells = new ListWithInjections<Cell>(BaseMetaElement::getId);
    private int columns;
    private boolean adaptive;

    public static boolean isNewRowMarker(Cell cell) {
        return cell == null;
    }

    UiGridContainer() {
    }

    public List<UiModel.Field> getProperties() {
        return this.properties;
    }

    public List<Cell> getCells() {
        return this.cells.asList();
    }

    public int getColumns() {
        return this.columns;
    }

    public boolean isAdaptive() {
        return this.adaptive;
    }

    @Override
    void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        super.fromXml(elm, res, callback);
        for (Element childElm : XmlUtil.getChildren(elm)) {
            if ("model".equals(childElm.getTagName()) || "acl".equals(childElm.getTagName())) continue;
            if ("property".equals(childElm.getTagName())) {
                UiModel.Field prop = new UiModel.Field();
                prop.fromXml(childElm);
                this.properties.add(prop);
                continue;
            }
            if ("new-row".equals(childElm.getTagName())) {
                this.cells.addOrInject(null, XHelper.readString(childElm, "@insert-before"), XHelper.readString(childElm, "@insert-after"));
                continue;
            }
            if ("cell".equals(childElm.getTagName())) {
                Cell cell = new Cell(this.getId());
                cell.fromXml(childElm, res, callback);
                this.cells.addOrInject(cell, XHelper.readString(childElm, "@insert-before"), XHelper.readString(childElm, "@insert-after"));
                continue;
            }
            throw Xeption.forDeveloper("unsupported tag {0}", childElm.getTagName());
        }
        int val = XHelper.readInt(elm, "@columns", 0);
        if (val > this.columns) {
            this.columns = val;
        }
        this.adaptive = XHelper.readBoolean(elm, "@adaptive", this.adaptive);
    }

    public static class Cell
    extends BaseUiContainerCell {
        private UiLabel caption;
        private UiLabel help;
        private UiElement payload;
        private boolean hidden;

        Cell(String ownerId) {
            super(ownerId);
        }

        public UiLabel getCaption() {
            return this.caption;
        }

        public UiLabel getHelp() {
            return this.help;
        }

        public UiElement getPayload() {
            return this.payload;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            this.hidden = XHelper.readBoolean(elm, "@hidden", false);
            for (Element childElm : XmlUtil.getChildren(elm)) {
                BaseUiContainer ctr;
                if ("acl".equals(childElm.getTagName())) {
                    this.acl = new UiAclResource();
                    this.acl.fromXml(childElm, res, callback);
                    continue;
                }
                if ("caption".equals(childElm.getTagName())) {
                    this.caption = callback.getOrCreateLabel(childElm);
                    continue;
                }
                if ("help".equals(childElm.getTagName())) {
                    this.help = callback.getOrCreateLabel(childElm);
                    continue;
                }
                this.payload = "container-ref".equals(childElm.getTagName()) ? new UiContainerReference(XHelper.readString(childElm, "@id")) : ((ctr = BaseUiContainer.read(childElm, res, callback)) != null ? new UiContainerReference(ctr.getId()) : BaseUiWidget.read(childElm, res, callback));
            }
            if (this.payload == null) {
                throw Xeption.forDeveloper("no payload found for grid container cell {0}", this.getId());
            }
        }
    }
}

