/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class UiModel {
    private String className;
    private String extendsId;
    private final List<String> interfaces = new ArrayList<String>();
    private final List<Field> fields = new ArrayList<Field>();

    UiModel() {
    }

    public String getClassName() {
        return this.className;
    }

    public String getExtendsId() {
        return this.extendsId;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    void fromXml(Element elm) {
        this.className = XHelper.readString(elm, "@class");
        String str = XHelper.readString(elm, "@extends");
        if (str != null) {
            this.extendsId = str;
        }
        for (Element itfElm : XmlUtil.getElements(elm, "interface")) {
            this.interfaces.add(XHelper.readString(itfElm, "."));
        }
        for (Element fldElm : XmlUtil.getElements(elm, "field")) {
            Field field = new Field();
            field.fromXml(fldElm);
            this.fields.add(field);
        }
    }

    public static class Field {
        private String id;
        private String type;
        private boolean collection;

        Field() {
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public boolean isCollection() {
            return this.collection;
        }

        void fromXml(Element elm) {
            this.id = XHelper.readString(elm, "@id");
            this.type = XHelper.readString(elm, "@type");
            this.collection = XHelper.readBoolean(elm, "@collection", false);
        }
    }
}

