/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import com.gridnine.xtrip.common.util.XmlUtil;
import org.w3c.dom.Element;

public class UiTile
extends BaseUiMetaElement {
    private final String ownerId;
    private UiLabel caption;
    private UiLabel help;
    private UiElement compactPayload;
    private UiElement fullPayload;

    UiTile(String owner) {
        this.ownerId = owner;
    }

    public UiLabel getCaption() {
        return this.caption;
    }

    public UiLabel getHelp() {
        return this.help;
    }

    public UiElement getCompactPayload() {
        return this.compactPayload;
    }

    public UiElement getFullPayload() {
        return this.fullPayload;
    }

    @Override
    protected String getResourceKey() {
        return this.ownerId + '.' + this.getId();
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        throw new UnsupportedOperationException();
    }

    void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        Element payloadElm;
        Element helpElm;
        Element captionElm;
        super.fromXml(elm, res);
        Element aclElm = XmlUtil.getElement(elm, "acl");
        if (aclElm != null) {
            this.acl = new UiAclResource();
            this.acl.fromXml(aclElm, res, callback);
        }
        if ((captionElm = XmlUtil.getElement(elm, "caption")) != null) {
            this.caption = callback.getOrCreateLabel(captionElm);
        }
        if ((helpElm = XmlUtil.getElement(elm, "help")) != null) {
            this.help = callback.getOrCreateLabel(helpElm);
        }
        if ((payloadElm = XmlUtil.getElement(elm, "compact-view")) != null) {
            this.compactPayload = UiTilesSpace.readPayload(payloadElm, res, callback);
        }
        if ((payloadElm = XmlUtil.getElement(elm, "full-view")) != null) {
            this.fullPayload = UiTilesSpace.readPayload(payloadElm, res, callback);
        }
    }
}

