/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.ListWithInjections;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.List;
import org.w3c.dom.Element;

public class UiWidgetTableBox
extends BaseUiWidget {
    private UiModel model;
    private UiLabel placeholder;
    private boolean reorderable;
    private boolean extended;
    private final ListWithInjections<BaseColumn> columns = new ListWithInjections<BaseColumn>(BaseColumn::getId);

    UiWidgetTableBox() {
    }

    public UiModel getModel() {
        return this.model;
    }

    public UiLabel getPlaceholder() {
        return this.placeholder;
    }

    public boolean isReorderable() {
        return this.reorderable;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public List<BaseColumn> getColumns() {
        return this.columns.asList();
    }

    @Override
    protected void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        super.fromXml(elm, res, callback);
        for (Element childElm : XmlUtil.getChildren(elm)) {
            BaseColumn col;
            if ("model".equals(childElm.getTagName())) {
                if (this.model == null) {
                    this.model = new UiModel();
                }
                this.model.fromXml(childElm);
                continue;
            }
            if ("placeholder".equals(childElm.getTagName())) {
                this.placeholder = callback.getOrCreateLabel(childElm);
                continue;
            }
            if ("column".equals(childElm.getTagName())) {
                col = new WidgetColumn();
            } else if ("super-column".equals(childElm.getTagName())) {
                col = new SuperColumn();
            } else {
                if (!"custom-column".equals(childElm.getTagName())) continue;
                col = new CustomColumn();
            }
            ((BaseColumn)col).fromXml(childElm, res, callback);
            this.columns.addOrInject(col, XHelper.readString(childElm, "@insert-before"), XHelper.readString(childElm, "@insert-after"));
        }
        this.reorderable = XHelper.readBoolean(elm, "@reorderable", this.reorderable);
        this.extended = XHelper.readBoolean(elm, "@extended", this.extended);
    }

    public static class CustomColumn
    extends BaseColumn {
        private String widgetClassName;
        private String modelClassName;

        CustomColumn() {
        }

        public String getWidgetClassName() {
            return this.widgetClassName;
        }

        public String getModelClassName() {
            return this.modelClassName;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            this.widgetClassName = XHelper.readString(elm, "@widget-class");
            this.modelClassName = XHelper.readString(elm, "@model-class");
        }
    }

    public static class SuperColumn
    extends BaseColumn {
        private UiContainerReference payload;

        SuperColumn() {
        }

        public UiContainerReference getPayload() {
            return this.payload;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            for (Element childElm : XmlUtil.getChildren(elm)) {
                if ("container-ref".equals(childElm.getTagName())) {
                    this.payload = new UiContainerReference(XHelper.readString(childElm, "@id"));
                    continue;
                }
                BaseUiContainer ctr = BaseUiContainer.read(childElm, res, callback);
                if (ctr == null) continue;
                this.payload = new UiContainerReference(ctr.getId());
            }
            if (this.payload == null) {
                throw Xeption.forDeveloper("no payload found for column {0}", this.getId());
            }
        }
    }

    public static class WidgetColumn
    extends BaseColumn {
        private BaseUiWidget widget;
        private Double prefWidth;
        private Double prefWidthEm;
        private Double maxWidthEm;
        private Double minWidthEm;
        private boolean notHGrowable;

        WidgetColumn() {
        }

        public BaseUiWidget getWidget() {
            return this.widget;
        }

        public Double getPrefWidth() {
            return this.prefWidth;
        }

        public Double getPrefWidthEm() {
            return this.prefWidthEm;
        }

        public Double getMaxWidthEm() {
            return this.maxWidthEm;
        }

        public Double getMinWidthEm() {
            return this.minWidthEm;
        }

        public boolean isNotHGrowable() {
            return this.notHGrowable;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            this.prefWidth = XHelper.readDouble(elm, "@pref-width");
            this.prefWidthEm = XHelper.readDouble(elm, "@pref-width-em");
            this.maxWidthEm = XHelper.readDouble(elm, "@max-width-em");
            this.minWidthEm = XHelper.readDouble(elm, "@min-width-em");
            this.notHGrowable = XHelper.readBoolean(elm, "@notHGrowable", this.notHGrowable);
            for (Element childElm : XmlUtil.getChildren(elm)) {
                this.widget = BaseUiWidget.read(childElm, res, callback);
            }
            if (this.widget == null) {
                throw Xeption.forDeveloper("no widget found for column {0}", this.getId());
            }
        }
    }

    public static abstract class BaseColumn {
        private UiAclResource acl;
        private UiLabel caption;
        private UiLabel help;
        private String id;

        public UiAclResource getAcl() {
            return this.acl;
        }

        public UiLabel getCaption() {
            return this.caption;
        }

        public UiLabel getHelp() {
            return this.help;
        }

        public String getId() {
            return this.id;
        }

        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            this.id = XHelper.readString(elm, "@id");
            for (Element childElm : XmlUtil.getChildren(elm)) {
                if ("acl".equals(childElm.getTagName())) {
                    this.acl = new UiAclResource();
                    this.acl.fromXml(childElm, res, callback);
                    continue;
                }
                if ("caption".equals(childElm.getTagName())) {
                    this.caption = callback.getOrCreateLabel(childElm);
                    continue;
                }
                if (!"help".equals(childElm.getTagName())) continue;
                this.help = callback.getOrCreateLabel(childElm);
            }
        }
    }
}

