/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XReference;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class EntityReference<T extends BaseEntity>
implements Identity,
Serializable,
XSerializable,
XSSerializable,
XCloneable,
XReference {
    private static final long serialVersionUID = -8004508858989347812L;
    private String uid;
    private String caption;
    private transient Class<T> type;
    private String lockKey;

    public EntityReference() {
    }

    public EntityReference(EntityContainer<T> ect) {
        this.setUid(ect.getUid());
        this.setType(ect.getEntityType());
        this.setCaption(((BaseEntity)ect.getEntity()).toString());
    }

    public EntityReference(String etcUid, Class<T> etCls, String etCaption) {
        this.setUid(etcUid);
        this.setType(etCls);
        this.setCaption(etCaption);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String value) {
        this.caption = value;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> value) {
        this.type = value;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public void setUid(String value) {
        this.uid = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityReference)) {
            return false;
        }
        EntityReference other = (EntityReference)obj;
        if (this.getUid() != null ? !this.getUid().equals(other.getUid()) : other.getUid() != null) {
            return false;
        }
        return !(this.getType() != null ? !this.getType().equals(other.getType()) : other.getType() != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toLockKey() {
        if (this.lockKey == null) {
            this.lockKey = TextUtil.concat("class ", this.type.getName(), ".", this.uid);
        }
        return this.lockKey;
    }

    public String toString() {
        String result = this.getCaption();
        return TextUtil.nonBlank(result) ? result.trim() : String.format("{%s: uid=%s}", this.getType() == null ? null : this.getType().getName(), this.getUid());
    }

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeString(elm, "uid", this.getUid());
        XHelper.writeString(elm, "type", this.getType().getName());
        XHelper.writeString(elm, "caption", this.getCaption(), true);
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "uid", this.getUid());
        XSHelper.writeString(writer, "type", this.getType().getName());
        XSHelper.writeString(writer, "caption", this.getCaption(), true);
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.setUid(XHelper.readString(elm, "uid"));
        this.setType(XHelper.getClass(XHelper.readString(elm, "type")));
        this.setCaption(XHelper.readString(elm, "caption"));
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("uid".equals(tagName)) {
            this.setUid(XSHelper.readString(reader));
            return true;
        }
        if ("type".equals(tagName)) {
            this.setType(XSHelper.getClass(XSHelper.readString(reader)));
            return true;
        }
        if ("caption".equals(tagName)) {
            this.setCaption(XSHelper.readString(reader));
            return true;
        }
        return false;
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            if (this.readXMLElement(reader)) continue;
            XSHelper.skipElement(reader);
        }
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        EntityReference clone = (EntityReference)this.getClass().newInstance();
        clone.copyFrom(this, newUids, uids);
        return clone;
    }

    protected void copyFrom(EntityReference sourceEntityReference, boolean newUids, Map<String, String> uids) throws Exception {
        this.uid = uids.containsKey(sourceEntityReference.uid) ? uids.get(sourceEntityReference.uid) : sourceEntityReference.uid;
        this.type = sourceEntityReference.type;
        this.caption = sourceEntityReference.caption;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.type == null ? "" : this.type.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String className = in.readUTF();
        this.type = TextUtil.isBlank(className) ? null : XSHelper.getClass(className);
    }
}

